/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.api.cooldown.ICooldownHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCooldownMessage;
import ovh.corail.tombstone.registry.ModItems;

public final class CooldownHandler
implements ICooldownHandler {
    public static final CooldownHandler INSTANCE = new CooldownHandler();
    private final Map<UUID, EnumMap<CooldownType, Long>> cooldowns = new HashMap<UUID, EnumMap<CooldownType, Long>>();
    private EnumMap<CooldownType, Long> clientCooldowns = new EnumMap(CooldownType.class);
    public static final String COOLDOWNS_NBT_LIST = "tb_cooldowns";
    private static final String ID_NBT_BYTE = "id";
    private static final String CD_NBT_LONG = "cd";
    private static final BiPredicate<INBT, CooldownType> FIND_BY_TYPE = (nbt, type) -> ((CompoundNBT)nbt).func_74771_c(ID_NBT_BYTE) == (byte)type.ordinal();
    private static final Function<Byte, CooldownType> FIND_BY_ID = id -> id >= 0 && id < CooldownType.values().length ? CooldownType.values()[id] : null;

    private CooldownHandler() {
        CooldownType.NEXT_PRAY.setMaxCooldown(player -> TimeHelper.tickFromHour((Integer)SharedConfigTombstone.decorative_grave.cooldownToPray.get()));
        CooldownType.RESET_PERKS.setMaxCooldown(player -> TimeHelper.tickFromMinute((Integer)SharedConfigTombstone.decorative_grave.cooldownResetPerk.get()));
        CooldownType.TELEPORT_DEATH.setMaxCooldown(player -> TimeHelper.tickFromMinute((Integer)ConfigTombstone.general.cooldownTeleportDeath.get()));
        CooldownType.TELEPORT_BIND.setMaxCooldown(player -> TimeHelper.tickFromMinute((Integer)ConfigTombstone.general.cooldownTeleportBind.get()));
        CooldownType.REQUEST_TELEPORT.setMaxCooldown(player -> TimeHelper.tickFromMinute((Integer)ConfigTombstone.general.cooldownRequestTeleport.get()));
    }

    @Override
    public int getCooldown(PlayerEntity player, CooldownType type) {
        if (player.field_70170_p.func_201670_d()) {
            return this.getCooldown(type);
        }
        EnumMap entry = this.cooldowns.computeIfAbsent(player.func_110124_au(), aId -> this.computePlayerCd((ServerPlayerEntity)player));
        long worldTimeCD = entry.getOrDefault((Object)type, -1L);
        if (worldTimeCD > 0L) {
            long cooldown = worldTimeCD - TimeHelper.worldTicks(player.field_70170_p);
            if (cooldown <= 0L && entry.remove((Object)type) != null) {
                this.getCooldownTagList(player).removeIf(inbt -> FIND_BY_TYPE.test((INBT)inbt, type));
                return 0;
            }
            if (cooldown > (long)type.getMaxCooldown(player)) {
                return this.resetCooldown((ServerPlayerEntity)player, type);
            }
            return Math.max((int)cooldown, 0);
        }
        return 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getCooldown(CooldownType type) {
        long cd = this.clientCooldowns.getOrDefault((Object)type, -1L);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return player != null && cd > 0L ? Math.max(0, (int)(cd - TimeHelper.worldTicks(player.field_70170_p))) : 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCooldown(CooldownType type) {
        return this.getCooldown(type) > 0;
    }

    @Override
    public boolean hasCooldown(PlayerEntity player, CooldownType type) {
        return this.getCooldown(player, type) > 0;
    }

    public boolean noCooldown(PlayerEntity player, CooldownType type) {
        return this.getCooldown(player, type) <= 0;
    }

    @Override
    public int resetCooldown(ServerPlayerEntity player, CooldownType type) {
        if (!EntityHelper.isValidServerPlayer((PlayerEntity)player)) {
            return 0;
        }
        int maxCD = type.getMaxCooldown((PlayerEntity)player);
        this.setWorldTimeCooldown(player, type, TimeHelper.worldTicks(player.field_70170_p) + (long)maxCD);
        return maxCD;
    }

    @Override
    public int setCooldown(ServerPlayerEntity player, CooldownType type, int time) {
        if (!EntityHelper.isValidServerPlayer((PlayerEntity)player)) {
            return 0;
        }
        int cappedTime = Math.min(time, type.getMaxCooldown((PlayerEntity)player));
        this.setWorldTimeCooldown(player, type, TimeHelper.worldTicks(player.field_70170_p) + (long)cappedTime);
        return cappedTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateClientCooldown(CooldownType type, long worldTime) {
        this.clientCooldowns.put(type, worldTime);
        if (type == CooldownType.NEXT_PRAY) {
            EntityHelper.removeGlobalItemCooldown((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ModItems.ankh_of_pray);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateAllClientCooldowns(ListNBT tagList) {
        this.clientCooldowns = this.computePlayerCd(tagList);
        EntityHelper.removeGlobalItemCooldown((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ModItems.ankh_of_pray);
    }

    private void setWorldTimeCooldown(ServerPlayerEntity player, CooldownType type, long worldTime) {
        this.setWorldTimeCooldown(player, type, worldTime, true);
    }

    private void setWorldTimeCooldown(ServerPlayerEntity player, CooldownType type, long worldTime, boolean checkSync) {
        ListNBT tagList = this.getCooldownTagList((PlayerEntity)player);
        boolean isSet = tagList.stream().filter(inbt -> FIND_BY_TYPE.test((INBT)inbt, type)).findFirst().map(inbt -> {
            ((CompoundNBT)inbt).func_74772_a(CD_NBT_LONG, worldTime);
            return true;
        }).orElse(false);
        if (!isSet) {
            this.writeCooldown(tagList, type, worldTime);
        }
        this.cooldowns.computeIfAbsent(player.func_110124_au(), aId -> this.computePlayerCd(player)).put(type, worldTime);
        if (checkSync && type.isSync()) {
            PacketHandler.sendToPlayer(new SyncCooldownMessage(type, worldTime), player);
        }
    }

    public void updateWorldTime(ServerPlayerEntity player, long modifier) {
        if (!EntityHelper.isValidServerPlayer((PlayerEntity)player)) {
            return;
        }
        boolean requirePacket = false;
        for (CooldownType type : CooldownType.values()) {
            int cd = this.getCooldown((PlayerEntity)player, type);
            if (cd <= 0) continue;
            requirePacket = true;
            this.setWorldTimeCooldown(player, type, (long)cd + modifier, false);
        }
        if (requirePacket) {
            PacketHandler.sendToPlayer(this.getCooldownPacket(player), player);
        }
    }

    private EnumMap<CooldownType, Long> computePlayerCd(ServerPlayerEntity player) {
        return this.computePlayerCd(this.getCooldownTagList((PlayerEntity)player));
    }

    private EnumMap<CooldownType, Long> computePlayerCd(ListNBT tagList) {
        EnumMap<CooldownType, Long> playerCooldowns = new EnumMap<CooldownType, Long>(CooldownType.class);
        tagList.forEach(inbt -> {
            CompoundNBT nbt = (CompoundNBT)inbt;
            CooldownType id = FIND_BY_ID.apply(nbt.func_74771_c(ID_NBT_BYTE));
            if (id != null) {
                playerCooldowns.put(id, nbt.func_74763_f(CD_NBT_LONG));
            }
        });
        return playerCooldowns;
    }

    private ListNBT getCooldownTagList(PlayerEntity player) {
        return NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag(player), COOLDOWNS_NBT_LIST);
    }

    public SyncCooldownMessage getCooldownPacket(ServerPlayerEntity player) {
        ListNBT initTagList = this.getCooldownTagList((PlayerEntity)player);
        EnumMap entry = this.cooldowns.computeIfAbsent(player.func_110124_au(), aId -> this.computePlayerCd(initTagList));
        ListNBT tagList = new ListNBT();
        Arrays.stream(CooldownType.values()).filter(CooldownType::isSync).forEach(type -> {
            long worldTimeCD = entry.getOrDefault(type, -1L);
            if (worldTimeCD > 0L) {
                long cooldown = worldTimeCD - TimeHelper.worldTicks(player.field_70170_p);
                int maxCD = type.getMaxCooldown((PlayerEntity)player);
                if (cooldown <= 0L && entry.remove(type) != null) {
                    initTagList.removeIf(inbt -> FIND_BY_TYPE.test((INBT)inbt, (CooldownType)((Object)type)));
                    worldTimeCD = -1L;
                }
                if (cooldown > (long)maxCD) {
                    worldTimeCD = TimeHelper.worldTicks(player.field_70170_p) + (long)maxCD;
                    this.setWorldTimeCooldown(player, (CooldownType)((Object)type), worldTimeCD);
                }
            }
            this.writeCooldown(tagList, (CooldownType)((Object)type), worldTimeCD);
        });
        return new SyncCooldownMessage(tagList);
    }

    private void writeCooldown(ListNBT tagList, CooldownType type, long worldTime) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74774_a(ID_NBT_BYTE, (byte)type.ordinal());
        nbt.func_74772_a(CD_NBT_LONG, worldTime);
        tagList.add((Object)nbt);
    }

    public void clear() {
        this.cooldowns.clear();
    }
}

