/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.GuiConfig;
import ovh.corail.tombstone.gui.GuiInfo;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemAdvancement;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpgradePerkServerMessage;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;

@OnlyIn(value=Dist.CLIENT)
public class GuiKnowledge
extends TBScreen {
    private static final ResourceLocation GUI_BAR = new ResourceLocation("minecraft", "textures/gui/bars.png");
    private final ClientPlayerEntity player;
    private final ITBCapability cap;
    private final int upgradableLevelMax;
    private final List<PerkIcon> icons = new ArrayList<PerkIcon>();
    private PerkIcon hoveredIcon;
    private int leftPerkPoints;
    private int hoveredPerkLevel = 0;
    private final ItemStack stackSkull = ItemAdvancement.IconType.FIRST_PRAY.getItemStack();
    private final ItemStack stackRevive = ItemAdvancement.IconType.REVIVE.getItemStack();
    private final ItemStack stackAnkh = ItemAdvancement.IconType.FIRST_PRAY.getItemStack();
    private final double alignmentPos;
    private final List<BonusIcon> bonusIcons = new ArrayList<BonusIcon>();

    public GuiKnowledge(ClientPlayerEntity player, ITBCapability cap) {
        super((ITextComponent)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]));
        this.player = player;
        this.cap = cap;
        this.upgradableLevelMax = EntityHelper.getPerkLevelMaxForKnowledge(cap.getTotalPerkPoints());
        for (Perk perk : PerkRegistry.perkRegistry.getValues()) {
            if (Helper.isDisabledPerk(perk, (PlayerEntity)player)) continue;
            this.icons.add(new PerkIcon(perk));
        }
        this.alignmentPos = this.getBarRatio();
        this.initBonusIcons(this.cap);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int x = this.guiLeft + 15;
        int y = this.guiTop + 72;
        int i = 0;
        int spaceForIcon = this.icons.size() > 12 ? 22 : 31;
        int maxIconByLine = this.icons.size() > 12 ? 8 : 6;
        for (PerkIcon icon : this.icons) {
            int caseX = i % maxIconByLine;
            icon.setPosition(x + caseX * spaceForIcon, y);
            if (caseX == maxIconByLine - 1) {
                y += 30;
            }
            ++i;
        }
        int xIcon = this.guiLeft + 30;
        for (BonusIcon icon : this.bonusIcons) {
            icon.setPosition(xIcon, this.guiBottom - 45);
            xIcon += 18;
        }
        this.func_230480_a_((Widget)new CustomButton(this.guiLeft + 10, this.guiBottom - 25, 70, 15, (ITextComponent)new TranslationTextComponent("tombstone.compendium.main.title"), pressable -> this.getMinecraft().func_147108_a((Screen)new GuiInfo(null))));
        this.func_230480_a_((Widget)new CustomButton(this.guiRight - 10 - 70, this.guiBottom - 25, 70, 15, (ITextComponent)LangKey.BUTTON_CONFIG.getText(new Object[0]), pressable -> this.getMinecraft().func_147108_a((Screen)new GuiConfig())));
    }

    private void initBonusIcons(ITBCapability cap) {
        ArrayList tooltips;
        int alignmentLevel;
        boolean isBad;
        TimeHelper.SpecialEvent specialEvent = TimeHelper.getSpecialEvent();
        if (specialEvent != TimeHelper.SpecialEvent.NONE) {
            String eventString = specialEvent == TimeHelper.SpecialEvent.CHRISTMAS ? "tombstone.advancement.christmas.title" : (specialEvent == TimeHelper.SpecialEvent.HALLOWEEN ? "tombstone.compendium.halloween.title" : "tombstone.message.april_foolsday");
            ItemStack icon = specialEvent == TimeHelper.SpecialEvent.CHRISTMAS ? new ItemStack((IItemProvider)ModItems.christmas_gift) : ItemAdvancement.IconType.GHOST.getItemStack();
            this.bonusIcons.add(new BonusIcon(icon, Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent(eventString).func_240699_a_(TextFormatting.BOLD), new TranslationTextComponent("tombstone.message.holiday_event_bonus")})));
        }
        if ((isBad = (alignmentLevel = cap.getAlignmentLevel()) < 0) || alignmentLevel > 0) {
            tooltips = new ArrayList();
            tooltips.add(new TranslationTextComponent("tombstone.message." + (isBad ? "darkness" : "light")).func_240699_a_(TextFormatting.BOLD).func_240702_b_(" " + Math.abs(alignmentLevel)));
            tooltips.add(new TranslationTextComponent("tombstone.message.protect_against", new Object[]{new TranslationTextComponent("tombstone.message." + (isBad ? "living_damages" : "undead_damages")), Math.abs(alignmentLevel * 10)}));
            this.bonusIcons.add(new BonusIcon(isBad ? this.stackSkull : this.stackRevive, tooltips));
        }
        tooltips = isBad ? Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("tombstone.advancement.zombify.title").func_240699_a_(TextFormatting.BOLD), new TranslationTextComponent("bonus.tombstone.zombify")}) : Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("bonus.tombstone.exorcism.title").func_240699_a_(TextFormatting.BOLD), new TranslationTextComponent("bonus.tombstone.exorcism")});
        this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.EXORCISM.getItemStack(), tooltips));
        if (alignmentLevel > 0) {
            this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.PRAY_OF_PROTECTION.getItemStack(), Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("tombstone.advancement.pray_of_protection.title").func_240699_a_(TextFormatting.BOLD), new TranslationTextComponent("bonus.tombstone.pray_of_protection")})));
        }
        if (alignmentLevel > 1) {
            this.bonusIcons.add(new BonusIcon(new ItemStack((IItemProvider)Items.field_151058_ca), Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("bonus.tombstone.pray_of_empathy.title").func_240699_a_(TextFormatting.BOLD), new TranslationTextComponent("bonus.tombstone.pray_of_empathy")})));
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.hoveredIcon != null) {
            if (mouseButton == 0) {
                int perkLevel = this.cap.getPerkLevel((PlayerEntity)this.player, this.hoveredIcon.perk);
                if (perkLevel < Math.min(this.hoveredIcon.perk.getLevelMax(), this.upgradableLevelMax) && this.leftPerkPoints >= this.hoveredIcon.perk.getCost(perkLevel + 1)) {
                    PacketHandler.sendToServer(new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.UPGRADE_PERK, this.hoveredIcon.perk));
                    return true;
                }
            } else if (mouseButton == 1 && this.player.func_184812_l_() && this.cap.getPerkLevel((PlayerEntity)this.player, this.hoveredIcon.perk) > 0) {
                PacketHandler.sendToServer(new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.DOWNGRADE_PERK, this.hoveredIcon.perk));
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        this.func_230446_a_(matrixStack);
        this.hoveredIcon = this.icons.stream().filter(p -> p.contains(mouseX, mouseY)).findFirst().orElse(null);
        int totalPerkPoints = this.cap.getTotalPerkPoints();
        int usedPerkPoints = this.cap.getUsedPerkPoints((PlayerEntity)this.player);
        this.leftPerkPoints = totalPerkPoints - usedPerkPoints;
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        ((Object)((Object)this)).getClass();
        this.func_238465_a_(matrixStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 4, -1);
        ((Object)((Object)this)).getClass();
        this.func_238465_a_(matrixStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 6, -1);
        IFormattableTextComponent iFormattableTextComponent = LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]);
        ((Object)((Object)this)).getClass();
        GuiKnowledge.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)iFormattableTextComponent, (int)this.halfWidth, (int)(this.guiTop + 9), (int)-1);
        ((Object)((Object)this)).getClass();
        this.func_238465_a_(matrixStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 18, -1);
        ((Object)((Object)this)).getClass();
        this.func_238465_a_(matrixStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 20, -1);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().field_71446_o.func_110577_a(GUI_BAR);
        GuiKnowledge.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 52), (int)(this.guiTop + 30), (float)0.0f, (float)40.0f, (int)182, (int)5, (int)182, (int)256);
        GuiKnowledge.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 52), (int)(this.guiTop + 30), (float)0.0f, (float)45.0f, (int)((int)(129.22 * (double)(this.cap.getKnowledge() - this.cap.getKnowledgeForLevel(totalPerkPoints)) / (double)this.cap.getKnowledgeToReachNextLevel(totalPerkPoints))), (int)5, (int)182, (int)256);
        GuiKnowledge.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 52), (int)(this.guiTop + 31), (float)0.0f, (float)101.0f, (int)182, (int)3, (int)182, (int)256);
        int startAlignmentY = 44;
        GuiKnowledge.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"Alignment", (int)this.halfWidth, (int)(this.guiTop + startAlignmentY - 4), (int)-1);
        GuiKnowledge.func_238467_a_((MatrixStack)matrixStack, (int)(this.guiLeft + 20), (int)(this.guiTop + startAlignmentY + 10), (int)(this.guiRight - 20), (int)(this.guiTop + startAlignmentY + 17), (int)-16777216);
        Helper.fillGradient(matrix, this.guiLeft + 21, this.guiTop + startAlignmentY + 11, this.halfWidth, this.guiTop + startAlignmentY + 16, -65536, -1, this.func_230927_p_(), true);
        Helper.fillGradient(matrix, this.halfWidth, this.guiTop + startAlignmentY + 11, this.guiRight - 21, this.guiTop + startAlignmentY + 16, -1, -16776961, this.func_230927_p_(), true);
        ((Object)((Object)this)).getClass();
        float step = (float)(200 - 42) / 8.0f;
        for (int i = 0; i < 8; ++i) {
            if (i == 4) continue;
            this.func_238473_b_(matrixStack, this.guiLeft + 21 + (int)((float)i * step), this.guiTop + startAlignmentY + 10, this.guiTop + startAlignmentY + 16, -16777216);
        }
        this.field_230707_j_.func_180450_b(this.stackSkull, this.guiLeft + 10, this.guiTop + startAlignmentY + 5);
        this.field_230707_j_.func_180450_b(this.stackRevive, this.guiRight - 10 - 16, this.guiTop + startAlignmentY + 5);
        ((Object)((Object)this)).getClass();
        int adjust = (int)Math.round((double)(200 - 42) / 2.0 * this.alignmentPos);
        this.field_230707_j_.func_180450_b(this.stackAnkh, this.halfWidth + adjust - 8, this.guiTop + startAlignmentY + 4);
        String levelString = this.leftPerkPoints + " / " + totalPerkPoints;
        float f = this.guiLeft + 48 - this.field_230712_o_.func_78256_a(levelString);
        float f2 = this.guiTop + 28;
        ((Object)((Object)this)).getClass();
        this.field_230712_o_.func_238421_b_(matrixStack, levelString, f, f2, -1);
        this.icons.forEach(icon -> this.drawPerk(matrixStack, (PerkIcon)icon));
        this.bonusIcons.forEach(icon -> ((BonusIcon)icon).render(matrixStack));
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
        if (this.hoveredIcon == null) {
            this.bonusIcons.stream().filter(icon -> icon.contains(mouseX, mouseY)).findFirst().ifPresent(icon -> GuiUtils.drawHoveringText((MatrixStack)matrixStack, (List)((BonusIcon)icon).tooltips, (int)(icon.minX + 10), (int)(icon.minY + 10), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)200, (FontRenderer)this.field_230712_o_));
        }
        this.drawPerkTooltip(matrixStack);
        RenderSystem.popMatrix();
    }

    private double getBarRatio() {
        boolean isPositive = this.cap.getAlignmentValue() >= 0;
        int alignement = Math.abs(MathHelper.func_76125_a((int)this.cap.getAlignmentValue(), (int)this.cap.getAlignmentMinValue(), (int)this.cap.getAlignmentMaxValue()));
        double ratio = alignement > 300 ? 0.75 + 0.25 * (double)(alignement - 300) * 0.005 : (alignement > 150 ? 0.5 + 0.25 * (double)(alignement - 150) / 150.0 : (alignement > 50 ? 0.25 + 0.25 * (double)(alignement - 50) * 0.01 : 0.25 * (double)alignement * 0.02));
        return isPositive ? ratio : -ratio;
    }

    private void drawPerk(MatrixStack matrixStack, PerkIcon icon) {
        int n;
        int levelWithBonus = this.cap.getPerkLevelWithBonus((PlayerEntity)this.player, icon.perk);
        boolean isHovered = icon.equals(this.hoveredIcon);
        boolean isMax = this.cap.getPerkLevel((PlayerEntity)this.player, icon.perk) == icon.perk.getLevelMax();
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiKnowledge.func_238467_a_((MatrixStack)matrixStack, (int)(icon.minX - 1), (int)(icon.minY - 1), (int)(icon.maxX + 1), (int)(icon.maxY + 1 + 10), (int)-15329733);
        if (isHovered) {
            int n2;
            if (isMax) {
                ((Object)((Object)this)).getClass();
                n2 = -1980292;
            } else {
                n2 = -7096363;
            }
            int color = n2;
            this.func_238465_a_(matrixStack, icon.minX - 2, icon.maxX + 1, icon.minY - 2, color);
            this.func_238465_a_(matrixStack, icon.minX - 2, icon.maxX + 1, icon.minY + 27, color);
            this.func_238473_b_(matrixStack, icon.minX - 2, icon.minY - 2, icon.minY + 27, color);
            this.func_238473_b_(matrixStack, icon.minX + 17, icon.minY - 2, icon.minY + 27, color);
        }
        if (levelWithBonus == 0 && !isHovered) {
            RenderSystem.color4f((float)0.13f, (float)0.13f, (float)0.13f, (float)0.5f);
            this.func_238468_a_(matrixStack, icon.minX, icon.minY, icon.maxX, icon.maxY, -13421773, -13421773);
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_238468_a_(matrixStack, icon.minX, icon.minY, icon.maxX, icon.maxY, -16703669, -7096363);
        }
        this.getMinecraft().func_110434_K().func_110577_a(icon.perk.getIcon());
        GuiKnowledge.func_238463_a_((MatrixStack)matrixStack, (int)icon.minX, (int)icon.minY, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        if (icon.perk.equals(ModPerks.disenchanter)) {
            if (levelWithBonus != 0 || isHovered) {
                RenderSystem.color4f((float)0.4117647f, (float)0.45882353f, (float)0.5176471f, (float)1.0f);
            }
            this.getMinecraft().func_110434_K().func_110577_a(new ResourceLocation("tombstone", "textures/item/book_part1.png"));
            GuiKnowledge.func_238463_a_((MatrixStack)matrixStack, (int)icon.minX, (int)icon.minY, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        boolean hasBonus = icon.perk.getLevelBonus((PlayerEntity)this.player) != 0;
        String string = "" + levelWithBonus;
        float f = (float)icon.minX + (levelWithBonus > 9 ? 2.5f : 5.5f);
        float f2 = icon.minY + 18;
        if (hasBonus) {
            ((Object)((Object)this)).getClass();
            n = 8858573;
        } else if (isMax) {
            ((Object)((Object)this)).getClass();
            n = -1980292;
        } else if (levelWithBonus > 0) {
            ((Object)((Object)this)).getClass();
            n = -12562177;
        } else {
            ((Object)((Object)this)).getClass();
            n = -8355712;
        }
        this.field_230712_o_.func_238421_b_(matrixStack, string, f, f2, n);
        RenderSystem.popMatrix();
    }

    private void drawPerkTooltip(MatrixStack matrixStack) {
        if (this.hoveredIcon != null) {
            this.hoveredPerkLevel = this.cap.getPerkLevel((PlayerEntity)this.player, this.hoveredIcon.perk);
            int levelWithBonus = this.cap.getPerkLevelWithBonus((PlayerEntity)this.player, this.hoveredIcon.perk);
            ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
            list.add(this.hoveredIcon.perk.getTranslation().func_230531_f_().func_240703_c_(StyleType.MESSAGE_SPECIAL));
            ITextComponent specialInfo = this.hoveredIcon.perk.getSpecialInfo(levelWithBonus);
            if (specialInfo != StringTextComponent.field_240750_d_) {
                list.add(specialInfo.func_230531_f_().func_240703_c_(StyleType.INFO));
            }
            IntStream.rangeClosed(1, this.hoveredIcon.perk.getLevelMax()).forEach(i -> {
                ITextComponent info = this.hoveredIcon.perk.getTooltip(i, this.hoveredPerkLevel, levelWithBonus);
                if (info != StringTextComponent.field_240750_d_) {
                    TextFormatting formatting = this.hoveredPerkLevel >= i ? TextFormatting.WHITE : ((this.hoveredIcon.perk.isEncrypted() ? levelWithBonus >= i : levelWithBonus == i) ? TextFormatting.DARK_PURPLE : TextFormatting.DARK_GRAY);
                    boolean isEncrypted = this.hoveredIcon.perk.isEncrypted() && levelWithBonus < i - 1;
                    list.add(new StringTextComponent(i + " -> ").func_230529_a_((ITextComponent)(isEncrypted ? info.func_230531_f_().func_230530_a_(SupportMods.RUNELIC.isLoaded() ? StyleType.RUNELIC : StyleType.STANDARD_GALACTIC) : info)).func_240699_a_(formatting));
                }
            });
            if (this.hoveredPerkLevel < this.hoveredIcon.perk.getLevelMax()) {
                boolean canUpgradeLevel;
                int cost = this.hoveredIcon.perk.getCost(this.hoveredPerkLevel + 1);
                boolean hasPerkPoints = this.leftPerkPoints >= cost;
                list.add(LangKey.MESSAGE_COST.getText(hasPerkPoints ? TextFormatting.AQUA : TextFormatting.RED, new Object[]{cost}));
                boolean bl = canUpgradeLevel = this.hoveredPerkLevel < this.upgradableLevelMax;
                if (!canUpgradeLevel) {
                    list.add(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(TextFormatting.RED, new Object[0]).func_240702_b_(" " + EntityHelper.getKnowledgeForPerkLevel(this.hoveredPerkLevel + 1)));
                }
                list.add(canUpgradeLevel && hasPerkPoints ? LangKey.MESSAGE_CLICK_TO_UPGRADE.getText(TextFormatting.BLUE, new Object[0]) : LangKey.MESSAGE_CANT_UPGRADE.getText(TextFormatting.RED, new Object[0]));
            } else {
                list.add(LangKey.MESSAGE_MAX.getText(TextFormatting.GOLD, new Object[0]));
            }
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, list, (int)(this.hoveredIcon.minX + 10), (int)(this.hoveredIcon.minY + 10), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)200, (FontRenderer)this.field_230712_o_);
        }
    }

    private boolean isHovered(TooltipIcon icon, double mouseX, double mouseY) {
        return mouseX >= (double)icon.minX && mouseY >= (double)icon.minY && mouseX <= (double)icon.maxX && mouseY <= (double)(icon.maxY + 10);
    }

    private class TooltipIcon {
        public static final int ICON_SIZE = 16;
        protected int minX;
        protected int minY;
        protected int maxX;
        protected int maxY;

        private TooltipIcon() {
        }

        void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 16;
            this.maxY = y + 16;
        }

        boolean contains(double mouseX, double mouseY) {
            return GuiKnowledge.this.isHovered(this, mouseX, mouseY);
        }
    }

    private class BonusIcon
    extends TooltipIcon {
        private final ItemStack stack;
        private final List<ITextComponent> tooltips;

        BonusIcon(ItemStack stack, List<ITextComponent> tooltips) {
            this.stack = stack;
            this.tooltips = tooltips;
        }

        private void render(MatrixStack poseStack) {
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)(this.minX - 1), (int)(this.minY - 1), (int)(this.maxX + 1), (int)(this.maxY + 1), (int)-15329733);
            GuiKnowledge.this.func_238468_a_(poseStack, this.minX, this.minY, this.maxX, this.maxY, -16703669, -7096363);
            GuiKnowledge.this.getMinecraft().func_175599_af().func_180450_b(this.stack, this.minX, this.minY);
        }
    }

    public class PerkIcon
    extends TooltipIcon {
        private final Perk perk;

        PerkIcon(Perk perk) {
            this.perk = perk;
        }
    }
}

