/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.event.PhantomSpawnerEvent;
import ovh.corail.tombstone.api.magic.IProtectedEntity;
import ovh.corail.tombstone.api.magic.ModDamages;
import ovh.corail.tombstone.api.magic.ProtectedEntityProvider;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.capability.ProtectedEntityImpl;
import ovh.corail.tombstone.capability.ProtectedGraveGuardianImpl;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.CompatibilityFirstAid;
import ovh.corail.tombstone.compatibility.CompatibilityMinecolonies;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.entity.Cloud;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.BackupService;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DamageType;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.DummyTargetEntity;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EnchantHelper;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.PlayerStatusHandler;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.network.EffectMessage;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.PrayerMessage;
import ovh.corail.tombstone.network.SyncProtectionMessage;
import ovh.corail.tombstone.network.TombstoneActivatedMessage;
import ovh.corail.tombstone.network.UpdateClientMessage;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.spawner.CustomPhantomSpawner;
import ovh.corail.tombstone.spawner.CustomVillageSiege;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class EventHandler {
    private static final String END_CONQUERED_EFFECTS_NBT_LIST = "tb_end_conquered_effects";
    private static long LAST_BACKUP = -1L;
    private static final String IS_DRINKING_POTION = "is_drinking_potion";

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStarting(FMLServerStartingEvent event) {
        TimeHelper.init();
        if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityCosmeticArmor.instance);
        }
        if (SupportMods.FIRST_AID.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityFirstAid.instance);
        }
        BackupService.get();
        TameableType.init(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStoppingEvent(FMLServerStoppingEvent event) {
        CallbackHandler.flushTasks();
        PlayerPreference.clear();
        CooldownHandler.INSTANCE.clear();
        BackupService.stop();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerLogued(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getPlayer())) {
            MinecraftServer server = Objects.requireNonNull(event.getPlayer().func_184102_h());
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            ModTriggers.PASS_APRIL_FOOL.trigger(player);
            ModTriggers.CHRISTMAS.trigger(player);
            if (TimeHelper.isDateAroundHalloween()) {
                ModTriggers.HALLOWEEN.trigger(player);
            }
            PacketHandler.sendToPlayer(new UpdateClientMessage(server.func_241755_D_().func_241135_u_(), server.func_71262_S() ? server.func_82357_ak() : 0, TimeHelper.getSpecialEvent()), player);
            PacketHandler.sendToPlayer(CooldownHandler.INSTANCE.getCooldownPacket(player), player);
            EntityHelper.syncTBCapability(player, true);
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        Helper.initCommands((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = Helper.getServer();
        if (server != null && event.phase == TickEvent.Phase.END) {
            long systemTime;
            if (LAST_BACKUP < TimeHelper.SERVER_START_TIME) {
                LAST_BACKUP = TimeHelper.SERVER_START_TIME;
            } else if (((Boolean)ConfigTombstone.recovery.recoveryPlayerEnable.get()).booleanValue() && TimeUnit.MILLISECONDS.toMinutes((systemTime = TimeHelper.systemTime()) - LAST_BACKUP) > (long)((Integer)ConfigTombstone.recovery.recoveryPlayerTimer.get()).intValue()) {
                LAST_BACKUP = systemTime;
                if (server.func_184103_al().func_181057_v().size() > 0) {
                    CommandTBRecovery.saveAllPlayers(server, success -> {
                        if (((Boolean)ConfigTombstone.recovery.logAutoBackup.get()).booleanValue()) {
                            ModTombstone.LOGGER.info((success ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).asLog());
                        }
                    });
                }
            }
            CommandTBAcceptTeleport.cleanTickets();
            CallbackHandler.tick();
            PlayerStatusHandler.clear();
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getPlayer().func_208600_a((ITag)FluidTags.field_206959_a) && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.aquatic_life)) {
            event.setNewSpeed(event.getNewSpeed() * (EnchantmentHelper.func_185287_i((LivingEntity)event.getPlayer()) ? 2.0f : 10.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> {
            Block block = event.getWorld().func_180495_p(blockPos).func_177230_c();
            return ModBlocks.isAnyGrave(block) || block.func_203417_a(ModTags.Blocks.grave_marbles);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBreak(BlockEvent.BreakEvent event) {
        if (((Boolean)ConfigTombstone.player_death.nerfGhostlyShapeBreakBlock.get()).booleanValue() && EntityHelper.isValidServerPlayer(event.getPlayer()) && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape)) {
            EffectHelper.clearEffect((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape);
            ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            ServerWorld world = (ServerWorld)event.getWorld();
            if (!world.func_230315_m_().func_242714_a(DimensionType.field_236004_h_)) {
                return;
            }
            ImmutableList.Builder builder = new ImmutableList.Builder();
            boolean valid = false;
            for (ISpecialSpawner spawner : world.field_241104_N_) {
                if (spawner instanceof PhantomSpawner && !(spawner instanceof CustomPhantomSpawner)) {
                    builder.add((Object)new CustomPhantomSpawner());
                    valid = true;
                    continue;
                }
                if (spawner instanceof VillageSiege && !(spawner instanceof CustomVillageSiege)) {
                    builder.add((Object)new CustomVillageSiege());
                    valid = true;
                    continue;
                }
                builder.add((Object)spawner);
            }
            if (valid) {
                world.field_241104_N_ = builder.build();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        boolean isPlayer;
        ServerPlayerEntity player;
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving()) && event.getEntityLiving().func_70089_S() && (player = (ServerPlayerEntity)event.getEntityLiving()).func_184587_cr() && player.func_184607_cu().func_77973_b() instanceof ItemGraveMagic && EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.concentration) == 0) {
            EntityHelper.setGlobalItemCooldown((PlayerEntity)player, player.func_184607_cu(), 40);
            player.func_184602_cy();
            LangKey.MESSAGE_SPELLCASTING_INTERRUPTED.sendMessage((PlayerEntity)player, new Object[0]);
        }
        if (event.getEntityLiving() == null || event.getEntityLiving().field_70170_p.func_201670_d()) {
            return;
        }
        EffectInstance boneShieldEffect = event.getEntityLiving().func_70660_b(ModEffects.bone_shield);
        if (boneShieldEffect != null && !event.getSource().func_76352_a() && !event.getSource().func_94541_c() && event.getSource() instanceof EntityDamageSource && !(event.getSource() instanceof IndirectEntityDamageSource)) {
            event.setCanceled(true);
            if (!((EntityDamageSource)event.getSource()).func_180139_w()) {
                Optional.ofNullable(event.getSource().func_76346_g()).filter(Entity::func_70089_S).ifPresent(s -> {
                    float reflectedDamages = event.getAmount() * ((float)MathHelper.func_76125_a((int)boneShieldEffect.field_76461_c, (int)1, (int)10) / 10.0f);
                    if (reflectedDamages >= 1.0f) {
                        ModSounds.playSoundAllAround(SoundEvents.field_187903_gc, SoundCategory.NEUTRAL, s.field_70170_p, s.func_233580_cy_(), 0.5f, (Helper.RANDOM.nextFloat() - Helper.RANDOM.nextFloat()) * 0.2f + 1.0f);
                        s.func_70097_a(DamageSource.func_92087_a((Entity)event.getEntityLiving()), reflectedDamages);
                    }
                });
            }
            return;
        }
        if (EffectHelper.isUnstableIntangiblenessActive(event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (DamageType.LIGHTNING.is(event.getSource()) && EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.lightning_resistance)) {
            event.setAmount(event.getAmount() / 4.0f);
        }
        if (DamageType.COLD.is(event.getSource()) && EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.frost_resistance)) {
            event.setAmount(event.getAmount() / 4.0f);
        }
        if (isPlayer = EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving())) {
            if (event.getSource() == ModDamages.BEYOND_THE_GRAVE) {
                if (((Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get()).booleanValue()) {
                    event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                        int knowledgeLevel = cap.getTotalPerkPoints();
                        if (knowledgeLevel > 0) {
                            event.setAmount(event.getAmount() * (1.0f - (float)Math.min(20, knowledgeLevel) * 0.05f));
                        }
                    });
                }
            } else {
                int alignmentLevel = event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
                if (alignmentLevel != 0 && event.getSource().func_76346_g() instanceof LivingEntity) {
                    boolean valid;
                    boolean bl = EntityHelper.isUndead((LivingEntity)event.getSource().func_76346_g()) ? alignmentLevel > 0 : (valid = alignmentLevel < 0);
                    if (valid) {
                        float amount = event.getAmount() * (1.0f - 0.1f * (float)Math.abs(alignmentLevel));
                        if (amount < 0.5f) {
                            event.setCanceled(true);
                        } else {
                            event.setAmount(amount);
                        }
                    }
                }
            }
            if (EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.ghostly_shape, 5) && Helper.isValidPos(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_233580_cy_())) {
                event.setCanceled(true);
                return;
            }
        }
        if (EntityHelper.isValidPlayer(event.getSource().func_76346_g())) {
            PlayerEntity player2 = (PlayerEntity)event.getSource().func_76346_g();
            if (!event.getEntityLiving().equals((Object)player2)) {
                if (EffectHelper.isPotionActive((LivingEntity)player2, ModEffects.ghostly_shape)) {
                    EffectHelper.clearEffect((LivingEntity)player2, ModEffects.ghostly_shape);
                    ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayerEntity)player2);
                }
                if (EffectHelper.isPotionActive((LivingEntity)player2, ModEffects.diversion)) {
                    EffectHelper.clearEffect((LivingEntity)player2, ModEffects.diversion);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreventDeath(LivingDamageEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().func_70089_S() && event.getEntityLiving().func_110143_aJ() <= event.getAmount() && !event.getEntityLiving().field_70170_p.func_201670_d()) {
            Location location = event.getEntityLiving().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(cap -> {
                if (cap.isActive()) {
                    cap.apply(event.getEntityLiving(), false);
                    return new Location(cap.getSafeLocation(event.getEntityLiving()));
                }
                return Location.ORIGIN;
            }).orElse(Location.ORIGIN);
            if (!location.isOrigin()) {
                Location spawn;
                ServerWorld world;
                event.getEntityLiving().func_70606_j(event.getEntityLiving().func_110138_aP());
                event.getEntityLiving().field_70143_R = 0.0f;
                EffectHelper.clearBadEffects(event.getEntityLiving());
                EffectHelper.addEffect(event.getEntityLiving(), Effects.field_76428_l, 600, 9, new boolean[0]);
                if (((Boolean)ConfigTombstone.village_siege.glowingCreatureTest.get()).booleanValue()) {
                    EffectHelper.addEffect(event.getEntityLiving(), Effects.field_188423_x, 600);
                }
                EffectHelper.addEffect(event.getEntityLiving(), ModEffects.diversion, 600);
                MinecraftServer server = event.getEntityLiving().func_184102_h();
                ServerWorld serverWorld = world = server != null ? server.func_71218_a(location.dim) : null;
                if (world != null && !(spawn = new SpawnHelper(world, location.getPos()).findSpawnPlace()).isOrigin()) {
                    Helper.teleportEntity(event.getEntityLiving(), spawn, world);
                }
                EntityHelper.applyKillResult(event.getSource(), event.getEntityLiving());
                event.setCanceled(true);
                return;
            }
            if (!EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving())) {
                if (ModItems.familiar_receptacle.captureSoul(event.getEntityLiving())) {
                    event.setCanceled(true);
                    event.getEntityLiving().remove(false);
                }
                return;
            }
            if (EventHandler.handlePlayerDamage((ServerPlayerEntity)event.getEntityLiving(), event.getSource())) {
                event.setCanceled(true);
            }
        }
    }

    public static boolean handlePlayerDamage(ServerPlayerEntity player, DamageSource source) {
        ItemStack soul;
        if (ModItems.voodoo_poppet.preventDeath(player, source)) {
            return true;
        }
        ServerWorld targetWorld = player.func_71121_q();
        BlockPos playerPos = player.func_233580_cy_();
        boolean requirePrevention = (Boolean)ConfigTombstone.player_death.preventDeathOutsideWorldBorder.get() != false && Helper.isOutsideWorldBorders((World)targetWorld, playerPos) || (Boolean)ConfigTombstone.player_death.preventDeathOutsideBuildHeight.get() != false && Helper.isOutsideBuildHeight(playerPos);
        ItemStack itemStack = soul = !requirePrevention ? InventoryHelper.findFirstInInventory((PlayerEntity)player, p -> p.func_77973_b() == ModItems.soul_receptacle) : ItemStack.field_190927_a;
        if (requirePrevention || !soul.func_190926_b()) {
            Location spawnPos = new SpawnHelper(targetWorld, Helper.getCloserValidPos((World)targetWorld, playerPos)).findSpawnPlace();
            if (spawnPos.isOrigin() && targetWorld.func_230315_m_().func_242714_a(DimensionType.field_236006_j_)) {
                spawnPos = new SpawnHelper(targetWorld, new BlockPos(0, 70, 0)).findSpawnPlace();
            }
            if (spawnPos.isOrigin()) {
                assert (player.func_184102_h() != null);
                Pair<ServerWorld, BlockPos> respawnPoint = CommandTBTeleport.getRespawnPoint(player.func_184102_h(), player);
                spawnPos = new SpawnHelper((ServerWorld)respawnPoint.getLeft(), (BlockPos)respawnPoint.getRight()).findSpawnPlace();
            }
            if (!spawnPos.isOrigin()) {
                if (!requirePrevention) {
                    soul.func_190918_g(1);
                }
                player.func_70606_j(player.func_110138_aP());
                EffectHelper.clearBadEffects((LivingEntity)player);
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76443_y, 1200, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, 1200, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.diversion, 1200);
                (requirePrevention ? LangKey.MESSAGE_CONFIG_PREVENT_DEATH : LangKey.MESSAGE_SOUL_PREVENT_DEATH).sendMessage((PlayerEntity)player, new Object[0]);
                Helper.teleportEntity(player, spawnPos, targetWorld);
                player.field_70143_R = 0.0f;
                return true;
            }
        }
        if (((Boolean)ConfigTombstone.recovery.backupOnDeath.get()).booleanValue() && !player.func_175149_v()) {
            CommandTBRecovery.savePlayer(player, success -> ModTombstone.LOGGER.info((success ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getText(player.func_200200_C_()).getString()));
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onCheckAttack(LivingAttackEvent event) {
        if (Helper.isAprilFoolsDaySnowball(event.getEntityLiving(), event.getSource())) {
            EffectHelper.addEffect(event.getEntityLiving(), Effects.field_76421_d, 200);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckHidden(LivingEvent.LivingVisibilityEvent event) {
        PlayerStatusHandler.getPlayerStatus((Entity)event.getEntityLiving()).ifPresent(playerStatus -> event.modifyVisibility(playerStatus.visibleFactorLowPriority));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCheckDiscretion(LivingEvent.LivingVisibilityEvent event) {
        PlayerStatusHandler.getPlayerStatus((Entity)event.getEntityLiving()).ifPresent(playerStatus -> event.modifyVisibility(playerStatus.visibleFactorHighPriority));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckAttack(LivingSetAttackTargetEvent event) {
        if (!EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && event.getTarget() != null) {
            LivingEntity attacker = event.getEntityLiving();
            if (EffectHelper.isPotionActive(event.getTarget(), ModEffects.ghostly_shape) || EffectHelper.isPotionActive(event.getTarget(), ModEffects.diversion)) {
                IAngerable angerable;
                UUID angerAt;
                ((MobEntity)attacker).field_70696_bz = null;
                if (event.getTarget().equals((Object)attacker.field_70755_b)) {
                    attacker.field_70755_b = new DummyTargetEntity(attacker.field_70170_p);
                }
                if (attacker instanceof IAngerable && (angerAt = (angerable = (IAngerable)attacker).func_230257_G__()) != null && angerAt.equals(event.getTarget().func_110124_au())) {
                    angerable.func_230259_a_(null);
                    angerable.func_230260_a__(0);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!EntityHelper.isValidServerPlayer(event.getPlayer()) || event.getPlayer().func_175149_v()) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        EntityHelper.syncTBCapability(player, false);
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        deathHandler.restoreSoulbounds(player);
        if (deathHandler.isPlayerDead((PlayerEntity)player)) {
            if (PlayerPreference.get((PlayerEntity)player).getAutoEquipRule().equiOnRespawn()) {
                InventoryHelper.autoequip((PlayerEntity)player, new ItemStackHandler(player.field_71071_by.field_70462_a));
            }
            deathHandler.restorePlayerDead(player);
        }
        player.field_71069_bz.func_75142_b();
        List<EffectInstance> list = NBTStackHelper.getEffectList(EntityHelper.getPersistentTag((PlayerEntity)player), END_CONQUERED_EFFECTS_NBT_LIST, e -> true);
        if (!list.isEmpty()) {
            list.forEach(arg_0 -> ((ServerPlayerEntity)player).func_195064_c(arg_0));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClone(PlayerEvent.Clone event) {
        Map originalEffects;
        if (!EntityHelper.isValidPlayer(event.getOriginal()) || !EntityHelper.isValidPlayer(event.getPlayer())) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        PlayerEntity original = event.getOriginal();
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(capPlayer -> {
            LazyOptional capHolder = original.getCapability(TBCapabilityProvider.TB_CAPABILITY);
            if (!capHolder.isPresent()) {
                original.revive();
            }
            capHolder.ifPresent(capPlayer::copyCapability);
        });
        if (((Boolean)ConfigTombstone.compatibility.preserveEffectsOnReturnEndConquered.get()).booleanValue() && !event.isWasDeath() && original.field_70170_p.func_234923_W_() == World.field_234920_i_ && player.func_193076_bZ().isEmpty() && !(originalEffects = original.func_193076_bZ()).isEmpty()) {
            NBTStackHelper.setEffectlist(EntityHelper.getPersistentTag(event.getPlayer()), END_CONQUERED_EFFECTS_NBT_LIST, originalEffects.values().stream());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving())) {
            if (!event.isCanceled() && event.getEntityLiving() != null) {
                EntityHelper.applyKillResult(event.getSource(), event.getEntityLiving());
            }
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
        if (event.isCanceled()) {
            if (((Boolean)ConfigTombstone.player_death.handlePlayerDeath.get()).booleanValue()) {
                ModTombstone.LOGGER.warn("The death event of the player " + player.func_200200_C_().getString() + " was canceled by another mod");
            }
        } else {
            boolean isBeyondTheGraveDamage = (Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get() != false && event.getSource() == ModDamages.BEYOND_THE_GRAVE;
            int knowledgeLoss = (Integer)ConfigTombstone.player_death.knowledgeLoss.get() + (isBeyondTheGraveDamage ? 10 : 0);
            if (knowledgeLoss > 0) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.removeKnowledgeAndSync(player, knowledgeLoss));
                if (isBeyondTheGraveDamage) {
                    ModTriggers.LOST_KNOWLEDGE.trigger(player);
                }
            }
            DeathHandler.INSTANCE.addPlayerDead(player, event.getSource());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if ((Integer)SharedConfigTombstone.player_death.xpLoss.get() > -1 && EntityHelper.isValidPlayer((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    private static void collectKeyAndSoulbound(Iterator<ItemEntity> it, List<ItemStack> keys, List<ItemStack> soulbounds) {
        while (it.hasNext()) {
            ItemEntity entityItem = it.next();
            if (entityItem == null) {
                it.remove();
                continue;
            }
            ItemStack stack = entityItem.func_92059_d();
            if (stack.func_190926_b()) {
                it.remove();
                continue;
            }
            if (stack.func_77973_b() == ModItems.grave_key) {
                keys.add(stack.func_77946_l());
                entityItem.func_92058_a(ItemStack.field_190927_a);
                it.remove();
                continue;
            }
            if (EnchantHelper.getEnchantmentLevel(ModEnchantments.soulbound, stack) <= 0) continue;
            soulbounds.add(stack.func_77946_l());
            entityItem.func_92058_a(ItemStack.field_190927_a);
            it.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public static void onDrops(LivingDropsEvent event) {
        ItemStack key;
        BlockState state;
        boolean hasGrave;
        TileEntityPlayerGrave grave;
        TileEntity tile2;
        boolean hasDrop;
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving())) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
        if (Helper.isRuleKeepInventory((PlayerEntity)player)) {
            return;
        }
        if (event.isCanceled()) {
            ModTombstone.LOGGER.warn("The drop event of the player " + player.func_146103_bH().getName() + " was canceled by another mod");
            return;
        }
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        ArrayList<ItemStack> soulbounds = new ArrayList<ItemStack>();
        EventHandler.collectKeyAndSoulbound(event.getDrops().iterator(), keys, soulbounds);
        double range = ((Integer)ConfigTombstone.player_death.snifferRange.get()).intValue();
        List itemList = player.field_70170_p.func_175647_a(ItemEntity.class, Helper.createBounds(player.func_233580_cy_(), range), e -> e != null && (e.func_200215_l() == null || player.func_110124_au().equals(e.func_200215_l())));
        EventHandler.collectKeyAndSoulbound(itemList.iterator(), keys, soulbounds);
        PlayerPreference playerPreference = PlayerPreference.get(player.func_110124_au());
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        if (playerPreference.denyGraveOnDeath()) {
            LangKey.MESSAGE_CHOOSE_NO_GRAVE.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            return;
        }
        int countDrop = event.getDrops().size() + itemList.size();
        boolean bl = hasDrop = countDrop > 0;
        if (!((Boolean)ConfigTombstone.player_death.handlePlayerDeath.get()).booleanValue() || !hasDrop) {
            if (!hasDrop) {
                keys.stream().filter(p -> !ModItems.grave_key.isEnchanted((ItemStack)p)).findFirst().ifPresent(k -> ModItems.grave_key.reenchantOnDeath((PlayerEntity)player, (ItemStack)k));
                LangKey.MESSAGE_NO_LOOT_FOR_GRAVE.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            }
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            return;
        }
        if (deathHandler.isNoGraveLocation(new Location((Entity)player))) {
            LangKey.MESSAGE_NO_GRAVE_LOCATION.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            return;
        }
        MinecraftServer server = player.func_184102_h();
        assert (server != null);
        ServerWorld world = player.func_71121_q();
        BlockPos initPos = Helper.getCloserValidPos((World)world, player.func_233580_cy_());
        Location spawnPos = Location.ORIGIN;
        if (((Boolean)ConfigTombstone.player_death.allowToFillExistingGrave.get()).booleanValue()) {
            Location lastGrave;
            TileEntityPlayerGrave tileGrave = world.func_175726_f(initPos).func_177434_r().values().stream().filter(TileEntityPlayerGrave.class::isInstance).map(TileEntityPlayerGrave.class::cast).filter(tile -> tile.getOwnerName().equals(player.func_146103_bH().getName()) && InventoryHelper.hasEnoughSlots(tile.getInventory(), countDrop)).findFirst().orElse(null);
            if (tileGrave != null) {
                spawnPos = new Location(tileGrave.func_174877_v(), (World)world);
            }
            if (spawnPos.isOrigin() && !(lastGrave = deathHandler.getLastGrave(server, player)).isOrigin() && lastGrave.isSameDimension((World)world) && Helper.getDistanceSq((Vector3i)lastGrave.getPos(), (Vector3i)initPos) <= 400.0 && (tile2 = world.func_175625_s(lastGrave.getPos())) instanceof TileEntityPlayerGrave && InventoryHelper.hasEnoughSlots((grave = (TileEntityPlayerGrave)tile2).getInventory(), countDrop)) {
                spawnPos = lastGrave;
            }
        }
        boolean bl2 = hasGrave = !spawnPos.isOrigin();
        if (!hasGrave) {
            Pair<ServerWorld, BlockPos> respawnPoint;
            Pair<Location, SpawnHelper.SpawnResult> res = new SpawnHelper(world, initPos).withPlayerPreference(playerPreference).findGravePlaceWithResult();
            spawnPos = (Location)res.getLeft();
            if (world.func_230315_m_().func_242714_a(DimensionType.field_236006_j_) && (spawnPos.isOrigin() || !SpawnHelper.SpawnResult.NORMAL.hasPattern((SpawnHelper.SpawnResult)((Object)res.getRight()))) && !((Location)(res = new SpawnHelper(world, new BlockPos(0, 70, 0)).withPlayerPreference(playerPreference).findGravePlaceWithResult()).getLeft()).isOrigin() && SpawnHelper.SpawnResult.NORMAL.hasPattern((SpawnHelper.SpawnResult)((Object)res.getRight()))) {
                spawnPos = (Location)res.getLeft();
            }
            if (spawnPos.isOrigin() && (spawnPos = new SpawnHelper((ServerWorld)(respawnPoint = CommandTBTeleport.getRespawnPoint(server, player)).getLeft(), (BlockPos)respawnPoint.getRight()).withPlayerPreference(playerPreference).findGravePlace()).isOrigin()) {
                deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
                LangKey.MESSAGE_NO_PLACE_FOR_GRAVE.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                ModTombstone.LOGGER.info("There was nowhere to place the grave!");
                return;
            }
        }
        if (!hasGrave) {
            deathHandler.logLastGrave((PlayerEntity)player, spawnPos);
            Direction facing = player.func_174811_aO().func_176734_d();
            Block graveBlock = ModBlocks.PLAYER_GRAVES.get((Object)playerPreference.getFavoriteGrave());
            state = (BlockState)((BlockState)((BlockState)graveBlock.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)facing)).func_206870_a((Property)BlockGraveBase.IS_ENGRAVED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)BlockGraveBase.MODEL_TEXTURE, (Comparable)Integer.valueOf(playerPreference.getMarbleType().ordinal()));
            world.func_175656_a(spawnPos.getPos(), state);
        } else {
            state = world.func_180495_p(spawnPos.getPos());
        }
        tile2 = world.func_175625_s(spawnPos.getPos());
        if (!(tile2 instanceof TileEntityPlayerGrave)) {
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            ModTombstone.LOGGER.info((Object)LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.getText(new Object[0]));
            return;
        }
        deathHandler.setLastDeathLocation((PlayerEntity)player, new Location(spawnPos.x, spawnPos.y + 1, spawnPos.z, spawnPos.dim));
        grave = (TileEntityPlayerGrave)tile2;
        if (hasGrave) {
            grave.resetDeathTime();
        }
        boolean needAccess = (Integer)SharedConfigTombstone.player_death.decayTime.get() != 0 && (!server.func_71219_W() || (Boolean)ConfigTombstone.player_death.pvpUnlockGrave.get() == false || !EntityHelper.isKilledByOtherPlayer((PlayerEntity)player, event.getSource()));
        IFormattableTextComponent locked = new StringTextComponent("[").func_230529_a_((ITextComponent)(needAccess ? LangKey.MESSAGE_LOCKED.getText(new Object[0]).func_240702_b_((Integer)SharedConfigTombstone.player_death.decayTime.get() > 0 ? " " + SharedConfigTombstone.player_death.decayTime.get() + " min" : "") : LangKey.MESSAGE_UNLOCKED.getText(new Object[0]))).func_240702_b_("]").func_230530_a_(needAccess ? StyleType.COLOR_OFF : StyleType.COLOR_ON);
        player.func_145747_a((ITextComponent)(hasGrave ? LangKey.MESSAGE_EXISTING_GRAVE : LangKey.MESSAGE_NEW_GRAVE).getText(StyleType.MESSAGE_SPECIAL, new Object[0]).func_240702_b_(" ").func_230529_a_((ITextComponent)locked), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent("[x: ").func_240702_b_(String.valueOf(spawnPos.x)).func_240702_b_(", y: ").func_240702_b_(String.valueOf(spawnPos.y)).func_240702_b_(", z: ").func_240702_b_(String.valueOf(spawnPos.z)).func_240702_b_("]").func_230529_a_((ITextComponent)new StringTextComponent(" in ").func_240702_b_(spawnPos.getDimString())), Util.field_240973_b_);
        Location finalSpawnPos = spawnPos;
        ItemStack itemStack = key = hasGrave ? keys.stream().filter(k -> ModItems.grave_key.getTombPos((ItemStack)k).equals(finalSpawnPos)).findFirst().orElse(ItemStack.field_190927_a) : ItemStack.field_190927_a;
        if (key.func_190926_b() && ModItems.grave_key.isEnabled()) {
            key = new ItemStack((IItemProvider)ModItems.grave_key);
            ModItems.grave_key.setTombPos(key, spawnPos);
            keys.add(0, key);
        }
        ModItems.grave_key.reenchantOnDeath((PlayerEntity)player, key);
        deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
        grave.setOwner((PlayerEntity)player, TimeHelper.systemTime(), needAccess);
        IItemHandler itemHandler = grave.getInventory();
        event.getDrops().forEach(e -> e.func_92058_a(ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)e.func_92059_d().func_77946_l(), (boolean)false)));
        itemList.forEach(e -> e.func_92058_a(ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)e.func_92059_d().func_77946_l(), (boolean)false)));
        if (SupportMods.ENIGMATIC_LEGACY.isLoaded()) {
            CompoundNBT persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player);
            NBTStackHelper.getListOrEmpty(persistentTag, "enigmatic_stuff").ifPresent(list -> list.forEach(nbt -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt)), (boolean)false)));
            persistentTag.func_82580_o("enigmatic_stuff");
        }
        grave.func_70296_d();
        world.func_184138_a(spawnPos.getPos(), Blocks.field_150350_a.func_176223_P(), state, 2);
        ModTriggers.FIRST_GRAVE.trigger(player);
        if (event.getDrops().size() <= 120) {
            event.getDrops().clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean valid;
        if (event.getLeft().func_190926_b() || event.getRight().func_190926_b()) {
            return;
        }
        String newName = Optional.ofNullable(event.getName()).orElse("").trim();
        boolean bl = valid = event.getLeft().func_77973_b() == ModItems.grave_plate && event.getRight().func_77973_b().func_206844_a((ITag)Tags.Items.INGOTS_IRON) || ModItems.tablet_of_assistance.isEnchanted(event.getLeft()) && !ModItems.tablet_of_assistance.isAncient(event.getLeft()) && event.getRight().func_77973_b() == ModItems.grave_dust;
        if (valid) {
            event.setOutput(EngravableHelper.setEngravedName(event.getLeft().func_77946_l(), newName));
            event.setCost(1);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilRepair(AnvilRepairEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getPlayer()) && event.getItemInput().func_77973_b() == ModItems.grave_plate && event.getIngredientInput().func_77973_b().func_206844_a((ITag)Tags.Items.INGOTS_IRON) && EngravableHelper.isEngraved(event.getItemResult())) {
            ModTriggers.ENGRAVE_GRAVE_PLATE.trigger((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.isCanceled() && EntityHelper.isValidServerPlayer(event.getPlayer()) && event.getHand() == Hand.MAIN_HAND) {
            TileEntity tile;
            boolean hasShadowStep;
            boolean requireNerfGhostlyShape = (Boolean)ConfigTombstone.player_death.nerfGhostlyShapeOpenChest.get() != false && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape);
            boolean bl = hasShadowStep = (Boolean)ConfigTombstone.enchantments.nerfShadowStepOpenChest.get() != false && EntityHelper.getShadowStepLevel(event.getPlayer()) > 0;
            if ((requireNerfGhostlyShape || hasShadowStep) && (tile = event.getWorld().func_175625_s(event.getPos())) != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).isPresent()) {
                if (requireNerfGhostlyShape) {
                    EffectHelper.clearEffect((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape);
                    ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayerEntity)event.getPlayer());
                }
                if (hasShadowStep) {
                    EntityHelper.setShadowStepCooldown(event.getPlayer());
                }
            }
        }
        if (ModBlocks.isPlayerGrave(event.getWorld().func_180495_p(event.getPos()).func_177230_c())) {
            if (event.isCanceled()) {
                event.setCanceled(false);
                event.setUseBlock(Event.Result.DEFAULT);
                event.setUseItem(Event.Result.DEFAULT);
            }
            if (event.getWorld().func_201670_d() && SpawnProtectionHandler.getInstance().isBlockProtected((RegistryKey<World>)event.getWorld().func_234923_W_(), event.getPos())) {
                PacketHandler.sendToServer(new TombstoneActivatedMessage(event.getPos()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().field_70170_p.func_201670_d() && TimeHelper.atInterval(event.getEntityLiving().field_70170_p, 20)) {
            if (((Boolean)ConfigTombstone.client.showShadowStep.get()).booleanValue() && EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && EntityHelper.getShadowStepLevel((PlayerEntity)event.getEntityLiving()) > 0) {
                ModTombstone.PROXY.produceShadowStep(event.getEntityLiving());
            }
            if (((Boolean)ConfigTombstone.client.showShieldParticle.get()).booleanValue() && event.getEntityLiving().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(IProtectedEntity::isActive).orElse(false).booleanValue()) {
                ModTombstone.PROXY.produceShield(event.getEntityLiving());
            }
        }
    }

    @SubscribeEvent
    public static void onTrackingStart(PlayerEvent.StartTracking event) {
        if (EntityHelper.isValidServerPlayer(event.getPlayer()) && event.getTarget() != null) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            if (event.getTarget().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(IProtectedEntity::isActive).orElse(false).booleanValue()) {
                PacketHandler.sendToPlayer(new SyncProtectionMessage(event.getTarget().func_145782_y(), true), player);
            }
            if (event.getTarget() instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)event.getTarget();
                EffectInstance effect = living.func_70660_b(ModEffects.bone_shield);
                if (effect != null) {
                    PacketHandler.sendToPlayer(new EffectMessage(living.func_145782_y(), effect), player);
                }
                CompoundNBT tag = living.getPersistentData();
                EffectInstance effectPrayer = living.func_70660_b(ModEffects.prayer);
                if (effectPrayer != null && tag.func_150297_b("prayer", 11) && tag.func_150297_b("pray_type", 2)) {
                    PacketHandler.sendToPlayer(new PrayerMessage(living.func_145782_y(), tag.func_186857_a("prayer"), tag.func_74765_d("pray_type"), effectPrayer.field_76460_b), player);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        if (event.getItem().func_77973_b() == Items.field_151068_bn && EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving()) && PotionUtils.func_185189_a((ItemStack)event.getItem()).size() > 0) {
            event.getEntityLiving().getPersistentData().func_74757_a(IS_DRINKING_POTION, true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseStop(LivingEntityUseItemEvent.Stop event) {
        if (EventHandler.isDrinking(event.getEntityLiving())) {
            EventHandler.resetDrinking(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (EventHandler.isDrinking(event.getEntityLiving())) {
            EventHandler.resetDrinking(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        if (EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && EventHandler.isDrinking(event.getEntityLiving()) && event.getPotionEffect().field_76460_b >= 1200 && EffectHelper.isAllowedEffect(event.getPotionEffect().func_188419_a())) {
            float bonus = 1.0f + (float)EntityHelper.getPerkLevelWithBonus((PlayerEntity)event.getEntityLiving(), ModPerks.alchemist) * 0.1f;
            EffectHelper.modifyEffectDuration(event.getPotionEffect(), e -> MathHelper.func_76141_d((float)((float)e.field_76460_b * bonus)));
        }
    }

    private static boolean isDrinking(LivingEntity entityLiving) {
        return entityLiving.getPersistentData().func_150297_b(IS_DRINKING_POTION, 1);
    }

    private static void resetDrinking(LivingEntity entityLiving) {
        entityLiving.getPersistentData().func_82580_o(IS_DRINKING_POTION);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionAdded(PotionEvent.PotionApplicableEvent event) {
        Optional.ofNullable(event.getEntityLiving()).map(Entity::func_200600_R).ifPresent(type -> {
            Effect effect = event.getPotionEffect().func_188419_a();
            if (effect == ModEffects.ghostly_shape || effect == ModEffects.preservation || effect == ModEffects.true_sight || effect == ModEffects.bait) {
                event.setResult(EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) ? Event.Result.ALLOW : Event.Result.DENY);
            } else if (EffectHelper.isBadEffect(effect) && EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.purification)) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(TBCapabilityProvider.RL, (ICapabilityProvider)new TBCapabilityProvider((NonNullSupplier<ITBCapability>)((NonNullSupplier)TBCapabilityDefault::new)));
        } else if (event.getObject() instanceof AbstractVillagerEntity || event.getObject() instanceof GolemEntity) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)() -> new ProtectedEntityImpl(EntityHelper::getHomeLocation))));
        } else if (CompatibilityMinecolonies.instance.isCitizen((Entity)event.getObject())) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)() -> new ProtectedEntityImpl(CompatibilityMinecolonies.instance::getHomePos))));
        } else if (event.getObject() instanceof GraveGuardian) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)ProtectedGraveGuardianImpl::new)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSyncOnChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (EntityHelper.isValidPlayer(event.getPlayer()) && !event.getPlayer().field_70170_p.func_201670_d()) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            EntityHelper.syncTBCapability(player, false);
            MinecraftServer server = event.getPlayer().func_184102_h();
            if (server == null) {
                return;
            }
            Optional.ofNullable(server.func_71218_a(event.getFrom())).ifPresent(fromDim -> Optional.ofNullable(server.func_71218_a(event.getTo())).ifPresent(toDim -> {
                long dif = TimeHelper.worldTicks((World)toDim) - TimeHelper.worldTicks((World)fromDim);
                if (dif != 0L) {
                    CooldownHandler.INSTANCE.updateWorldTime(player, dif);
                    IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
                    IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(stack -> stack.func_77973_b() == ModItems.lost_tablet).forEach(stack -> ModItems.lost_tablet.setCooldown((World)toDim, (ItemStack)stack, Math.min(ModItems.lost_tablet.getCooldown((World)fromDim, (ItemStack)stack), TimeHelper.tickFromMinute(10))));
                }
            }));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldStack;
        ItemStack itemStack = heldStack = event.getPlayer() != null ? event.getPlayer().func_184586_b(event.getHand()) : ItemStack.field_190927_a;
        if (event.getHand() == Hand.MAIN_HAND && heldStack.func_77973_b() == ModItems.bone_needle && event.getTarget() instanceof LivingEntity && heldStack.func_111282_a_(event.getPlayer(), (LivingEntity)event.getTarget(), event.getHand()).func_226247_b_()) {
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (!EntityHelper.isValidPlayer(event.getPlayer())) {
            return;
        }
        if (heldStack.func_77973_b() == ModItems.dust_of_vanishing || heldStack.func_77973_b() instanceof ItemGraveMagic) {
            event.setCancellationResult(ActionResultType.PASS);
            event.setCanceled(true);
            return;
        }
        if (event.getHand() == Hand.MAIN_HAND && heldStack.func_77973_b() == ModItems.ankh_of_pray && event.getTarget() instanceof LivingEntity && heldStack.func_111282_a_(event.getPlayer(), (LivingEntity)event.getTarget(), event.getHand()).func_226247_b_()) {
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack heldStack = event.getPlayer().func_184614_ca();
        if (heldStack.func_77973_b() == ModItems.ankh_of_pray) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPhantomTime(PhantomSpawnerEvent.TimeForCheck event) {
        if (((Boolean)ConfigTombstone.general.knowledgeReducePhantomSpawn.get()).booleanValue()) {
            event.getPlayer().getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> event.modifyTimeForCheck((int)((float)event.getTimeForCheck() * (1.0f + (float)cap.getTotalPerkPoints() * 0.1f))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent.Throwable event) {
        Cloud cloud;
        ItemStack stack;
        if (event.getThrowable() != null && EntityType.field_200746_al == event.getThrowable().func_200600_R() && event.getThrowable() instanceof SnowballEntity && (stack = ((SnowballEntity)event.getThrowable()).func_184543_l()).func_77973_b() == ModItems.smoke_ball && (cloud = (Cloud)ModEntities.cloud.func_200721_a(event.getThrowable().field_70170_p)) != null) {
            event.getThrowable().func_70106_y();
            event.setCanceled(true);
            cloud.setColor(ModItems.smoke_ball.getColor(stack, 0));
            cloud.func_70107_b(event.getThrowable().func_226277_ct_(), event.getThrowable().func_226278_cu_(), event.getThrowable().func_226281_cx_());
            event.getThrowable().field_70170_p.func_217376_c((Entity)cloud);
            stack.func_190918_g(1);
        }
    }
}

