/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import ovh.corail.tombstone.api.event.CaptureSoulEvent;
import ovh.corail.tombstone.api.event.PhantomSpawnerEvent;
import ovh.corail.tombstone.api.event.RestoreInventoryEvent;
import ovh.corail.tombstone.api.event.VillageSiegeEvent;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class EventFactory {
    public static boolean onVillageSiegeStart(ServerWorld world, BlockPos spawnPos) {
        return MinecraftForge.EVENT_BUS.post((Event)new VillageSiegeEvent.Start(world, spawnPos));
    }

    public static boolean onVillageSiegeZombieSpawn(ServerWorld world, ZombieEntity entity) {
        return MinecraftForge.EVENT_BUS.post((Event)new VillageSiegeEvent.SpawnZombie(world, entity));
    }

    public static void onRestoreInventory(PlayerEntity player, TileEntityPlayerGrave tileGrave) {
        MinecraftForge.EVENT_BUS.post((Event)new RestoreInventoryEvent(player, tileGrave.func_174877_v(), tileGrave.getInventory(), tileGrave.getOwnerName(), tileGrave.getOwnerDeathTime()));
    }

    public static boolean onCaptureSoul(PlayerEntity player, LivingEntity capturedEntity) {
        return MinecraftForge.EVENT_BUS.post((Event)new CaptureSoulEvent(player, capturedEntity));
    }

    public static int onPhantomTime(PlayerEntity player, int timeForCheck) {
        PhantomSpawnerEvent.TimeForCheck event = new PhantomSpawnerEvent.TimeForCheck(player, timeForCheck);
        return event.getTimeForCheck();
    }

    public static boolean onCheckPhantomSpawn(PlayerEntity player, int timeForCheck, int timeSinceRest, boolean result) {
        PhantomSpawnerEvent.CheckPhantomSpawn event = new PhantomSpawnerEvent.CheckPhantomSpawn(player, timeForCheck, timeSinceRest);
        event.setResult(result ? Event.Result.ALLOW : Event.Result.DENY);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult() != Event.Result.DENY;
    }
}

