/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.gui.GuiKnowledge;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.MarkerHandler;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.ResetPerkMessage;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModParticleTypes;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ClientEventHandler {
    public static final KeyBinding KEYBIND_KNOWLEDGE = new KeyBinding(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.field_197958_a, "Corail Tombstone");
    private static boolean isFirstGuiGameOver = false;
    private static boolean requireRemovalVisibility = false;
    private static boolean requireRemovalNightVision = false;
    private static boolean hasWaterVision = false;
    private static boolean delayedGui = false;
    public static boolean hasTrueSight = false;
    private static long nextGhostTime = -1L;
    public static String toDisplay;
    private static boolean SKIP_RENDER_EVENT;
    private static long LAST_PACKET;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147113_T()) {
            return;
        }
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            requireRemovalNightVision = false;
            hasWaterVision = false;
            hasTrueSight = false;
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            MarkerHandler.instance.update(mc);
            toDisplay = null;
            hasTrueSight = EffectHelper.isPotionActive((LivingEntity)mc.field_71439_g, ModEffects.ghostly_shape, 4) || EffectHelper.isPotionActive((LivingEntity)mc.field_71439_g, ModEffects.true_sight);
            hasWaterVision = hasTrueSight || EffectHelper.isPotionActive((LivingEntity)mc.field_71439_g, ModEffects.aquatic_life) && Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216771_k().func_206884_a((ITag)FluidTags.field_206959_a);
            boolean bl = requireRemovalNightVision = hasTrueSight && !EffectHelper.isPotionActive((LivingEntity)mc.field_71439_g, Effects.field_76439_r);
            if (requireRemovalNightVision) {
                mc.field_71439_g.func_195064_c(new EffectInstance(Effects.field_76439_r, 1200, 0, true, false));
            }
        } else {
            if (requireRemovalNightVision) {
                requireRemovalNightVision = false;
                mc.field_71439_g.func_184596_c(Effects.field_76439_r);
            }
            if ((KEYBIND_KNOWLEDGE.func_151468_f() || delayedGui) && (mc.field_71462_r == null || mc.field_71462_r instanceof ChatScreen)) {
                mc.field_71439_g.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                    delayedGui = false;
                    mc.func_147108_a((Screen)new GuiKnowledge(mc.field_71439_g, (ITBCapability)cap));
                });
            }
            if (((Boolean)ConfigTombstone.client.allowHalloweenGhost.get()).booleanValue() && TimeHelper.isDateAroundHalloween()) {
                if (Helper.isNight((World)mc.field_71441_e)) {
                    long time = TimeHelper.worldTicks((World)mc.field_71441_e);
                    if (nextGhostTime == -1L || time > nextGhostTime) {
                        if (nextGhostTime > -1L && CooldownHandler.INSTANCE.noCooldown((PlayerEntity)mc.field_71439_g, CooldownType.NEXT_PRAY)) {
                            Vector3d ghostVec = mc.field_71439_g.func_213303_ch().func_72441_c((Helper.RANDOM.nextDouble() - 0.5) * 18.0, 0.0, (Helper.RANDOM.nextDouble() - 0.5) * 18.0);
                            mc.field_71452_i.func_199280_a((IParticleData)ModParticleTypes.GHOST, ghostVec.field_72450_a, ghostVec.field_72448_b, ghostVec.field_72449_c, 0.0, 0.0, 0.0);
                        }
                        nextGhostTime = time + (long)Helper.getRandom(60, 6000);
                    }
                } else {
                    nextGhostTime = -1L;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiRender(GuiScreenEvent.DrawScreenEvent event) {
        if (requireRemovalNightVision) {
            Optional.ofNullable(Minecraft.func_71410_x().field_71439_g).ifPresent(p -> p.func_184596_c(Effects.field_76439_r));
            requireRemovalNightVision = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onClientChatEvent(ClientChatEvent event) {
        if ("/tbgui".equals(event.getMessage())) {
            delayedGui = true;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderLivingPre(RenderLivingEvent.Pre<?, EntityModel<?>> event) {
        if (hasTrueSight && event.getEntity().func_82150_aj() && Optional.ofNullable(Minecraft.func_71410_x().field_71439_g).map(p -> event.getEntity().func_98034_c((PlayerEntity)p)).orElse(false).booleanValue()) {
            event.getEntity().func_82142_c(false);
            requireRemovalVisibility = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderLivingPost(RenderLivingEvent.Post<?, EntityModel<?>> event) {
        if (requireRemovalVisibility) {
            event.getEntity().func_82142_c(true);
            requireRemovalVisibility = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpened(GuiOpenEvent event) {
        ClientPlayerEntity player;
        if (event.getGui() instanceof DeathScreen && ((Boolean)ConfigTombstone.client.skipRespawnScreen.get()).booleanValue() && (player = Minecraft.func_71410_x().field_71439_g) != null && !player.field_70170_p.func_72912_H().func_76093_s()) {
            isFirstGuiGameOver = !isFirstGuiGameOver;
            event.setCanceled(true);
            if (!isFirstGuiGameOver) {
                player.func_71004_bE();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        FluidState fluidState;
        boolean isWater;
        if ((hasTrueSight || hasWaterVision) && ((isWater = (fluidState = event.getInfo().getBlockAtCamera().func_204520_s()).func_206884_a((ITag)FluidTags.field_206959_a)) || hasTrueSight && fluidState.func_206884_a((ITag)FluidTags.field_206960_b))) {
            event.setCanceled(true);
            event.setDensity(isWater ? 0.025f : 0.8f);
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderFog(EntityViewRenderEvent.FogColors event) {
        if (hasTrueSight || hasWaterVision) {
            FluidState fluidState = event.getInfo().getBlockAtCamera().func_204520_s();
            if (fluidState.func_206884_a((ITag)FluidTags.field_206959_a)) {
                event.setRed(0.09f);
                event.setGreen(0.42f);
                event.setBlue(0.93f);
            } else if (fluidState.func_206884_a((ITag)FluidTags.field_206960_b) && hasTrueSight) {
                event.setRed(1.0f);
                event.setGreen(0.32f);
                event.setBlue(0.09f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderBlockLayer(RenderBlockOverlayEvent event) {
        if ((hasTrueSight || hasWaterVision) && (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER || event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.FIRE && hasTrueSight)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleTooltip(ItemTooltipEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (!SupportMods.ENCH_DESC.isLoaded() && ((Boolean)ConfigTombstone.client.showInfoOnEnchantment.get()).booleanValue() && event.getItemStack().func_77942_o()) {
            boolean isEnchantedBook;
            boolean bl = isEnchantedBook = event.getItemStack().func_77973_b() == Items.field_151134_bR;
            if (!isEnchantedBook && ModEnchantments.getEnchantments().values().stream().allMatch(TombstoneEnchantment::isEnabled)) {
                return;
            }
            ListNBT taglist = isEnchantedBook ? EnchantedBookItem.func_92110_g((ItemStack)event.getItemStack()) : event.getItemStack().func_77986_q();
            List list = IntStream.range(0, taglist.size()).mapToObj(arg_0 -> ((ListNBT)taglist).func_150305_b(arg_0)).map(nbt -> nbt.func_74779_i("id")).filter(id -> !id.isEmpty() && ModEnchantments.getEnchantments().containsKey(id)).map(ModEnchantments.getEnchantments()::get).collect(Collectors.toList());
            for (TombstoneEnchantment enchant : list) {
                IntStream.range(0, event.getToolTip().size()).filter(line -> {
                    ITextComponent currentTooltip = (ITextComponent)event.getToolTip().get(line);
                    return currentTooltip instanceof TranslationTextComponent && enchant.func_77320_a().equals(((TranslationTextComponent)currentTooltip).func_150268_i());
                }).findFirst().ifPresent(line -> {
                    List<ITextComponent> infos = enchant.getTooltipInfos(isEnchantedBook);
                    for (ITextComponent info : infos) {
                        event.getToolTip().add(++line, info);
                    }
                });
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        if (SKIP_RENDER_EVENT) {
            SKIP_RENDER_EVENT = false;
            return;
        }
        if (EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape) || EffectHelper.isUnstableIntangiblenessActive((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
            SKIP_RENDER_EVENT = true;
            event.getRenderer().func_225623_a_((AbstractClientPlayerEntity)event.getPlayer(), event.getPlayer().field_70177_z, event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), 0xFFFFFF);
        }
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71441_e != null) {
            MarkerHandler.instance.render(mc, event.getMatrixStack());
        }
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGameOverlayEvent.Post event) {
        if (toDisplay != null && event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            Minecraft mc = Minecraft.func_71410_x();
            MatrixStack poseStack = new MatrixStack();
            int halfWidth = mc.func_228018_at_().func_198107_o() / 2;
            int minY = 50;
            int halfLength = mc.field_71466_p.func_78256_a(toDisplay) / 2;
            mc.field_71466_p.getClass();
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)(halfWidth - halfLength - 2), (int)(minY - 2), (int)(halfWidth + halfLength + 2), (int)(minY + 9 + 1), (int)Integer.MIN_VALUE);
            AbstractGui.func_238471_a_((MatrixStack)poseStack, (FontRenderer)mc.field_71466_p, (String)toDisplay, (int)halfWidth, (int)minY, (int)-8347488);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFieldOfView(FOVUpdateEvent event) {
        if (!event.getEntity().func_184587_cr() && event.getEntity().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == ModItems.christmas_hat && event.getEntity().field_71075_bZ.func_75094_b() != 0.0f) {
            event.setNewfov(event.getNewfov() - 0.25f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClickAttack(InputEvent.ClickInputEvent event) {
        if (event.isAttack() && event.getHand() == Hand.MAIN_HAND) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null && mc.field_71439_g != null && mc.field_71439_g.func_184614_ca().func_77973_b() == ModItems.ankh_of_pray) {
                BlockState state;
                BlockRayTraceResult result;
                event.setCanceled(true);
                if (mc.field_71476_x != null && mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK && (result = (BlockRayTraceResult)mc.field_71476_x).func_237486_a_((Entity)mc.field_71439_g) < 25.0 && ModBlocks.DECORATIVE_GRAVES.containsValue((state = mc.field_71441_e.func_180495_p(result.func_216350_a())).func_177230_c()) && mc.field_71441_e.func_82737_E() >= LAST_PACKET + 20L) {
                    LAST_PACKET = mc.field_71441_e.func_82737_E();
                    PacketHandler.sendToServer(new ResetPerkMessage(result.func_216347_e(), result.func_216354_b(), result.func_216350_a(), result.func_216353_d()));
                    mc.field_71439_g.func_184609_a(Hand.MAIN_HAND);
                }
                event.setSwingHand(false);
            }
        }
    }

    static {
        SKIP_RENDER_EVENT = false;
        LAST_PACKET = 0L;
    }
}

