/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.AbstractMerchant;
import ovh.corail.tombstone.entity.ai.StayNearHome;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModEntities;

public class GraveGuardian
extends AbstractMerchant
implements IRangedAttackMob {
    @Nullable
    private GlobalPos homePos = null;
    private final ItemStack halloweenHelmet = new ItemStack((IItemProvider)Items.field_221697_cK);

    public GraveGuardian(EntityType<GraveGuardian> graveGuardianEntityType, World level) {
        super(graveGuardianEntityType, level);
        this.field_70138_W = 1.0f;
        this.func_98053_h(false);
    }

    public GraveGuardian(FMLPlayMessages.SpawnEntity spawnEntity, World level) {
        this(ModEntities.grave_guardian, level);
    }

    public static AttributeModifierMap createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 15.0).func_233813_a_();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(4, new StayNearHome<GraveGuardian>(this, GraveGuardian::getHomePos, GraveGuardian::resetHomePos, 0.8));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, false, false, target -> target instanceof IMob));
    }

    public float func_205022_a(BlockPos pos, IWorldReader level) {
        return BlockTags.field_232876_aq_.func_230235_a_((Object)level.func_180495_p(pos).func_177230_c()) ? 5.0f : 0.0f;
    }

    public GlobalPos getHomePos() {
        if (this.homePos == null) {
            this.resetHomePos();
        }
        return this.homePos;
    }

    public void resetHomePos() {
        this.homePos = GlobalPos.func_239648_a_((RegistryKey)this.field_70170_p.func_234923_W_(), (BlockPos)this.func_233580_cy_());
    }

    public void func_70624_b(@Nullable LivingEntity target) {
        super.func_70624_b(target);
        EffectHelper.addEffect(target, Effects.field_76421_d, 100, 2, new boolean[0]);
    }

    public boolean func_104002_bU() {
        return (Boolean)ConfigTombstone.decorative_grave.allowGraveGardian.get();
    }

    public void func_70623_bb() {
        if (!((Boolean)ConfigTombstone.decorative_grave.allowGraveGardian.get()).booleanValue()) {
            super.func_70623_bb();
        }
    }

    public boolean func_213397_c(double distance) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void func_82196_d(LivingEntity entity, float distance) {
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190032_gu;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_190034_gw;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190033_gv;
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(SoundEvents.field_190035_gx, 0.15f, 1.0f);
    }

    public int func_70627_aG() {
        return 200;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected int func_70682_h(int air) {
        return air;
    }

    protected void func_213333_a(DamageSource damageSource, int p_34175_, boolean p_34176_) {
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld level, DifficultyInstance difficultyInstance, SpawnReason spawnType, @Nullable ILivingEntityData groupData, @Nullable CompoundNBT compound) {
        this.func_180481_a(difficultyInstance);
        return groupData;
    }

    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        ItemStack weapon = new ItemStack((IItemProvider)Items.field_234754_kI_);
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        enchantments.put(ModEnchantments.magic_siphon, 5);
        enchantments.put(ModEnchantments.plague_bringer, 5);
        enchantments.put(ModEnchantments.blessing, 1);
        enchantments.put(Enchantments.field_185307_s, 5);
        EnchantmentHelper.func_82782_a(enchantments, (ItemStack)weapon);
        this.func_184201_a(EquipmentSlotType.MAINHAND, weapon);
        enchantments = new HashMap();
        enchantments.put(ModEnchantments.blessing, 1);
        enchantments.put(Enchantments.field_185307_s, 5);
        ItemStack chest = new ItemStack((IItemProvider)Items.field_234764_lt_);
        ItemStack leggings = new ItemStack((IItemProvider)Items.field_234765_lu_);
        ItemStack head = new ItemStack((IItemProvider)Items.field_234763_ls_);
        EnchantmentHelper.func_82782_a(enchantments, (ItemStack)chest);
        EnchantmentHelper.func_82782_a(enchantments, (ItemStack)leggings);
        EnchantmentHelper.func_82782_a(enchantments, (ItemStack)head);
        this.func_184201_a(EquipmentSlotType.CHEST, chest);
        this.func_184201_a(EquipmentSlotType.LEGS, leggings);
        this.func_184201_a(EquipmentSlotType.HEAD, head);
        ItemStack boots = new ItemStack((IItemProvider)Items.field_234766_lv_);
        enchantments = new HashMap();
        enchantments.put(Enchantments.field_234847_l_, 3);
        enchantments.put(ModEnchantments.blessing, 1);
        enchantments.put(Enchantments.field_185307_s, 5);
        EnchantmentHelper.func_82782_a(enchantments, (ItemStack)boots);
        this.func_184201_a(EquipmentSlotType.FEET, boots);
    }

    public ItemStack func_184582_a(EquipmentSlotType slot) {
        return slot == EquipmentSlotType.HEAD && TimeHelper.isDateAroundHalloween() ? this.halloweenHelmet : super.func_184582_a(slot);
    }

    public boolean func_70687_e(EffectInstance effectInstance) {
        return super.func_70687_e(effectInstance) && effectInstance.func_188419_a().field_220305_b != EffectType.HARMFUL;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S() && TimeHelper.atInterval(this.field_70170_p, 100)) {
            this.func_70691_i(1.0f);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.homePos != null) {
            NBTStackHelper.setLocation(compound, "home_position", new Location(this.homePos));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        Location loc;
        super.func_70037_a(compound);
        if (compound.func_74764_b("home_position") && !(loc = NBTStackHelper.getLocation(compound, "home_position")).isOrigin()) {
            this.homePos = loc.asGlobalPos();
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected boolean func_230282_cS_() {
        return false;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }
}

