/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.api.capability;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Perk
extends ForgeRegistryEntry<Perk>
implements Comparable<Perk>,
IStringSerializable {
    protected final String name;
    protected final ResourceLocation icon;
    private ITextComponent translation;
    private ITextComponent description;

    public Perk(String name, ResourceLocation icon) {
        this.name = name;
        this.icon = icon;
    }

    public abstract int getLevelMax();

    public boolean isDisabled(@Nullable PlayerEntity player) {
        return false;
    }

    public abstract ITextComponent getTooltip(int var1, int var2, int var3);

    public int getCost(int level) {
        return level > 0 ? 1 : 0;
    }

    public boolean isEncrypted() {
        return false;
    }

    public int getLevelBonus(PlayerEntity player) {
        return 0;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public String getTranslationKey() {
        return "tombstone.perk." + this.name;
    }

    public ITextComponent getTranslation() {
        if (this.translation == null) {
            this.translation = new TranslationTextComponent(this.getTranslationKey());
        }
        return this.translation;
    }

    public ITextComponent getDescription() {
        if (this.description == null) {
            this.description = new TranslationTextComponent("tombstone.perk." + this.name + ".desc");
        }
        return this.description;
    }

    public ITextComponent getSpecialInfo(int levelWithBonus) {
        return StringTextComponent.field_240750_d_;
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    @Override
    public int compareTo(Perk perk) {
        return this.name.compareTo(perk.name);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.name.equals(((Perk)o).name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

