/*
 * Decompiled with CFR 0.152.
 */
package shadows.toaster;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.Logger;
import shadows.placebo.util.ReflectionHelper;
import shadows.toaster.BetterGuiToast;
import shadows.toaster.ToastConfig;
import shadows.toaster.ToastLoader;

public class ToastControl {
    public static final String MODID = "toastcontrol";
    public static final Logger LOGGER = ToastLoader.LOGGER;
    public static final KeyBinding CLEAR = new KeyBinding("key.toastcontrol.clear", 74, "key.toastcontrol.category");
    public static final ResourceLocation TRANSLUCENT = new ResourceLocation("toastcontrol", "textures/gui/toasts.png");
    public static final ResourceLocation TRANSPARENT = new ResourceLocation("toastcontrol", "textures/gui/toasts2.png");
    public static final ResourceLocation ORIGINAL = new ResourceLocation("textures/gui/toasts.png");
    public static final List<Class<?>> BLOCKED_CLASSES = new ArrayList();
    public static List<BetterGuiToast.BetterToastInstance<?>> tracker = new ArrayList();

    @SubscribeEvent
    public void keys(InputEvent.KeyInputEvent e) {
        if (CLEAR.func_151470_d()) {
            Minecraft.func_71410_x().func_193033_an().func_191788_b();
        }
    }

    public void preInit(FMLClientSetupEvent e) {
        Minecraft.func_71410_x().field_193034_aS = new BetterGuiToast();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ToastControl.handleToastReloc();
        ToastControl.handleBlockedClasses();
        ClientRegistry.registerKeyBinding((KeyBinding)CLEAR);
    }

    static void handleToastReloc() {
        ResourceLocation target = IToast.field_193654_a;
        if (((Boolean)ToastConfig.INSTANCE.translucent.get()).booleanValue()) {
            ToastControl.change(target, TRANSLUCENT);
        }
        if (((Boolean)ToastConfig.INSTANCE.transparent.get()).booleanValue()) {
            ToastControl.change(target, TRANSPARENT);
        } else if (!((Boolean)ToastConfig.INSTANCE.translucent.get()).booleanValue() && !((Boolean)ToastConfig.INSTANCE.transparent.get()).booleanValue()) {
            ToastControl.change(target, ORIGINAL);
        }
    }

    private static void change(ResourceLocation a, ResourceLocation b) {
        ReflectionHelper.setPrivateValue(ResourceLocation.class, (Object)a, (Object)b.func_110624_b(), (String[])new String[]{"namespace", "field_110626_a"});
        ReflectionHelper.setPrivateValue(ResourceLocation.class, (Object)a, (Object)b.func_110623_a(), (String[])new String[]{"path", "field_110625_b"});
    }

    static void handleBlockedClasses() {
        BLOCKED_CLASSES.clear();
        for (String s : (List)ToastConfig.INSTANCE.blockedClasses.get()) {
            try {
                Class<?> c = Class.forName(s);
                BLOCKED_CLASSES.add(c);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Invalid class string provided to toast control: " + s);
            }
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            for (BetterGuiToast.BetterToastInstance<?> t : tracker) {
                t.tick();
            }
        }
    }
}

