/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.data;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import slimeknights.tmechworks.common.MechworksContent;
import slimeknights.tmechworks.common.MechworksTags;
import slimeknights.tmechworks.library.Util;

public class Recipes
extends RecipeProvider
implements IConditionBuilder {
    private static final int standardSmeltingTime = 200;
    private static final int standardBlastingTime = 100;

    public Recipes(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void func_200404_a(@Nonnull Consumer<IFinishedRecipe> out) {
        this.registerMetal(out, (IItemProvider)MechworksContent.Blocks.aluminum_ore, (IItemProvider)MechworksContent.Items.aluminum_nugget, (IItemProvider)MechworksContent.Items.aluminum_ingot, (IItemProvider)MechworksContent.Blocks.aluminum_block);
        this.registerMetal(out, (IItemProvider)MechworksContent.Blocks.copper_ore, (IItemProvider)MechworksContent.Items.copper_nugget, (IItemProvider)MechworksContent.Items.copper_ingot, (IItemProvider)MechworksContent.Blocks.copper_block);
        Recipes.wrap(ShapelessRecipeBuilder.func_200486_a(MechworksContent.Items.book).func_200487_b((IItemProvider)Items.field_151122_aG).func_200487_b(MechworksContent.Items.upgrade_blank), (IItemProvider)Items.field_151122_aG).func_200482_a(out);
        Recipes.wrap(ShapedRecipeBuilder.func_200470_a(MechworksContent.Blocks.drawbridge).func_200473_b(Util.prefix("machines")).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('A'), MechworksTags.Items.INGOTS_ALUMINUM).func_200462_a(Character.valueOf('U'), MechworksContent.Items.upgrade_drawbridge_distance).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_221602_aD).func_200472_a("RAR").func_200472_a("PUP").func_200472_a("RAR"), MechworksContent.Items.copper_ingot).func_200464_a(out);
        Recipes.wrap(ShapedRecipeBuilder.func_200470_a(MechworksContent.Blocks.firestarter).func_200473_b(Util.prefix("machines")).func_200469_a(Character.valueOf('C'), MechworksTags.Items.INGOTS_COPPER).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('A'), MechworksTags.Items.INGOTS_ALUMINUM).func_200462_a(Character.valueOf('B'), MechworksContent.Items.upgrade_blank).func_200462_a(Character.valueOf('F'), (IItemProvider)Items.field_151033_d).func_200472_a("RAR").func_200472_a("FBF").func_200472_a("ACA"), MechworksContent.Items.copper_ingot).func_200464_a(out);
        Recipes.wrap(ShapedRecipeBuilder.func_200470_a(MechworksContent.Items.upgrade_blank).func_200473_b(Util.prefix("upgrades")).func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('C'), MechworksTags.Items.INGOTS_COPPER).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('A'), MechworksTags.Items.INGOTS_ALUMINUM).func_200472_a("IAI").func_200472_a("RIR").func_200472_a("ACA"), (IItemProvider)Items.field_151137_ax).func_200464_a(out);
        Recipes.wrap(ShapedRecipeBuilder.func_200470_a(MechworksContent.Items.upgrade_drawbridge_advanced).func_200473_b(Util.prefix("upgrades")).func_200462_a(Character.valueOf('B'), MechworksContent.Items.upgrade_blank).func_200462_a(Character.valueOf('H'), (IItemProvider)Items.field_221862_eo).func_200469_a(Character.valueOf('C'), MechworksTags.Items.INGOTS_COPPER).func_200469_a(Character.valueOf('A'), MechworksTags.Items.INGOTS_ALUMINUM).func_200469_a(Character.valueOf('L'), (ITag)Tags.Items.STORAGE_BLOCKS_LAPIS).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.CHESTS_WOODEN).func_200472_a("CHC").func_200472_a("LBL").func_200472_a("ASA"), MechworksContent.Items.upgrade_blank).func_200464_a(out);
        Recipes.wrap(ShapedRecipeBuilder.func_200470_a(MechworksContent.Items.upgrade_drawbridge_distance).func_200473_b(Util.prefix("upgrades")).func_200462_a(Character.valueOf('B'), MechworksContent.Items.upgrade_blank).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_221602_aD).func_200469_a(Character.valueOf('C'), MechworksTags.Items.INGOTS_COPPER).func_200469_a(Character.valueOf('A'), MechworksTags.Items.INGOTS_ALUMINUM).func_200472_a("ACA").func_200472_a("PBP").func_200472_a(" A "), MechworksContent.Items.upgrade_blank).func_200464_a(out);
        Recipes.wrap(ShapedRecipeBuilder.func_200470_a(MechworksContent.Items.upgrade_speed).func_200473_b(Util.prefix("upgrades")).func_200462_a(Character.valueOf('B'), MechworksContent.Items.upgrade_blank).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151102_aT).func_200472_a(" S ").func_200472_a("SBS").func_200472_a(" S "), MechworksContent.Items.upgrade_blank).func_200464_a(out);
    }

    private void registerMetal(@Nonnull Consumer<IFinishedRecipe> out, IItemProvider ore, IItemProvider nugget, IItemProvider ingot, IItemProvider storageBlock) {
        String format = Util.prefix("%s_from_%s");
        String nuggetName = nugget.func_199767_j().getRegistryName().func_110623_a();
        String ingotName = ingot.func_199767_j().getRegistryName().func_110623_a();
        String storageBlockName = storageBlock.func_199767_j().getRegistryName().func_110623_a();
        Recipes.wrap(CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ore}), (IItemProvider)ingot, (float)1.0f, (int)200), ore).func_218632_a(out, String.format(format, ingotName, "smelting"));
        Recipes.wrap(CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ore}), (IItemProvider)ingot, (float)1.0f, (int)100), ore).func_218632_a(out, String.format(format, ingotName, "blasting"));
        Recipes.compress(ingot, storageBlock).func_200473_b(Util.prefix(storageBlockName)).func_200466_a(out, String.format(format, storageBlockName, ingotName));
        Recipes.decompress(storageBlock, ingot).func_200490_a(Util.prefix(ingotName)).func_200484_a(out, String.format(format, ingotName, storageBlockName));
        Recipes.compress(nugget, ingot).func_200473_b(Util.prefix(ingotName)).func_200466_a(out, String.format(format, ingotName, nuggetName));
        Recipes.decompress(ingot, nugget).func_200490_a(Util.prefix(nuggetName)).func_200484_a(out, String.format(format, nuggetName, ingotName));
    }

    private static ShapelessRecipeBuilder wrap(ShapelessRecipeBuilder builder, IItemProvider input) {
        return builder.func_200483_a("has_" + input.func_199767_j().getRegistryName().func_110623_a(), (ICriterionInstance)Recipes.func_200403_a((IItemProvider)input));
    }

    private static ShapedRecipeBuilder wrap(ShapedRecipeBuilder builder, IItemProvider input) {
        return builder.func_200465_a("has_" + input.func_199767_j().getRegistryName().func_110623_a(), (ICriterionInstance)Recipes.func_200403_a((IItemProvider)input));
    }

    private static CookingRecipeBuilder wrap(CookingRecipeBuilder builder, IItemProvider input) {
        return builder.func_218628_a("has_" + input.func_199767_j().getRegistryName().func_110623_a(), (ICriterionInstance)Recipes.func_200403_a((IItemProvider)input));
    }

    private static ShapedRecipeBuilder compress(IItemProvider input, IItemProvider result) {
        return Recipes.wrap(ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200462_a(Character.valueOf('#'), input).func_200472_a("###").func_200472_a("###").func_200472_a("###"), input);
    }

    private static ShapelessRecipeBuilder decompress(IItemProvider input, IItemProvider result) {
        return Recipes.wrap(ShapelessRecipeBuilder.func_200488_a((IItemProvider)result, (int)9).func_200487_b(input), input);
    }

    @Nonnull
    public String func_200397_b() {
        return "Tinkers' Mechworks Recipes";
    }
}

