/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.blocks.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import slimeknights.tmechworks.common.MechworksContent;
import slimeknights.tmechworks.common.MechworksTags;
import slimeknights.tmechworks.common.blocks.FirestarterBlock;
import slimeknights.tmechworks.common.blocks.tileentity.RedstoneMachineTileEntity;
import slimeknights.tmechworks.integration.waila.IInformationProvider;
import slimeknights.tmechworks.library.Util;

public class FirestarterTileEntity
extends RedstoneMachineTileEntity {
    public FirestarterTileEntity() {
        super((TileEntityType)MechworksContent.TileEntities.firestarter.get(), (ITextComponent)new TranslationTextComponent(Util.prefix("inventory.firestarter")), 0);
    }

    @Override
    public void onRedstoneUpdate() {
        super.onRedstoneUpdate();
        this.setFire();
    }

    public void setFire() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        Direction facing = (Direction)state.func_177229_b((Property)FirestarterBlock.field_176387_N);
        boolean shouldExtinguish = (Boolean)state.func_177229_b((Property)FirestarterBlock.EXTINGUISH);
        BlockPos loc = this.func_174877_v();
        BlockPos position = new BlockPos(loc.func_177958_n() + facing.func_82601_c(), loc.func_177956_o() + facing.func_96559_d(), loc.func_177952_p() + facing.func_82599_e());
        BlockState forwardState = this.field_145850_b.func_180495_p(position);
        if (this.getRedstoneState() > 0) {
            if (forwardState.isAir((IBlockReader)this.func_145831_w(), position) && Blocks.field_150480_ab.func_196260_a(forwardState, (IWorldReader)this.field_145850_b, position)) {
                this.field_145850_b.func_184148_a(null, (double)loc.func_177958_n() + 0.5, (double)loc.func_177956_o() + 0.5, (double)loc.func_177952_p() + 0.5, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, Util.rand.nextFloat() * 0.4f + 0.8f);
                this.field_145850_b.func_180501_a(position, Blocks.field_150480_ab.func_176223_P(), 11);
            }
        } else if (shouldExtinguish && MechworksTags.Blocks.FIRESTARTER_WHITELIST.func_230235_a_((Object)forwardState.func_177230_c())) {
            this.field_145850_b.func_184148_a(null, (double)loc.func_177958_n() + 0.5, (double)loc.func_177956_o() + 0.5, (double)loc.func_177952_p() + 0.5, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, Util.rand.nextFloat() * 0.4f + 0.8f);
            this.field_145850_b.func_217377_a(position, false);
        }
    }

    @Override
    public ItemStack storeTileData(ItemStack stack) {
        return stack;
    }

    @Override
    public void getInformation(@Nonnull List<ITextComponent> info, @Nonnull IInformationProvider.InformationType type, PlayerEntity player) {
        super.getInformation(info, type, player);
        if (type != IInformationProvider.InformationType.BODY) {
            return;
        }
        BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        boolean shouldExtinguish = (Boolean)state.func_177229_b((Property)FirestarterBlock.EXTINGUISH);
        info.add((ITextComponent)new TranslationTextComponent(Util.prefix("tooltip.behaviour"), new Object[]{I18n.func_135052_a((String)Util.prefix("tooltip.behaviour.firestarter." + (shouldExtinguish ? "extinguish" : "keep")), (Object[])new Object[0])}));
    }
}

