/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.blocks.tileentity;

import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.wrapper.InvWrapper;
import slimeknights.tmechworks.common.MechworksContent;
import slimeknights.tmechworks.common.MechworksTags;
import slimeknights.tmechworks.common.blocks.DrawbridgeBlock;
import slimeknights.tmechworks.common.blocks.RedstoneMachineBlock;
import slimeknights.tmechworks.common.blocks.tileentity.IPlaceDirection;
import slimeknights.tmechworks.common.blocks.tileentity.RedstoneMachineTileEntity;
import slimeknights.tmechworks.common.config.MechworksConfig;
import slimeknights.tmechworks.common.inventory.DrawbridgeContainer;
import slimeknights.tmechworks.common.inventory.FragmentedInventory;
import slimeknights.tmechworks.common.items.MachineUpgradeItem;
import slimeknights.tmechworks.integration.waila.IInformationProvider;
import slimeknights.tmechworks.library.Util;

public class DrawbridgeTileEntity
extends RedstoneMachineTileEntity
implements IPlaceDirection {
    private static final float TICK_TIME = 0.05f;
    public DrawbridgeStats stats;
    public static final int UPGRADES_SIZE = 4;
    public final FragmentedInventory upgrades;
    public final FragmentedInventory slots;
    private WeakReference<FakePlayer> fakePlayer;
    private Direction placeDirection;
    private Direction rawPlaceDirection;
    private Angle placeAngle = Angle.NEUTRAL;
    private boolean isMoving;
    private boolean isExtended;
    private int extendedLength;
    private float cooldown;
    private static boolean isCapAccess;
    private long lastWorldTime;

    public DrawbridgeTileEntity() {
        super((TileEntityType)MechworksContent.TileEntities.drawbridge.get(), (ITextComponent)new TranslationTextComponent(Util.prefix("inventory.drawbridge")), 5);
        this.upgrades = new FragmentedInventory((IInventory)this, 0, 4).overrideStackLimit(1).setValidItemsPredicate(stack -> stack.func_77973_b() instanceof MachineUpgradeItem);
        this.slots = new FragmentedInventory((IInventory)this, 4, 1).setValidItemsPredicate(stack -> stack.func_77973_b() instanceof BlockItem && !MechworksTags.Blocks.DRAWBRIDGE_BLACKLIST.func_230235_a_((Object)Block.func_149634_a((Item)stack.func_77973_b()))).overrideStackLimit(64);
        this.itemHandlerCap.invalidate();
        this.itemHandler = new DrawbridgeItemHandler(this);
        this.itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void func_73660_a() {
        super.func_73660_a();
        float delta = (float)(this.func_145831_w().func_82737_E() - this.lastWorldTime) * 0.05f;
        this.lastWorldTime = this.func_145831_w().func_82737_E();
        if (this.placeDirection == null) {
            this.setPlaceDirectionRelativeToBlock(Direction.NORTH);
        }
        if (this.isMoving) {
            if (this.cooldown > 0.0f) {
                this.cooldown -= delta;
                this.markDirtyFast();
                return;
            }
            if (this.isExtended) {
                if (this.extendedLength >= this.stats.extendLength) {
                    this.isMoving = false;
                    this.markDirtyFast();
                    return;
                }
                int extend = this.extendedLength + 1;
                Direction dir = (Direction)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((Property)DrawbridgeBlock.field_176387_N);
                BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n() + dir.func_82601_c() * extend, this.func_174877_v().func_177956_o() + dir.func_96559_d() * extend, this.func_174877_v().func_177952_p() + dir.func_82599_e() * extend);
                if (!this.placeBlock(pos, this.slots.func_70301_a(this.getSlot()))) {
                    this.isMoving = false;
                    this.markDirtyFast();
                    return;
                }
                ++this.extendedLength;
                this.cooldown = this.stats.extendDelay;
                this.field_145850_b.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.25f, Util.rand.nextFloat() * 0.25f + 0.6f);
            } else {
                if (this.extendedLength > this.stats.extendLength) {
                    this.extendedLength = this.stats.extendLength;
                }
                if (this.extendedLength <= 0) {
                    this.isMoving = false;
                    this.extendedLength = 0;
                    this.markDirtyFast();
                    return;
                }
                int extend = this.extendedLength--;
                Direction dir = (Direction)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((Property)DrawbridgeBlock.field_176387_N);
                BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n() + dir.func_82601_c() * extend, this.func_174877_v().func_177956_o() + dir.func_96559_d() * extend, this.func_174877_v().func_177952_p() + dir.func_82599_e() * extend);
                if (!this.breakBlock(pos, this.getSlot())) {
                    this.isMoving = false;
                    this.extendedLength = 0;
                    this.markDirtyFast();
                    return;
                }
                this.cooldown = this.stats.extendDelay;
                this.field_145850_b.func_184133_a(null, pos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.25f, Util.rand.nextFloat() * 0.15f + 0.6f);
            }
            this.markDirtyFast();
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.rawPlaceDirection == null) {
            this.rawPlaceDirection = Direction.NORTH;
        }
        if (this.placeDirection == null) {
            this.setPlaceDirectionRelativeToBlock(this.rawPlaceDirection);
        }
        if (this.placeAngle == null) {
            this.setPlaceAngle(Angle.NEUTRAL);
        }
        this.computeStats();
        this.lastWorldTime = this.field_145850_b.func_82737_E();
    }

    @Override
    public void onRedstoneUpdate() {
        super.onRedstoneUpdate();
        if (this.isExtended && this.getRedstoneState() <= 0) {
            this.isExtended = false;
            this.isMoving = true;
            Direction dir = (Direction)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((Property)DrawbridgeBlock.field_176387_N);
            World world = this.func_145831_w();
            for (int i = 1; i <= this.extendedLength; ++i) {
                BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n() + dir.func_82601_c() * i, this.func_174877_v().func_177956_o() + dir.func_96559_d() * i, this.func_174877_v().func_177952_p() + dir.func_82599_e() * i);
                if (!world.func_175623_d(pos)) continue;
                this.extendedLength = i - 1;
                break;
            }
        } else if (!this.isExtended && this.getRedstoneState() > 0) {
            this.isExtended = true;
            this.isMoving = true;
        }
    }

    public int getSlot() {
        if (!this.stats.isAdvanced) {
            return 0;
        }
        return this.isExtended ? this.extendedLength : this.extendedLength - 1;
    }

    public boolean placeBlock(BlockPos pos, ItemStack stack) {
        if (this.func_145831_w().field_72995_K) {
            return false;
        }
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem)) {
            return false;
        }
        if (MechworksTags.Blocks.DRAWBRIDGE_BLACKLIST.func_230235_a_((Object)Block.func_149634_a((Item)stack.func_77973_b()))) {
            return false;
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P().func_185887_b((IBlockReader)this.func_145831_w(), this.func_174877_v()) < 0.0f) {
            return false;
        }
        FakePlayer player = this.getFakePlayer(pos);
        if (player == null) {
            return false;
        }
        double yOffset = 0.0;
        switch (this.getPlaceAngle()) {
            case LOW: {
                yOffset = 0.1;
                break;
            }
            case NEUTRAL: {
                yOffset = 0.5;
                break;
            }
            case HIGH: {
                yOffset = 0.9;
            }
        }
        player.func_184201_a(EquipmentSlotType.MAINHAND, stack);
        ItemUseContext ctx = new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, new BlockRayTraceResult(new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + 0.5), this.getPlaceDirection(), pos, false));
        return this.doPlaceBlock(new DrawbridgeItemUseContext(ctx)).func_226246_a_();
    }

    public boolean breakBlock(BlockPos pos, int targetSlot) {
        World world = this.func_145831_w();
        if (world.field_72995_K) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.isAir((IBlockReader)world, pos) || state.func_185887_b((IBlockReader)this.func_145831_w(), this.func_174877_v()) < 0.0f || MechworksTags.Blocks.DRAWBRIDGE_BLACKLIST.func_230235_a_((Object)state.func_177230_c())) {
            return false;
        }
        ItemStack tool = DrawbridgeTools.getByType(state.getHarvestTool());
        LootContext.Builder context = new LootContext.Builder((ServerWorld)world);
        context.func_216021_b(LootParameters.field_216288_h, (Object)world.func_175625_s(pos)).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)tool);
        ItemStack stack = this.slots.func_70301_a(targetSlot);
        List<ItemStack> drops = state.func_215693_a(context).stream().filter(x -> !x.func_190926_b()).collect(Collectors.toList());
        if (stack.func_190926_b()) {
            ItemStack target = drops.stream().filter(x -> this.slots.func_94041_b(targetSlot, (ItemStack)x)).findFirst().orElse(ItemStack.field_190927_a);
            if (!target.func_190926_b() && drops.remove(target)) {
                this.slots.func_70299_a(targetSlot, target);
            }
        } else {
            ItemStack target = drops.stream().filter(x -> stack.func_77969_a(x) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)x)).findFirst().orElse(ItemStack.field_190927_a);
            if (!target.func_190926_b() && drops.remove(target)) {
                int remainder = Math.max(stack.func_190916_E() + target.func_190916_E() - Math.min(stack.func_77976_d(), this.slots.func_70297_j_()), 0);
                int targetCount = target.func_190916_E() - remainder;
                stack.func_190920_e(stack.func_190916_E() + targetCount);
                if (remainder > 0) {
                    target.func_190920_e(remainder);
                    drops.add(target);
                }
            }
        }
        drops.forEach(x -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)x));
        world.func_217377_a(pos, false);
        state.func_177230_c().func_176206_d((IWorld)world, pos, state);
        return true;
    }

    public void computeStats() {
        DrawbridgeStats stats = new DrawbridgeStats();
        for (int i = 0; i < this.upgrades.func_70302_i_(); ++i) {
            Item item = this.upgrades.func_70301_a(i).func_77973_b();
            if (!(item instanceof MachineUpgradeItem)) continue;
            ((MachineUpgradeItem)item).effect.accept(stats);
        }
        this.stats = stats;
        this.onStatsUpdated();
    }

    public void onStatsUpdated() {
        int blockSlots = this.stats.isAdvanced ? this.stats.extendLength : 1;
        World world = this.func_145831_w();
        BlockPos pos = this.func_174877_v();
        for (int i = this.slots.func_70302_i_() - 1; i >= blockSlots; --i) {
            ItemStack stack = this.slots.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            this.slots.func_70299_a(i, ItemStack.field_190927_a);
        }
        this.resize(4 + blockSlots);
        this.slots.resize(blockSlots);
        this.slots.overrideStackLimit(this.stats.isAdvanced ? 1 : 64);
        BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a((Property)DrawbridgeBlock.ADVANCED, (Comparable)Boolean.valueOf(this.stats.isAdvanced)));
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        super.func_230337_a_(state, tags);
        CompoundNBT stats = tags.func_74775_l("DrawbridgeState");
        this.extendedLength = stats.func_74762_e("ExtendLength");
        this.isExtended = stats.func_74767_n("Extended");
        this.isMoving = stats.func_74767_n("Moving");
        this.cooldown = stats.func_74760_g("Cooldown");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tags) {
        tags = super.func_189515_b(tags);
        CompoundNBT state = new CompoundNBT();
        state.func_74768_a("ExtendLength", this.extendedLength);
        state.func_74757_a("Extended", this.isExtended);
        state.func_74757_a("Moving", this.isMoving);
        state.func_74776_a("Cooldown", this.cooldown);
        tags.func_218657_a("DrawbridgeState", (INBT)state);
        return tags;
    }

    @Override
    public void readItemData(BlockState state, CompoundNBT tags) {
        super.readItemData(state, tags);
        this.rawPlaceDirection = Direction.values()[tags.func_74762_e("PlaceDirectionRaw")];
        this.placeAngle = Angle.values()[tags.func_74762_e("PlaceAngle")];
    }

    @Override
    public CompoundNBT writeItemData(CompoundNBT tags) {
        if (this.rawPlaceDirection == null) {
            this.rawPlaceDirection = Direction.NORTH;
        }
        tags.func_74768_a("PlaceDirectionRaw", this.rawPlaceDirection.ordinal());
        tags.func_74768_a("PlaceAngle", this.placeAngle.ordinal());
        return super.writeItemData(tags);
    }

    @Override
    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new DrawbridgeContainer(id, playerInventory, this);
    }

    @Override
    public void setPlaceDirection(int direction) {
        if (direction < Direction.values().length) {
            this.setPlaceDirectionRelativeToBlock(Direction.values()[direction]);
        } else if (direction - Direction.values().length < Angle.values().length) {
            this.setPlaceAngle(Angle.values()[direction - Direction.values().length]);
        } else {
            throw new IllegalArgumentException("Direction " + direction + " cannot be mapped to any direction or angle.");
        }
    }

    public Direction getPlaceDirection() {
        return this.placeDirection;
    }

    public Direction getRawPlaceDirection() {
        return this.rawPlaceDirection;
    }

    public Angle getPlaceAngle() {
        return this.placeAngle;
    }

    public void setPlaceAngle(Angle angle) {
        this.placeAngle = angle;
        this.func_70296_d();
    }

    public void setPlaceDirection(Direction direction) {
        this.placeDirection = direction;
        this.func_70296_d();
    }

    public void setPlaceDirectionRelativeToBlock(Direction direction) {
        this.rawPlaceDirection = direction;
        Direction facing = (Direction)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((Property)RedstoneMachineBlock.field_176387_N);
        block0 : switch (direction) {
            case UP: {
                switch (facing) {
                    case UP: {
                        this.setPlaceDirection(Direction.SOUTH);
                        break block0;
                    }
                    case DOWN: {
                        this.setPlaceDirection(Direction.NORTH);
                        break block0;
                    }
                }
                this.setPlaceDirection(Direction.UP);
                break;
            }
            case DOWN: {
                switch (facing) {
                    case UP: {
                        this.setPlaceDirection(Direction.NORTH);
                        break block0;
                    }
                    case DOWN: {
                        this.setPlaceDirection(Direction.SOUTH);
                        break block0;
                    }
                }
                this.setPlaceDirection(Direction.DOWN);
                break;
            }
            case NORTH: {
                this.setPlaceDirection(facing);
                break;
            }
            case SOUTH: {
                this.setPlaceDirection(facing.func_176734_d());
                break;
            }
            case EAST: {
                switch (facing) {
                    case UP: 
                    case DOWN: {
                        this.setPlaceDirection(direction);
                        break block0;
                    }
                }
                this.setPlaceDirection(facing.func_176746_e());
                break;
            }
            case WEST: {
                switch (facing) {
                    case UP: 
                    case DOWN: {
                        this.setPlaceDirection(direction);
                        break block0;
                    }
                }
                this.setPlaceDirection(facing.func_176735_f());
            }
        }
    }

    public void updateFakePlayer(BlockPos pos) {
        this.fakePlayer = Util.getFakePlayer(this.field_145850_b);
        if (this.fakePlayer == null) {
            return;
        }
        FakePlayer player = (FakePlayer)this.fakePlayer.get();
        player.field_70177_z = 0.0f;
        player.field_70125_A = 0.0f;
        float posX = pos.func_177958_n();
        float posY = pos.func_177956_o();
        float posZ = pos.func_177952_p();
        switch (this.placeDirection) {
            case NORTH: {
                player.field_70177_z = 0.0f;
                posZ += 2.0f;
                break;
            }
            case SOUTH: {
                player.field_70177_z = 180.0f;
                posZ -= 2.0f;
                break;
            }
            case UP: {
                player.field_70125_A = 90.0f;
                posY += 2.0f;
                break;
            }
            case DOWN: {
                player.field_70125_A = -90.0f;
                posY -= 2.0f;
                break;
            }
            case EAST: {
                player.field_70177_z = 90.0f;
                posX -= 2.0f;
                break;
            }
            case WEST: {
                player.field_70177_z = -90.0f;
                posX += 2.0f;
            }
        }
        switch (this.placeAngle) {
            case HIGH: {
                player.field_70125_A -= 45.0f;
                break;
            }
            case LOW: {
                player.field_70125_A += 45.0f;
            }
        }
        player.field_70127_C = player.field_70125_A;
        player.field_70126_B = player.field_70177_z;
        player.field_70758_at = player.field_70759_as = player.field_70177_z;
        player.func_70107_b((double)posX, (double)posY, (double)posZ);
    }

    public void func_70299_a(int slot, @Nonnull ItemStack itemstack) {
        super.func_70299_a(slot, itemstack);
        if (this.upgrades.isSlotInInventory(slot)) {
            this.computeStats();
        }
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        if (!isCapAccess) {
            return false;
        }
        if (!this.slots.isSlotInInventory(slot - this.slots.getStartSlot())) {
            return false;
        }
        return super.func_94041_b(slot, stack) && this.slots.func_94041_b(slot - this.slots.getStartSlot(), stack);
    }

    public FakePlayer getFakePlayer(BlockPos pos) {
        this.updateFakePlayer(pos);
        return (FakePlayer)this.fakePlayer.get();
    }

    @Override
    public void getInformation(@Nonnull List<ITextComponent> info, @Nonnull IInformationProvider.InformationType type, CompoundNBT serverData, PlayerEntity player) {
        super.getInformation(info, type, serverData, player);
        if (type != IInformationProvider.InformationType.BODY) {
            return;
        }
        info.add((ITextComponent)new TranslationTextComponent(Util.prefix("machine.stats")));
        info.add((ITextComponent)new TranslationTextComponent(Util.prefix("drawbridge.stats.advanced"), new Object[]{this.stats.isAdvanced}));
        info.add((ITextComponent)new TranslationTextComponent(Util.prefix("drawbridge.stats.length"), new Object[]{this.stats.extendLength}));
        info.add((ITextComponent)new TranslationTextComponent(Util.prefix("drawbridge.stats.delay"), new Object[]{Float.valueOf(this.stats.extendDelay)}));
        info.add((ITextComponent)new StringTextComponent(""));
        if (!serverData.isEmpty()) {
            this.requireSneak(info, player, () -> {
                info.add((ITextComponent)new TranslationTextComponent(Util.prefix("machine.state")));
                info.add((ITextComponent)new TranslationTextComponent(Util.prefix("drawbridge.state.moving"), new Object[]{serverData.func_74767_n("moving")}));
                info.add((ITextComponent)new TranslationTextComponent(Util.prefix("drawbridge.state.extended"), new Object[]{serverData.func_74767_n("extended")}));
                info.add((ITextComponent)new TranslationTextComponent(Util.prefix("drawbridge.state.extendedcount"), new Object[]{serverData.func_74762_e("extendedCount")}));
            });
        }
    }

    @Override
    public void syncInformation(CompoundNBT nbt, ServerPlayerEntity player) {
        nbt.func_74757_a("extended", this.isExtended);
        nbt.func_74757_a("moving", this.isMoving);
        nbt.func_74768_a("extendedCount", this.extendedLength);
    }

    public ActionResultType doPlaceBlock(DrawbridgeItemUseContext context) {
        ItemStack itemstack = context.func_195996_i();
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        if (player != null && !player.field_71075_bZ.field_75099_e && !itemstack.func_206847_b(world.func_205772_D(), new CachedBlockInfo((IWorldReader)world, context.func_195995_a(), false))) {
            return ActionResultType.PASS;
        }
        if (!(itemstack.func_77973_b() instanceof BlockItem)) {
            return ActionResultType.FAIL;
        }
        BlockItem item = (BlockItem)itemstack.func_77973_b();
        int size = itemstack.func_190916_E();
        CompoundNBT nbt = null;
        if (itemstack.func_77978_p() != null) {
            nbt = itemstack.func_77978_p().func_74737_b();
        }
        if (!(itemstack.func_77973_b() instanceof BucketItem)) {
            world.captureBlockSnapshots = true;
        }
        ItemStack copy = itemstack.func_77946_l();
        ActionResultType ret = item.func_195942_a((BlockItemUseContext)context);
        if (itemstack.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)copy, (Hand)context.func_221531_n());
        }
        world.captureBlockSnapshots = false;
        if (ret.func_226246_a_()) {
            int newSize = itemstack.func_190916_E();
            CompoundNBT newNBT = null;
            if (itemstack.func_77978_p() != null) {
                newNBT = itemstack.func_77978_p().func_74737_b();
            }
            List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
            world.capturedBlockSnapshots.clear();
            itemstack.func_190920_e(size);
            itemstack.func_77982_d(nbt);
            Direction side = context.func_196000_l();
            boolean eventResult = false;
            if (blockSnapshots.size() > 1) {
                eventResult = ForgeEventFactory.onMultiBlockPlace((Entity)player, (List)blockSnapshots, (Direction)side);
            } else if (blockSnapshots.size() == 1) {
                eventResult = ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)((BlockSnapshot)blockSnapshots.get(0)), (Direction)side);
            }
            if (eventResult) {
                ret = ActionResultType.FAIL;
                for (BlockSnapshot blocksnapshot : Lists.reverse((List)blockSnapshots)) {
                    world.restoringBlockSnapshots = true;
                    blocksnapshot.restore(true, false);
                    world.restoringBlockSnapshots = false;
                }
            } else {
                itemstack.func_190920_e(newSize);
                itemstack.func_77982_d(newNBT);
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.getFlag();
                    BlockState oldBlock = snap.getReplacedBlock();
                    BlockState newBlock = world.func_180495_p(snap.getPos());
                    if (!newBlock.hasTileEntity()) {
                        newBlock.func_215705_a(world, snap.getPos(), oldBlock, false);
                    }
                    world.markAndNotifyBlock(snap.getPos(), world.func_175726_f(snap.getPos()), oldBlock, newBlock, updateFlag, 512);
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item));
            }
        }
        world.capturedBlockSnapshots.clear();
        return ret;
    }

    private static class DrawbridgeTools {
        public static final ItemStack PICKAXE = new ItemStack((IItemProvider)Items.field_151046_w);
        public static final ItemStack AXE = new ItemStack((IItemProvider)Items.field_151056_x);
        public static final ItemStack SHOVEL = new ItemStack((IItemProvider)Items.field_151047_v);

        private DrawbridgeTools() {
        }

        public static ItemStack getByType(ToolType type) {
            if (type == null) {
                return PICKAXE;
            }
            switch (type.getName()) {
                case "pickaxe": {
                    return PICKAXE;
                }
                case "axe": {
                    return AXE;
                }
                case "shovel": {
                    return SHOVEL;
                }
            }
            return PICKAXE;
        }

        static {
            PICKAXE.func_77966_a(Enchantments.field_185306_r, 1);
            AXE.func_77966_a(Enchantments.field_185306_r, 1);
            SHOVEL.func_77966_a(Enchantments.field_185306_r, 1);
        }
    }

    private static class DrawbridgeItemHandler
    extends InvWrapper {
        private final DrawbridgeTileEntity te;

        public DrawbridgeItemHandler(DrawbridgeTileEntity inv) {
            super((IInventory)inv);
            this.te = inv;
        }

        @Nonnull
        public ItemStack insertItem(int slotAbs, @Nonnull ItemStack stack, boolean simulate) {
            int slot = slotAbs - this.te.slots.getStartSlot();
            if (slot < 0 || slot >= this.te.slots.func_70302_i_()) {
                return stack;
            }
            isCapAccess = true;
            ItemStack out = super.insertItem(slotAbs, stack, simulate);
            isCapAccess = false;
            return out;
        }

        @Nonnull
        public ItemStack extractItem(int slotAbs, int amount, boolean simulate) {
            int slot = slotAbs - this.te.slots.getStartSlot();
            if (slot < 0 || slot >= this.te.slots.func_70302_i_()) {
                return ItemStack.field_190927_a;
            }
            isCapAccess = true;
            ItemStack out = super.extractItem(slotAbs, amount, simulate);
            isCapAccess = false;
            return out;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            isCapAccess = true;
            boolean out = super.isItemValid(slot, stack);
            isCapAccess = false;
            return out;
        }

        public int getSlotLimit(int slot) {
            return this.te.slots.func_70297_j_();
        }
    }

    public static class DrawbridgeItemUseContext
    extends BlockItemUseContext {
        public DrawbridgeItemUseContext(ItemUseContext p_i47813_1_) {
            super(p_i47813_1_);
        }

        public BlockPos func_195995_a() {
            return this.func_242401_i().func_216350_a();
        }
    }

    public static enum Angle {
        HIGH,
        NEUTRAL,
        LOW;

    }

    public static class DrawbridgeStats {
        public int extendLength;
        public float extendDelay;
        public boolean isAdvanced;

        public DrawbridgeStats() {
            this.extendLength = (Integer)MechworksConfig.COMMON_CONFIG.drawbridge.extendLength.get();
            this.extendDelay = ((Double)MechworksConfig.COMMON_CONFIG.drawbridge.delay.get()).floatValue();
            this.isAdvanced = false;
        }
    }
}

