/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.network;

import com.dannyandson.tinyredstone.blocks.ChopperBlockEntity;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.codec.TinyBlockData;
import com.dannyandson.tinyredstone.network.ModNetworkHandler;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class ValidTinyBlockCacheSync {
    ResourceLocation itemRegistryName;
    BlockPos chopperPos;

    public ValidTinyBlockCacheSync(@Nullable BlockPos chopperPos, ResourceLocation itemRegistryName) {
        this.itemRegistryName = itemRegistryName;
        this.chopperPos = chopperPos;
    }

    public ValidTinyBlockCacheSync(PacketBuffer buffer) {
        this.itemRegistryName = buffer.func_192575_l();
        try {
            this.chopperPos = buffer.func_179259_c();
        }
        catch (IndexOutOfBoundsException e) {
            this.chopperPos = null;
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.itemRegistryName);
        if (this.chopperPos != null) {
            buf.func_179255_a(this.chopperPos);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        return ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT ? this.clientHandle(ctx) : this.serverHandle(ctx);
    }

    public boolean clientHandle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ResourceLocation texture1 = new ResourceLocation(this.itemRegistryName.func_110624_b(), "block/" + this.itemRegistryName.func_110623_a());
            ResourceLocation texture2 = new ResourceLocation(this.itemRegistryName.func_110624_b(), "block/" + this.itemRegistryName.func_110623_a() + "_side");
            TextureAtlasSprite sprite1 = RenderHelper.getSprite(texture1);
            TextureAtlasSprite sprite2 = RenderHelper.getSprite(texture2);
            if (sprite1 != RenderHelper.getSprite(TextureManager.field_194008_a) || sprite2 != RenderHelper.getSprite(TextureManager.field_194008_a)) {
                ModNetworkHandler.sendToServer(new ValidTinyBlockCacheSync(this.chopperPos, this.itemRegistryName));
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }

    public boolean serverHandle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity chopperBlockEntity;
            if (!TinyBlockData.validBlockTextureCache.contains(this.itemRegistryName.toString())) {
                TinyBlockData.validBlockTextureCache.add(this.itemRegistryName.toString());
            }
            if (this.chopperPos != null && (chopperBlockEntity = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q().func_175625_s(this.chopperPos)) instanceof ChopperBlockEntity) {
                chopperBlockEntity.func_70296_d();
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

