/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.items;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCover;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;

public class PanelItemRenderer
extends ItemStackTileEntityRenderer {
    public void render(ItemStack stack, ItemCameraTransforms.TransformType p_239207_2_, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        this.func_239207_a_(stack, p_239207_2_, matrixStack, buffer, combinedLight, combinedOverlay);
    }

    public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType p_239207_2_, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        CompoundNBT blockEntityTag;
        TextureAtlasSprite sprite = RenderHelper.getSprite(PanelTileRenderer.TEXTURE);
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228639_c_());
        Integer color = DyeColor.GRAY.getColorValue();
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("BlockEntityTag") && (blockEntityTag = stack.func_77978_p().func_74775_l("BlockEntityTag")).func_74764_b("color")) {
            color = blockEntityTag.func_74762_e("color");
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.125, 0.0);
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("BlockEntityTag")) {
            CompoundNBT itemTag = stack.func_77978_p().func_74775_l("BlockEntityTag");
            if (itemTag.func_74764_b("cover")) {
                String coverClass = stack.func_77978_p().func_74775_l("BlockEntityTag").func_74779_i("cover");
                try {
                    IPanelCover cover = (IPanelCover)Class.forName(coverClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                    cover.readNBT(stack.func_77978_p().func_74775_l("BlockEntityTag").func_74775_l("coverData"));
                    matrixStack.func_227860_a_();
                    cover.render(matrixStack, buffer, combinedLight, combinedOverlay, color);
                    matrixStack.func_227865_b_();
                }
                catch (Exception exception) {
                    TinyRedstone.LOGGER.error("Exception attempting to construct IPanelCover class for item render: " + coverClass + ": " + exception.getMessage() + " " + exception.getStackTrace()[0].toString());
                }
            } else {
                boolean hasBase;
                boolean bl = hasBase = !itemTag.func_74764_b("hasBase") || itemTag.func_74767_n("hasBase");
                if (hasBase) {
                    this.renderBase(matrixStack, builder, sprite, combinedLight, color);
                }
                CompoundNBT cellsNBT = itemTag.func_74775_l("cells");
                Integer i = 0;
                while (i < (hasBase ? 448 : 512)) {
                    CompoundNBT cellNBT;
                    if (cellsNBT.func_74764_b(i.toString()) && (cellNBT = cellsNBT.func_74775_l(i.toString())).func_74764_b("data")) {
                        String className = cellNBT.func_74779_i("class");
                        try {
                            IPanelCell cell = (IPanelCell)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                            cell.readNBT(cellNBT.func_74775_l("data"));
                            Direction cellDirection = Direction.func_82600_a((int)cellNBT.func_74762_e("direction"));
                            this.renderCell(matrixStack, i, cell, cellDirection, buffer, combinedLight, combinedOverlay);
                        }
                        catch (Exception exception) {
                            TinyRedstone.LOGGER.error("Exception attempting to construct IPanelCell class for item render: " + className + ": " + exception.getMessage() + " " + exception.getStackTrace()[0].toString());
                        }
                    }
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            }
        } else {
            this.renderBase(matrixStack, builder, sprite, combinedLight, color);
        }
        matrixStack.func_227865_b_();
    }

    private void renderBase(MatrixStack matrixStack, IVertexBuilder builder, TextureAtlasSprite sprite, int combinedLight, int color) {
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(270.0f));
        matrixStack.func_227861_a_(0.0, -1.0, 0.125);
        this.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, color);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -0.125, 0.0);
        this.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        this.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        this.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        this.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -1.0, 0.0);
        this.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, color);
        matrixStack.func_227865_b_();
    }

    private void renderCell(MatrixStack matrixStack, Integer index, IPanelCell panelCell, Direction cellDirection, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        float scale = 0.125f;
        float t2X = 0.0f;
        float t2Y = -1.0f;
        float t2Z = 0.0f;
        float rotation1 = 270.0f;
        double cellSize = 0.125;
        int level = Math.round(index.floatValue() / 64.0f - 0.5f);
        int row = Math.round(index.floatValue() % 64.0f / 8.0f - 0.5f);
        int cell = index % 8;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(cellSize * (double)row, 0.125 + cellSize * (double)level, cellSize * (double)cell);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rotation1));
        if (cellDirection == Direction.WEST) {
            matrixStack.func_227861_a_(0.0, -cellSize, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        } else if (cellDirection == Direction.SOUTH) {
            matrixStack.func_227861_a_(cellSize, -cellSize, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        } else if (cellDirection == Direction.EAST) {
            matrixStack.func_227861_a_(cellSize, 0.0, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(270.0f));
        }
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227861_a_((double)t2X, (double)t2Y, (double)t2Z);
        panelCell.render(matrixStack, buffer, combinedLight, combinedOverlay, 1.0f);
        matrixStack.func_227865_b_();
    }

    private void drawRectangle(IVertexBuilder builder, MatrixStack matrixStack, float x1, float x2, float y1, float y2, TextureAtlasSprite sprite, int combinedLight, Integer color) {
        this.add(builder, matrixStack, x1, y1, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), combinedLight, color);
        this.add(builder, matrixStack, x2, y1, 0.0f, sprite.func_94212_f(), sprite.func_94206_g(), combinedLight, color);
        this.add(builder, matrixStack, x2, y2, 0.0f, sprite.func_94212_f(), sprite.func_94210_h(), combinedLight, color);
        this.add(builder, matrixStack, x1, y2, 0.0f, sprite.func_94209_e(), sprite.func_94210_h(), combinedLight, color);
    }

    private void add(IVertexBuilder renderer, MatrixStack stack, float x, float y, float z, float u, float v, int combinedLightIn, Integer color) {
        renderer.func_227888_a_(stack.func_227866_c_().func_227870_a_(), x, y, z).func_225586_a_(ColorHelper.PackedColor.func_233007_b_((int)color), ColorHelper.PackedColor.func_233008_c_((int)color), ColorHelper.PackedColor.func_233009_d_((int)color), ColorHelper.PackedColor.func_233004_a_((int)color)).func_225583_a_(u, v).func_227886_a_(combinedLightIn).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
    }
}

