/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IColorablePanelCell;
import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.setup.Registration;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class TinyBlock
implements IPanelCell,
IColorablePanelCell,
IPanelCellInfoProvider {
    public static final ResourceLocation TEXTURE_GRASS_BLOCK_TOP = new ResourceLocation("tinyredstone", "block/grass_block_top");
    public static ResourceLocation TEXTURE_TINY_BLOCK = new ResourceLocation("minecraft", "block/white_wool");
    protected int weakSignalStrength = 0;
    protected int strongSignalStrength = 0;
    protected int color = DyeColor.WHITE.getColorValue();
    protected ResourceLocation madeFrom;
    protected TextureAtlasSprite sprite_top;
    protected TextureAtlasSprite sprite_front;
    protected TextureAtlasSprite sprite_right;
    protected TextureAtlasSprite sprite_back;
    protected TextureAtlasSprite sprite_left;
    protected TextureAtlasSprite sprite_bottom;

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        if (this.sprite_top == null) {
            if (this.madeFrom != null) {
                this.sprite_top = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.TOP);
                this.sprite_front = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.FRONT);
                this.sprite_right = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.RIGHT);
                this.sprite_back = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.BACK);
                this.sprite_left = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.LEFT);
                this.sprite_bottom = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.BOTTOM);
            } else {
                this.sprite_left = this.sprite_bottom = RenderHelper.getSprite(TEXTURE_TINY_BLOCK);
                this.sprite_back = this.sprite_bottom;
                this.sprite_right = this.sprite_bottom;
                this.sprite_front = this.sprite_bottom;
                this.sprite_top = this.sprite_bottom;
            }
        }
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(-1.0, -1.0, 1.0);
        RenderHelper.drawCube(matrixStack, builder, this.sprite_top, this.sprite_front, this.sprite_right, this.sprite_back, this.sprite_left, this.sprite_bottom, combinedLight, combinedOverlay, this.color, alpha);
    }

    @Override
    public boolean onPlace(PanelCellPos cellPos, PlayerEntity player) {
        CompoundNBT itemNBT;
        CompoundNBT madeFromTag;
        ItemStack stack = ItemStack.field_190927_a;
        if (player.func_184600_cs() != null) {
            stack = player.func_184586_b(player.func_184600_cs());
        }
        if (stack == ItemStack.field_190927_a) {
            stack = player.func_184614_ca();
        }
        if (stack.func_77942_o() && (madeFromTag = (itemNBT = stack.func_77978_p()).func_74775_l("made_from")).func_74764_b("namespace")) {
            this.madeFrom = new ResourceLocation(madeFromTag.func_74779_i("namespace"), madeFromTag.func_74779_i("path"));
        }
        return IPanelCell.super.onPlace(cellPos, player);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        PanelCellNeighbor frontNeighbor = cellPos.getNeighbor(Side.FRONT);
        PanelCellNeighbor topNeighbor = cellPos.getNeighbor(Side.TOP);
        PanelCellNeighbor bottomNeighbor = cellPos.getNeighbor(Side.BOTTOM);
        int weak = 0;
        int strong = 0;
        if (frontNeighbor != null) {
            if (frontNeighbor.powerDrops()) {
                weak = frontNeighbor.getWeakRsOutput();
            } else if (!(frontNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = frontNeighbor.getStrongRsOutput();
            }
        }
        if (rightNeighbor != null) {
            if (rightNeighbor.powerDrops()) {
                weak = Math.max(weak, rightNeighbor.getWeakRsOutput());
            } else if (!(rightNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, rightNeighbor.getStrongRsOutput());
            }
        }
        if (backNeighbor != null) {
            if (backNeighbor.powerDrops()) {
                weak = Math.max(weak, backNeighbor.getWeakRsOutput());
            } else if (!(backNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, backNeighbor.getStrongRsOutput());
            }
        }
        if (leftNeighbor != null) {
            if (leftNeighbor.powerDrops()) {
                weak = Math.max(weak, leftNeighbor.getWeakRsOutput());
            } else if (!(leftNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, leftNeighbor.getStrongRsOutput());
            }
        }
        if (topNeighbor != null) {
            if (topNeighbor.powerDrops()) {
                weak = Math.max(weak, topNeighbor.getWeakRsOutput());
            } else if (!(topNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, topNeighbor.getStrongRsOutput());
            }
        }
        if (bottomNeighbor != null) {
            if (bottomNeighbor.powerDrops()) {
                weak = Math.max(weak, bottomNeighbor.getWeakRsOutput());
            } else if (!(bottomNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, bottomNeighbor.getStrongRsOutput());
            }
        }
        if ((weak = Math.max(weak, strong)) != this.weakSignalStrength || strong != this.strongSignalStrength) {
            this.weakSignalStrength = weak;
            this.strongSignalStrength = strong;
            return true;
        }
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return this.weakSignalStrength;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return this.strongSignalStrength;
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("strong", this.strongSignalStrength);
        nbt.func_74768_a("weak", this.weakSignalStrength);
        nbt.func_74768_a("color", this.color);
        if (this.madeFrom != null) {
            nbt.func_74778_a("made_from_namespace", this.madeFrom.func_110624_b());
            nbt.func_74778_a("made_from_path", this.madeFrom.func_110623_a());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        this.strongSignalStrength = compoundNBT.func_74762_e("strong");
        this.weakSignalStrength = compoundNBT.func_74762_e("weak");
        this.color = compoundNBT.func_74762_e("color");
        if (compoundNBT.func_74764_b("made_from_namespace")) {
            this.madeFrom = new ResourceLocation(compoundNBT.func_74779_i("made_from_namespace"), compoundNBT.func_74779_i("made_from_path"));
        }
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.setPowerOutput(this.weakSignalStrength);
    }

    @Override
    public CompoundNBT getItemTag() {
        if (this.madeFrom != null) {
            CompoundNBT madeFromTag = new CompoundNBT();
            madeFromTag.func_74778_a("namespace", this.madeFrom.func_110624_b());
            madeFromTag.func_74778_a("path", this.madeFrom.func_110623_a());
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_218657_a("made_from", (INBT)madeFromTag);
            return itemTag;
        }
        return null;
    }
}

