/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.TransparentBlock;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RedstoneDust
implements IPanelCell,
IPanelCellInfoProvider {
    public static ResourceLocation TEXTURE_REDSTONE_DUST_ON = new ResourceLocation("tinyredstone", "block/panel_redstone_dust_on");
    public static ResourceLocation TEXTURE_REDSTONE_DUST_OFF = new ResourceLocation("tinyredstone", "block/panel_redstone_dust_off");
    public static ResourceLocation TEXTURE_REDSTONE_DUST_SEGMENT_ON = new ResourceLocation("tinyredstone", "block/panel_redstone_segment_on");
    public static ResourceLocation TEXTURE_REDSTONE_DUST_SEGMENT_OFF = new ResourceLocation("tinyredstone", "block/panel_redstone_segment_off");
    public static ResourceLocation TEXTURE_REDSTONE_DUST = new ResourceLocation("tinyredstone", "block/panel_redstone_dust");
    public static ResourceLocation TEXTURE_REDSTONE_DUST_SEGMENT = new ResourceLocation("tinyredstone", "block/panel_redstone_segment");
    private static final float s6 = 0.375f;
    private static final float s7 = 0.4375f;
    private static final float s9 = 0.5625f;
    private static final float s10 = 0.625f;
    protected int signalStrength = 0;
    protected boolean frontEnabled = true;
    protected boolean rightEnabled = false;
    protected boolean backEnabled = true;
    protected boolean leftEnabled = false;
    protected List<Side> crawlUpSide = new ArrayList<Side>();
    private float red = 0.25f;
    private float green = 0.0f;
    private float blue = 0.0f;

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        this.red = this.signalStrength == 0 ? 0.25f : 0.3f + 0.04f * (float)this.signalStrength;
        int color = ColorHelper.PackedColor.func_233006_a_((int)255, (int)Math.round(this.red * 255.0f), (int)0, (int)0);
        TextureAtlasSprite sprite_redstone_dust = RenderHelper.getSprite(TEXTURE_REDSTONE_DUST);
        TextureAtlasSprite sprite_redstone_segment = RenderHelper.getSprite(TEXTURE_REDSTONE_DUST_SEGMENT);
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        matrixStack.func_227861_a_(0.0, 0.0, 0.01);
        RenderHelper.drawRectangle(builder, matrixStack, 0.365f, 0.635f, 0.365f, 0.635f, sprite_redstone_dust, combinedLight, color, alpha);
        if (this.rightEnabled) {
            RenderHelper.drawRectangle(builder, matrixStack, 0.625f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
            if (this.crawlUpSide.contains((Object)Side.RIGHT)) {
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, 0.0, 1.01);
                RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
                matrixStack.func_227865_b_();
            }
        }
        if (this.leftEnabled) {
            RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 0.375f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
            if (this.crawlUpSide.contains((Object)Side.LEFT)) {
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                matrixStack.func_227861_a_(-1.0, 0.0, 0.01);
                RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
                matrixStack.func_227865_b_();
            }
        }
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -1.0, 0.0);
        if (this.frontEnabled) {
            RenderHelper.drawRectangle(builder, matrixStack, 0.625f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
            if (this.crawlUpSide.contains((Object)Side.FRONT)) {
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, 0.0, 1.01);
                RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
                matrixStack.func_227865_b_();
            }
        }
        if (this.backEnabled) {
            RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 0.375f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
            if (this.crawlUpSide.contains((Object)Side.BACK)) {
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                matrixStack.func_227861_a_(-1.0, 0.0, 0.01);
                RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color, alpha);
                matrixStack.func_227865_b_();
            }
        }
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        int signal;
        PanelCellNeighbor bottomNeighbor;
        int front = 0;
        int right = 0;
        int back = 0;
        int left = 0;
        int top = 0;
        int bottom = 0;
        this.crawlUpSide.clear();
        PanelCellPos above = null;
        PanelCellNeighbor topNeighbor = cellPos.getNeighbor(Side.TOP);
        if (topNeighbor != null) {
            int n = top = topNeighbor.canConnectRedstone() ? topNeighbor.getWeakRsOutput() : topNeighbor.getStrongRsOutputForWire();
            if (topNeighbor.getNeighborIPanelCell() instanceof TransparentBlock) {
                above = cellPos.offset(Side.TOP);
            }
        } else {
            above = cellPos.offset(Side.TOP);
        }
        if ((bottomNeighbor = cellPos.getNeighbor(Side.BOTTOM)) != null) {
            bottom = bottomNeighbor.getStrongRsOutputForWire();
        }
        PanelCellPos below = cellPos.offset(Side.BOTTOM);
        if (this.frontEnabled) {
            front = this.checkSideInput(cellPos, Side.FRONT, above, below);
        }
        if (this.rightEnabled) {
            right = this.checkSideInput(cellPos, Side.RIGHT, above, below);
        }
        if (this.backEnabled) {
            back = this.checkSideInput(cellPos, Side.BACK, above, below);
        }
        if (this.leftEnabled) {
            left = this.checkSideInput(cellPos, Side.LEFT, above, below);
        }
        if ((signal = Math.max(Math.max(Math.max(Math.max(front, right), Math.max(back, left)), Math.max(top, bottom)), 0)) != this.signalStrength) {
            this.signalStrength = signal;
            return true;
        }
        return false;
    }

    protected int checkSideInput(PanelCellPos cellPos, Side side, PanelCellPos above, PanelCellPos below) {
        PanelCellNeighbor belowNeighbor;
        PanelCellNeighbor aboveNeighbor;
        PanelCellNeighbor neighbor = cellPos.getNeighbor(side);
        int input = 0;
        if (neighbor != null) {
            input = this.getNeighborOutput(neighbor);
        }
        if ((neighbor == null || !(neighbor.getNeighborIPanelCell() instanceof TransparentBlock)) && above != null && (aboveNeighbor = above.getNeighbor(side, cellPos.getCellFacing())) != null && aboveNeighbor.getNeighborIPanelCell() instanceof RedstoneDust) {
            input = Math.max(input, this.getNeighborOutput(aboveNeighbor));
        }
        if (below != null && (neighbor == null || neighbor.getNeighborIPanelCell() instanceof TransparentBlock) && (belowNeighbor = below.getNeighbor(side, cellPos.getCellFacing())) != null && belowNeighbor.getNeighborIPanelCell() instanceof RedstoneDust) {
            input = Math.max(input, this.getNeighborOutput(belowNeighbor));
            this.crawlUpSide.add(side);
        }
        return input;
    }

    protected int getNeighborOutput(PanelCellNeighbor neighbor) {
        int output = neighbor.getStrongRsOutputForWire();
        if (neighbor.powerDrops()) {
            --output;
        } else {
            int w = neighbor.getWeakRsOutput();
            if (w > output && neighbor.canConnectRedstone()) {
                output = w;
            }
        }
        return output;
    }

    protected boolean sideEnabled(Side side) {
        return side == Side.FRONT && this.frontEnabled || side == Side.RIGHT && this.rightEnabled || side == Side.BACK && this.backEnabled || side == Side.LEFT && this.leftEnabled;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        if (this.sideEnabled(outputDirection) || outputDirection == Side.BOTTOM) {
            return Math.max(this.signalStrength, 0);
        }
        return 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return this.getWeakRsOutput(outputDirection);
    }

    @Override
    public boolean powerDrops() {
        return true;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    public boolean needsSolidBase() {
        return true;
    }

    @Override
    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, PlayerEntity player) {
        if (cellPos.getPanelTile().func_145831_w().field_72995_K) {
            return false;
        }
        if (segmentClicked == PanelCellSegment.FRONT) {
            this.frontEnabled = !this.frontEnabled;
            return true;
        }
        if (segmentClicked == PanelCellSegment.RIGHT) {
            this.rightEnabled = !this.rightEnabled;
            return true;
        }
        if (segmentClicked == PanelCellSegment.LEFT) {
            this.leftEnabled = !this.leftEnabled;
            return true;
        }
        if (segmentClicked == PanelCellSegment.BACK) {
            this.backEnabled = !this.backEnabled;
            return true;
        }
        if (segmentClicked == PanelCellSegment.CENTER) {
            if (!(this.frontEnabled && this.rightEnabled && this.backEnabled && this.leftEnabled)) {
                this.frontEnabled = true;
                this.rightEnabled = true;
                this.backEnabled = true;
                this.leftEnabled = true;
            } else {
                this.frontEnabled = false;
                this.rightEnabled = false;
                this.backEnabled = false;
                this.leftEnabled = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasActivation() {
        return true;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("strength", this.signalStrength);
        nbt.func_74757_a("front", this.frontEnabled);
        nbt.func_74757_a("right", this.rightEnabled);
        nbt.func_74757_a("back", this.backEnabled);
        nbt.func_74757_a("left", this.leftEnabled);
        StringJoiner crawlUpSides = new StringJoiner(",");
        for (Side side : this.crawlUpSide) {
            crawlUpSides.add(side.name());
        }
        nbt.func_74778_a("crawlUpSides", crawlUpSides.toString());
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        this.signalStrength = compoundNBT.func_74762_e("strength");
        this.frontEnabled = compoundNBT.func_74767_n("front");
        this.rightEnabled = compoundNBT.func_74767_n("right");
        this.backEnabled = compoundNBT.func_74767_n("back");
        this.leftEnabled = compoundNBT.func_74767_n("left");
        String crawlUpSides = compoundNBT.func_74779_i("crawlUpSides");
        if (!crawlUpSides.equals("")) {
            for (String side : crawlUpSides.split(",")) {
                this.crawlUpSide.add(Side.valueOf(side));
            }
        }
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.setPowerOutput(this.signalStrength);
    }

    @Override
    public PanelCellVoxelShape getShape() {
        return new PanelCellVoxelShape(new Vector3d(0.0, 0.0, 0.0), new Vector3d(1.0, 0.05, 1.0));
    }
}

