/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class Comparator
implements IPanelCell,
IPanelCellInfoProvider {
    private Integer input1 = 0;
    private Integer input2 = 0;
    private Integer output = 0;
    private Boolean subtract = false;
    private Boolean comparatorOverride = false;
    private Integer comparatorInput = 0;
    protected int changePending = -1;
    public static ResourceLocation TEXTURE_COMPARATOR_ON = new ResourceLocation("tinyredstone", "block/panel_comparator_on");
    public static ResourceLocation TEXTURE_COMPARATOR_OFF = new ResourceLocation("tinyredstone", "block/panel_comparator_off");
    public static ResourceLocation TEXTURE_COMPARATOR_SUBTRACT_ON = new ResourceLocation("tinyredstone", "block/panel_comparator_subtract_on");
    public static ResourceLocation TEXTURE_COMPARATOR_SUBTRACT_OFF = new ResourceLocation("tinyredstone", "block/panel_comparator_subtract_off");

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        TextureAtlasSprite sprite = RenderHelper.getSprite(PanelTileRenderer.TEXTURE);
        TextureAtlasSprite sprite_repeater = RenderHelper.getSprite(TEXTURE_COMPARATOR_OFF);
        if (this.output > 0 && this.subtract.booleanValue()) {
            sprite_repeater = RenderHelper.getSprite(TEXTURE_COMPARATOR_SUBTRACT_ON);
        } else if (this.output > 0) {
            sprite_repeater = RenderHelper.getSprite(TEXTURE_COMPARATOR_ON);
        } else if (this.subtract.booleanValue()) {
            sprite_repeater = RenderHelper.getSprite(TEXTURE_COMPARATOR_SUBTRACT_OFF);
        }
        matrixStack.func_227861_a_(0.0, 0.0, 0.25);
        this.add(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite_repeater.func_94209_e(), sprite_repeater.func_94210_h(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite_repeater.func_94212_f(), sprite_repeater.func_94210_h(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 1.0f, 0.0f, sprite_repeater.func_94212_f(), sprite_repeater.func_94206_g(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 0.0f, 1.0f, 0.0f, sprite_repeater.func_94209_e(), sprite_repeater.func_94206_g(), combinedLight, combinedOverlay, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -0.25, 0.0);
        this.add(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite.func_94209_e(), sprite.func_94210_h(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite.func_94212_f(), sprite.func_94210_h(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.25f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 0.0f, 0.25f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), combinedLight, combinedOverlay, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        this.add(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite.func_94209_e(), sprite.func_94210_h(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite.func_94212_f(), sprite.func_94210_h(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.25f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 0.0f, 0.25f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), combinedLight, combinedOverlay, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        this.add(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite.func_94209_e(), sprite.func_94210_h(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite.func_94212_f(), sprite.func_94210_h(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.25f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 0.0f, 0.25f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), combinedLight, combinedOverlay, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        this.add(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite.func_94209_e(), sprite.func_94210_h(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite.func_94212_f(), sprite.func_94210_h(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 1.0f, 0.25f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g(), combinedLight, combinedOverlay, alpha);
        this.add(builder, matrixStack, 0.0f, 0.25f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), combinedLight, combinedOverlay, alpha);
    }

    private void add(IVertexBuilder renderer, MatrixStack stack, float x, float y, float z, float u, float v, int combinedLightIn, int combinedOverlayIn, float alpha) {
        renderer.func_227888_a_(stack.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(u, v).func_227886_a_(combinedLightIn).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        boolean co = backNeighbor != null && backNeighbor.hasComparatorOverride();
        int i1 = backNeighbor == null ? 0 : Math.max(backNeighbor.getStrongRsOutput(), backNeighbor.getWeakRsOutput());
        int i2 = Math.max(leftNeighbor == null ? 0 : leftNeighbor.getStrongRsOutput(), rightNeighbor == null ? 0 : rightNeighbor.getStrongRsOutput());
        if (i1 != this.input1 || i2 != this.input2 || co != this.comparatorOverride) {
            this.input1 = i1;
            this.input2 = i2;
            this.comparatorOverride = co;
            this.changePending = 1;
        }
        return false;
    }

    private boolean updateOutput() {
        Integer output1 = 0;
        Integer input = this.comparatorOverride != false ? Math.max(this.input1, this.comparatorInput) : this.input1;
        output1 = this.subtract != false ? Integer.valueOf(Math.max(0, input - this.input2)) : Integer.valueOf(input >= this.input2 ? input : 0);
        if (output1 == this.output) {
            return false;
        }
        this.output = output1;
        return true;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return this.getStrongRsOutput(outputDirection);
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        if (outputDirection == Side.FRONT && this.output > 0) {
            return this.output;
        }
        return 0;
    }

    @Override
    public boolean needsSolidBase() {
        return true;
    }

    @Override
    public boolean tick(PanelCellPos cellPos) {
        if (!cellPos.getPanelTile().func_145831_w().field_72995_K) {
            PanelCellNeighbor backNeighbor;
            int cInput;
            if (this.comparatorOverride.booleanValue() && (cInput = (backNeighbor = cellPos.getNeighbor(Side.BACK)).getComparatorOverride()) != this.comparatorInput) {
                this.comparatorInput = cInput;
                this.changePending = 1;
            }
            if (this.changePending < 0) {
                return false;
            }
            if (this.changePending > 0) {
                --this.changePending;
                return false;
            }
            --this.changePending;
            return this.updateOutput();
        }
        return false;
    }

    @Override
    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, PlayerEntity player) {
        this.subtract = this.subtract == false;
        return this.updateOutput();
    }

    @Override
    public boolean hasActivation() {
        return true;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("output", this.output.intValue());
        nbt.func_74768_a("input1", this.input1.intValue());
        nbt.func_74768_a("input2", this.input2.intValue());
        nbt.func_74768_a("changePending", this.changePending);
        nbt.func_74768_a("comparatorInput", this.comparatorInput.intValue());
        nbt.func_74757_a("subtract", this.subtract.booleanValue());
        nbt.func_74757_a("comparatorOverride", this.comparatorOverride.booleanValue());
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        this.output = compoundNBT.func_74762_e("output");
        this.input1 = compoundNBT.func_74762_e("input1");
        this.input2 = compoundNBT.func_74762_e("input2");
        this.changePending = compoundNBT.func_74762_e("changePending");
        this.comparatorInput = compoundNBT.func_74762_e("comparatorInput");
        this.subtract = compoundNBT.func_74767_n("subtract");
        this.comparatorOverride = compoundNBT.func_74767_n("comparatorOverride");
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.addText("Mode", this.subtract != false ? ComparatorMode.SUBTRACT.toString() : ComparatorMode.COMPARE.toString());
    }

    @Override
    public PanelCellVoxelShape getShape() {
        return PanelCellVoxelShape.QUARTERCELLSLAB;
    }
}

