/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.api;

import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public interface IPanelCell {
    public void render(MatrixStack var1, IRenderTypeBuffer var2, int var3, int var4, float var5);

    default public boolean onPlace(PanelCellPos cellPos, PlayerEntity player) {
        return this.neighborChanged(cellPos);
    }

    public boolean neighborChanged(PanelCellPos var1);

    public int getWeakRsOutput(Side var1);

    public int getStrongRsOutput(Side var1);

    default public boolean powerDrops() {
        return false;
    }

    default public boolean isIndependentState() {
        return false;
    }

    default public boolean isPushable() {
        return false;
    }

    default public boolean canPlaceVertical() {
        return false;
    }

    default public boolean needsSolidBase() {
        return false;
    }

    default public boolean canAttachToBaseOnSide(Side side) {
        return side == Side.BOTTOM;
    }

    default public Side getBaseSide() {
        return Side.BOTTOM;
    }

    default public void setBaseSide(Side side) {
    }

    default public int lightOutput() {
        return 0;
    }

    default public boolean tick(PanelCellPos cellPos) {
        return false;
    }

    default public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, PlayerEntity player) {
        return false;
    }

    default public boolean hasActivation(PlayerEntity player) {
        return this.hasActivation();
    }

    default public boolean hasActivation() {
        return false;
    }

    public CompoundNBT writeNBT();

    public void readNBT(CompoundNBT var1);

    default public PanelCellVoxelShape getShape() {
        return PanelCellVoxelShape.FULLCELL;
    }

    default public PanelCellVoxelShape[] getShapes(PanelCellPos cellPos) {
        return new PanelCellVoxelShape[]{this.getShape()};
    }

    default public void onRemove(PanelCellPos cellPos) {
    }

    default public CompoundNBT getItemTag() {
        return null;
    }
}

