/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCover;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.compat.CompatHandler;
import com.dannyandson.tinyredstone.setup.ClientSetup;
import com.dannyandson.tinyredstone.setup.ModSetup;
import com.dannyandson.tinyredstone.setup.Registration;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(value="tinyredstone")
public class TinyRedstone {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "tinyredstone";

    public TinyRedstone() {
        Registration.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModSetup::init);
        if (FMLEnvironment.dist.isClient()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientSetup::init);
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_CONFIG);
        CompatHandler.register();
    }

    public static void registerPanelCell(Class<? extends IPanelCell> iPanelCellClass, Item correspondingItem) {
        PanelBlock.registerPanelCell(iPanelCellClass, correspondingItem);
    }

    public static void registerPanelCover(Class<? extends IPanelCover> iPanelCoverClass, Item correspondingItem) {
        PanelBlock.registerPanelCover(iPanelCoverClass, correspondingItem);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LOGGER.info("Binding Renderer for Redstone Panel tile entity.", (Object)Registration.REDSTONE_PANEL_BLOCK.get());
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Registration.REDSTONE_PANEL_TILE.get()), PanelTileRenderer::new);
    }
}

