/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.AbstractPanelCellItem;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.RotationLock;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tinyredstone", value={Dist.CLIENT})
public class ClientBinding {
    public static KeyBinding rotationLock;

    public static void registerKeyBindings() {
        rotationLock = new KeyBinding("key.tinyredstone.rotation_lock", 342, "TinyRedstone");
        ClientRegistry.registerKeyBinding((KeyBinding)rotationLock);
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent keyInputEvent) {
        if (keyInputEvent.isCanceled()) {
            return;
        }
        int numberKey = keyInputEvent.getKey() - 48;
        if (numberKey > 0 && numberKey <= 9) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            if (player.field_71071_by.field_70461_c + 1 == numberKey) {
                return;
            }
            ItemStack mainHand = player.func_184614_ca();
            Item mainHandItem = mainHand.func_77973_b();
            if (mainHandItem instanceof AbstractPanelCellItem) {
                RotationLock.removeLock();
            }
        }
    }

    @SubscribeEvent
    public static void wheelEvent(InputEvent.MouseScrollEvent mouseScrollEvent) {
        if (mouseScrollEvent.isCanceled()) {
            return;
        }
        double scrollDelta = mouseScrollEvent.getScrollDelta();
        if (scrollDelta == 0.0) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ItemStack mainHand = player.func_184614_ca();
        Item mainHandItem = mainHand.func_77973_b();
        if (mainHandItem instanceof AbstractPanelCellItem) {
            if (rotationLock.func_151470_d()) {
                Vector3d lookVector = Minecraft.func_71410_x().field_71476_x.func_216347_e();
                BlockPos blockPos = new BlockPos(lookVector);
                TileEntity te = world.func_175625_s(blockPos);
                if (te instanceof PanelTile) {
                    try {
                        IPanelCell panelCell = (IPanelCell)PanelBlock.getPanelCellClassFromItem(mainHandItem).getConstructors()[0].newInstance(new Object[0]);
                        RotationLock.lockRotation((PanelTile)te, (PlayerEntity)player, panelCell.canPlaceVertical(), scrollDelta < 0.0);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        TinyRedstone.LOGGER.error("Exception thrown when attempting to lock rotation: " + e.getMessage());
                    }
                } else {
                    try {
                        IPanelCell panelCell = (IPanelCell)PanelBlock.getPanelCellClassFromItem(mainHandItem).getConstructors()[0].newInstance(new Object[0]);
                        RotationLock.lockRotation(panelCell.canPlaceVertical(), scrollDelta < 0.0);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        TinyRedstone.LOGGER.error("Exception thrown when attempting to lock rotation: " + e.getMessage());
                    }
                }
                mouseScrollEvent.setCanceled(true);
            } else {
                RotationLock.removeLock();
            }
        }
    }
}

