/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.gui;

import com.dannyandson.tinyredstone.blocks.ChopperBlockEntity;
import com.dannyandson.tinyredstone.network.ModNetworkHandler;
import com.dannyandson.tinyredstone.network.PushChopperOutputType;
import com.dannyandson.tinyredstone.network.ValidTinyBlockCacheSync;
import com.dannyandson.tinyredstone.setup.Registration;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class ChopperMenu
extends Container {
    public static List<Material> solidMaterials = Arrays.asList(Material.field_151575_d, Material.field_151576_e, Material.field_151573_f, Material.field_151598_x, Material.field_151571_B, Material.field_151595_p, Material.field_151578_c, Material.field_151577_b, Material.field_151596_z, Material.field_151580_n, Material.field_237214_y_, Material.field_151583_m);
    public static List<Material> transparentMaterials = Arrays.asList(Material.field_151592_s, Material.field_151588_w);
    private final IInventory container;
    private final CraftResultInventory resultContainer;
    private Slot inputSlot;
    private Slot outputSlot;
    private String itemType = "Tiny Block";

    public static ChopperMenu createChopperMenu(int containerId, PlayerInventory playerInventory) {
        return ChopperMenu.createChopperMenu(containerId, playerInventory, (IInventory)new Inventory(1));
    }

    public static ChopperMenu createChopperMenu(int containerId, PlayerInventory playerInventory, IInventory inventory) {
        return new ChopperMenu(containerId, playerInventory, inventory);
    }

    protected ChopperMenu(int containerId, PlayerInventory playerInventory, IInventory container) {
        super((ContainerType)Registration.CUTTER_MENU_TYPE.get(), containerId);
        ChopperMenu.func_216962_a((IInventory)container, (int)1);
        this.container = container;
        if (container instanceof ChopperBlockEntity) {
            ChopperBlockEntity chopperBlockEntity = (ChopperBlockEntity)container;
            chopperBlockEntity.setCutterMenu(this);
            chopperBlockEntity.setItemType(this.itemType);
            this.resultContainer = chopperBlockEntity.getResultContainer();
        } else {
            this.resultContainer = new CraftResultInventory();
        }
        container.func_174889_b(playerInventory.field_70458_d);
        int leftCol = 12;
        int ySize = 184;
        this.inputSlot = this.func_75146_a(new Slot(container, 0, 30, 44));
        this.outputSlot = this.func_75146_a(new Slot((IInventory)this.resultContainer, 1, 138, 44){

            public boolean func_75214_a(ItemStack p_40362_) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity player, ItemStack itemStack) {
                itemStack.func_77980_a(player.field_70170_p, player, itemStack.func_190916_E());
                ChopperMenu.this.inputSlot.func_75209_a(1);
                return super.func_190901_a(player, itemStack);
            }
        });
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.func_75146_a(new Slot((IInventory)playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, ySize - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)playerInventory, hotbarSlot, leftCol + hotbarSlot * 18, ySize - 24));
        }
        this.setupResultSlot();
    }

    void setupResultSlot() {
        if (this.inputSlot != null) {
            ItemStack inputStack = this.inputSlot.func_75211_c();
            ItemStack outputStack = ItemStack.field_190927_a;
            Item item = inputStack.func_77973_b();
            if (inputStack.func_77973_b() instanceof BlockItem) {
                ChopperBlockEntity chopperBlockEntity;
                boolean isFullBlock;
                Block inputBlock = ((BlockItem)item).func_179223_d();
                BlockState inputBlockState = inputBlock.func_176223_P();
                Material material = inputBlock.func_176223_P().func_185904_a();
                if (this.container instanceof ChopperBlockEntity && (isFullBlock = inputBlockState.func_235785_r_((IBlockReader)(chopperBlockEntity = (ChopperBlockEntity)this.container).func_145831_w(), chopperBlockEntity.func_174877_v())) && !inputBlockState.func_185897_m() && !inputBlockState.hasTileEntity()) {
                    ResourceLocation inputRegistryName = inputBlock.getRegistryName();
                    if (!Registration.TINY_BLOCK_OVERRIDES.hasUsableTexture(inputRegistryName)) {
                        if (!chopperBlockEntity.func_145831_w().field_72995_K) {
                            ModNetworkHandler.sendToNearestClient(new ValidTinyBlockCacheSync(chopperBlockEntity.func_174877_v(), inputRegistryName), chopperBlockEntity.func_145831_w(), chopperBlockEntity.func_174877_v());
                        }
                    } else if (inputBlock.getRegistryName() != null) {
                        CompoundNBT madeFromTag = new CompoundNBT();
                        madeFromTag.func_74778_a("namespace", inputBlock.getRegistryName().func_110624_b());
                        madeFromTag.func_74778_a("path", inputBlock.getRegistryName().func_110623_a());
                        if (this.getItemType().equals("Dark Cover")) {
                            outputStack = ((Item)Registration.PANEL_COVER_DARK.get()).func_190903_i();
                            outputStack.func_190920_e(2);
                            outputStack.func_77983_a("made_from", (INBT)madeFromTag);
                        } else if (this.getItemType().equals("Light Cover")) {
                            outputStack = ((Item)Registration.PANEL_COVER_LIGHT.get()).func_190903_i();
                            outputStack.func_190920_e(2);
                            outputStack.func_77983_a("made_from", (INBT)madeFromTag);
                        } else if (solidMaterials.contains(material)) {
                            outputStack = ((Item)Registration.TINY_SOLID_BLOCK.get()).func_190903_i();
                            outputStack.func_190920_e(8);
                            if (!inputBlock.getRegistryName().toString().equals("minecraft:white_wool")) {
                                outputStack.func_77983_a("made_from", (INBT)madeFromTag);
                            }
                        } else if (transparentMaterials.contains(material)) {
                            outputStack = ((Item)Registration.TINY_TRANSPARENT_BLOCK.get()).func_190903_i();
                            outputStack.func_190920_e(8);
                            if (!inputBlock.getRegistryName().toString().equals("minecraft:glass")) {
                                outputStack.func_77983_a("made_from", (INBT)madeFromTag);
                            }
                        }
                    }
                }
            }
            this.outputSlot.func_75215_d(outputStack);
            this.func_75142_b();
        }
    }

    public void func_75130_a(IInventory container) {
        this.setupResultSlot();
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 2) {
                if (!this.func_75135_a(itemstack1, 2, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
                if (index == 1) {
                    this.outputSlot.func_190901_a(player, itemstack);
                }
            } else if (!this.func_75135_a(itemstack1, 0, 1, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            this.setupResultSlot();
        }
        return itemstack;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.container.func_70300_a(player);
    }

    public String getItemType() {
        if (this.container instanceof ChopperBlockEntity) {
            return ((ChopperBlockEntity)this.container).getItemType();
        }
        return this.itemType;
    }

    public void toggleItemType(BlockPos pos) {
        if (this.itemType == "Tiny Block") {
            this.itemType = "Dark Cover";
        } else if (this.itemType == "Dark Cover") {
            this.itemType = "Light Cover";
        } else if (this.itemType == "Light Cover") {
            this.itemType = "Tiny Block";
        }
        ModNetworkHandler.sendToServer(new PushChopperOutputType(this.itemType, pos));
    }
}

