/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.codec;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.codec.TinyBlockData;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class CodecTinyBlockOverrides
extends JsonReloadListener {
    private static final Gson STANDARD_GSON = new Gson();
    private final Codec<TinyBlockData> codec;
    protected Map<ResourceLocation, TinyBlockData> data = new HashMap<ResourceLocation, TinyBlockData>();
    private String folderName;

    public CodecTinyBlockOverrides(String folderName, Codec<TinyBlockData> codec) {
        this(folderName, codec, STANDARD_GSON);
    }

    public CodecTinyBlockOverrides(String folderName, Codec<TinyBlockData> codec, Gson gson) {
        super(gson, folderName);
        this.folderName = folderName;
        this.codec = codec;
    }

    public TextureAtlasSprite getSprite(ResourceLocation itemResourceId, Side side) {
        for (Map.Entry<ResourceLocation, TinyBlockData> entry : this.data.entrySet()) {
            ResourceLocation texture = entry.getValue().getTexture(itemResourceId, side);
            if (texture == null) continue;
            return RenderHelper.getSprite(texture);
        }
        TextureAtlasSprite missingTextureSprite = RenderHelper.getSprite(TextureManager.field_194008_a);
        TextureAtlasSprite sprite = null;
        if (side == Side.FRONT) {
            sprite = RenderHelper.getSprite(TinyBlockData.textureResourceLocationFromResourceId(itemResourceId.toString() + "_front"));
            if (!sprite.equals(missingTextureSprite)) {
                return sprite;
            }
            sprite = RenderHelper.getSprite(TinyBlockData.textureResourceLocationFromResourceId(itemResourceId.toString() + "_side"));
            if (!sprite.equals(missingTextureSprite)) {
                return sprite;
            }
        } else if (side == Side.TOP) {
            sprite = RenderHelper.getSprite(TinyBlockData.textureResourceLocationFromResourceId(itemResourceId.toString() + "_top"));
            if (!sprite.equals(missingTextureSprite)) {
                return sprite;
            }
        } else if (side == Side.BOTTOM) {
            sprite = RenderHelper.getSprite(TinyBlockData.textureResourceLocationFromResourceId(itemResourceId.toString() + "_bottom"));
            if (!sprite.equals(missingTextureSprite)) {
                return sprite;
            }
            sprite = RenderHelper.getSprite(TinyBlockData.textureResourceLocationFromResourceId(itemResourceId.toString() + "_top"));
            if (!sprite.equals(missingTextureSprite)) {
                return sprite;
            }
        } else if (side == Side.LEFT) {
            sprite = RenderHelper.getSprite(TinyBlockData.textureResourceLocationFromResourceId(itemResourceId.toString() + "_left"));
            if (!sprite.equals(missingTextureSprite)) {
                return sprite;
            }
            sprite = RenderHelper.getSprite(TinyBlockData.textureResourceLocationFromResourceId(itemResourceId.toString() + "_side"));
            if (!sprite.equals(missingTextureSprite)) {
                return sprite;
            }
        } else if (side == Side.RIGHT) {
            sprite = RenderHelper.getSprite(TinyBlockData.textureResourceLocationFromResourceId(itemResourceId.toString() + "_right"));
            if (!sprite.equals(missingTextureSprite)) {
                return sprite;
            }
            sprite = RenderHelper.getSprite(TinyBlockData.textureResourceLocationFromResourceId(itemResourceId.toString() + "_side"));
            if (!sprite.equals(missingTextureSprite)) {
                return sprite;
            }
        } else if (side == Side.BACK) {
            sprite = RenderHelper.getSprite(TinyBlockData.textureResourceLocationFromResourceId(itemResourceId.toString() + "_back"));
            if (!sprite.equals(missingTextureSprite)) {
                return sprite;
            }
            sprite = RenderHelper.getSprite(TinyBlockData.textureResourceLocationFromResourceId(itemResourceId.toString() + "_side"));
            if (!sprite.equals(missingTextureSprite)) {
                return sprite;
            }
        }
        return RenderHelper.getSprite(TinyBlockData.textureResourceLocationFromResourceId(itemResourceId.toString()));
    }

    public boolean hasUsableTexture(ResourceLocation itemResourceId) {
        for (Map.Entry<ResourceLocation, TinyBlockData> entry : this.data.entrySet()) {
            String status = entry.getValue().getType(itemResourceId);
            if (status != null && status.equals("disabled")) {
                return false;
            }
            ResourceLocation texture = entry.getValue().getTexture(itemResourceId);
            if (texture == null) continue;
            return true;
        }
        return TinyBlockData.validBlockTextureCache.contains(itemResourceId.toString());
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, IResourceManager resourceManager, IProfiler profiler) {
        TinyRedstone.LOGGER.info("Beginning loading of data for data loader: {}", (Object)this.folderName);
        this.data = this.mapValues(jsons);
        TinyBlockData.validBlockTextureCache.clear();
        TinyRedstone.LOGGER.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)this.data.size());
    }

    private Map<ResourceLocation, TinyBlockData> mapValues(Map<ResourceLocation, JsonElement> inputs) {
        HashMap<ResourceLocation, TinyBlockData> newMap = new HashMap<ResourceLocation, TinyBlockData>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : inputs.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> {
                TinyBlockData cfr_ignored_0 = (TinyBlockData)newMap.put(key, (TinyBlockData)result.getFirst());
            }).ifRight(partial -> TinyRedstone.LOGGER.error("Failed to parse data json for {} due to: {}", (Object)key.toString(), (Object)partial.message()));
        }
        return newMap;
    }
}

