/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.RedstoneDust;
import com.dannyandson.tinyredstone.blocks.panelcells.TransparentBlock;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.math.vector.Vector3f;

public class RedstoneBridge
extends RedstoneDust {
    private int signalStrength2 = 0;
    private static final float s6 = 0.375f;
    private static final float s7 = 0.4375f;
    private static final float s9 = 0.5625f;
    private static final float s10 = 0.625f;

    public RedstoneBridge() {
        this.leftEnabled = true;
        this.rightEnabled = true;
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        float red1 = this.signalStrength == 0 ? 0.25f : 0.3f + 0.04f * (float)this.signalStrength;
        float red2 = this.signalStrength2 == 0 ? 0.25f : 0.3f + 0.04f * (float)this.signalStrength2;
        int color1 = ColorHelper.PackedColor.func_233006_a_((int)255, (int)Math.round(red1 * 255.0f), (int)0, (int)0);
        int color2 = ColorHelper.PackedColor.func_233006_a_((int)255, (int)Math.round(red2 * 255.0f), (int)0, (int)0);
        TextureAtlasSprite sprite_redstone_dust = RenderHelper.getSprite(TEXTURE_REDSTONE_DUST);
        TextureAtlasSprite sprite_redstone_segment = RenderHelper.getSprite(TEXTURE_REDSTONE_DUST_SEGMENT);
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        matrixStack.func_227861_a_(0.0, 0.0, 0.05);
        RenderHelper.drawRectangle(builder, matrixStack, 0.325f, 0.675f, 0.325f, 0.675f, sprite_redstone_dust, combinedLight, -7829368, alpha);
        matrixStack.func_227861_a_(0.0, 0.0, -0.04);
        if (this.rightEnabled) {
            RenderHelper.drawRectangle(builder, matrixStack, 0.625f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color1, alpha);
            if (this.crawlUpSide.contains((Object)Side.RIGHT)) {
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, 0.0, 1.01);
                RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color1, alpha);
                matrixStack.func_227865_b_();
            }
        }
        if (this.leftEnabled) {
            RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 0.375f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color1, alpha);
            if (this.crawlUpSide.contains((Object)Side.LEFT)) {
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                matrixStack.func_227861_a_(-1.0, 0.0, 0.01);
                RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color1, alpha);
                matrixStack.func_227865_b_();
            }
        }
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -1.0, 0.0);
        if (this.frontEnabled) {
            RenderHelper.drawRectangle(builder, matrixStack, 0.625f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color2, alpha);
            if (this.crawlUpSide.contains((Object)Side.FRONT)) {
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, 0.0, 1.01);
                RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color2, alpha);
                matrixStack.func_227865_b_();
            }
        }
        if (this.backEnabled) {
            RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 0.375f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color2, alpha);
            if (this.crawlUpSide.contains((Object)Side.BACK)) {
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                matrixStack.func_227861_a_(-1.0, 0.0, 0.01);
                RenderHelper.drawRectangle(builder, matrixStack, -0.01f, 1.01f, 0.4375f, 0.5625f, sprite_redstone_segment, combinedLight, color2, alpha);
                matrixStack.func_227865_b_();
            }
        }
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        int front = 0;
        int right = 0;
        int back = 0;
        int left = 0;
        this.crawlUpSide.clear();
        PanelCellPos above = null;
        PanelCellNeighbor topNeighbor = cellPos.getNeighbor(Side.TOP);
        if (topNeighbor != null) {
            if (topNeighbor.getNeighborIPanelCell() instanceof TransparentBlock) {
                above = cellPos.offset(Side.TOP);
            }
        } else {
            above = cellPos.offset(Side.TOP);
        }
        PanelCellPos below = cellPos.offset(Side.BOTTOM);
        if (this.frontEnabled) {
            front = this.checkSideInput(cellPos, Side.FRONT, above, below);
        }
        if (this.rightEnabled) {
            right = this.checkSideInput(cellPos, Side.RIGHT, above, below);
        }
        if (this.backEnabled) {
            back = this.checkSideInput(cellPos, Side.BACK, above, below);
        }
        if (this.leftEnabled) {
            left = this.checkSideInput(cellPos, Side.LEFT, above, below);
        }
        boolean changed = false;
        int signal1 = Math.max(Math.max(left, right), 0);
        int signal2 = Math.max(Math.max(front, back), 0);
        if (signal1 != this.signalStrength) {
            this.signalStrength = signal1;
            changed = true;
        }
        if (signal2 != this.signalStrength2) {
            this.signalStrength2 = signal2;
            changed = true;
        }
        return changed;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        if (this.sideEnabled(outputDirection)) {
            if (outputDirection == Side.FRONT || outputDirection == Side.BACK) {
                return Math.max(this.signalStrength2, 0);
            }
            if (outputDirection == Side.LEFT || outputDirection == Side.RIGHT) {
                return Math.max(this.signalStrength, 0);
            }
        }
        return 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return this.getWeakRsOutput(outputDirection);
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = super.writeNBT();
        nbt.func_74768_a("strength2", this.signalStrength2);
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        super.readNBT(compoundNBT);
        this.signalStrength2 = compoundNBT.func_74762_e("strength2");
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
    }
}

