/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.network.ModNetworkHandler;
import com.dannyandson.tinyredstone.network.RotationLockRemoveSync;
import com.dannyandson.tinyredstone.network.RotationLockSync;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RotationLock {
    private static final HashMap<UUID, Side> playerRotationLock = new HashMap();
    @OnlyIn(value=Dist.CLIENT)
    private static Side rotationLock;

    @OnlyIn(value=Dist.CLIENT)
    public static void removeLock() {
        RotationLock.removeLock(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void removeLock(boolean sendToServer) {
        if (rotationLock != null) {
            rotationLock = null;
            if (sendToServer) {
                ModNetworkHandler.sendToServer(new RotationLockRemoveSync());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void lockRotation(Side side, boolean allowVertical, boolean invert) {
        RotationLock.lockRotation(side, allowVertical, invert, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void lockRotation(Side side, boolean allowVertical, boolean invert, boolean sendToServer) {
        switch (side) {
            case BACK: {
                side = invert ? Side.RIGHT : (allowVertical ? Side.BOTTOM : Side.LEFT);
                break;
            }
            case LEFT: {
                side = invert ? (allowVertical ? Side.TOP : Side.BACK) : Side.FRONT;
                break;
            }
            case FRONT: {
                side = invert ? Side.LEFT : Side.RIGHT;
                break;
            }
            case RIGHT: {
                side = invert ? Side.FRONT : Side.BACK;
                break;
            }
            case BOTTOM: {
                side = invert ? Side.BACK : Side.TOP;
                break;
            }
            case TOP: {
                Side side2 = side = invert ? Side.BOTTOM : Side.LEFT;
            }
        }
        if (side != rotationLock) {
            rotationLock = side;
            if (sendToServer) {
                ModNetworkHandler.sendToServer(new RotationLockSync(side));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void lockRotation(boolean allowVertical, boolean invert) {
        RotationLock.lockRotation(allowVertical, invert, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void lockRotation(PanelTile panelTile, PlayerEntity playerEntity, boolean allowVertical, boolean invert) {
        RotationLock.lockRotation(panelTile, playerEntity, allowVertical, invert, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void lockRotation(boolean allowVertical, boolean invert, boolean sendToServer) {
        RotationLock.lockRotation(rotationLock == null ? Side.FRONT : rotationLock, allowVertical, invert, sendToServer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void lockRotation(PanelTile panelTile, PlayerEntity playerEntity, boolean allowVertical, boolean invert, boolean sendToServer) {
        RotationLock.lockRotation(rotationLock == null ? panelTile.getSideFromDirection(panelTile.getPlayerDirectionFacing(playerEntity, allowVertical)) : rotationLock, allowVertical, invert, sendToServer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Side getRotationLock() {
        return rotationLock;
    }

    public static void removeServerLock(PlayerEntity player) {
        playerRotationLock.remove(player.func_110124_au());
    }

    public static void lockServerRotation(PlayerEntity playerEntity, Side side) {
        playerRotationLock.put(playerEntity.func_110124_au(), side);
    }

    public static Side getServerRotationLock(PlayerEntity playerEntity) {
        return playerRotationLock.get(playerEntity.func_110124_au());
    }
}

