/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.client.renderer;

import com.haoict.tiab.common.entities.EntityTimeAccelerator;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntityTimeAcceleratorRenderer
extends EntityRenderer<EntityTimeAccelerator> {
    public EntityTimeAcceleratorRenderer(EntityRendererManager erm) {
        super(erm);
    }

    private static void drawLine(Matrix4f matrixPos, IVertexBuilder vertexBuffer, float x1, float y1, float z1, float x2, float y2, float z2, Color colour) {
        vertexBuffer.func_227888_a_(matrixPos, x1, y1, z1).func_225586_a_(colour.getRed(), colour.getGreen(), colour.getBlue(), 255).func_181675_d();
        vertexBuffer.func_227888_a_(matrixPos, x2, y2, z2).func_225586_a_(colour.getRed(), colour.getGreen(), colour.getBlue(), 255).func_181675_d();
    }

    private void drawCrossHair(MatrixStack matrixStack, IRenderTypeBuffer renderBuffers) {
        matrixStack.func_227860_a_();
        Matrix4f matrixPos = matrixStack.func_227866_c_().func_227870_a_();
        IVertexBuilder vertexBuilderLines = renderBuffers.getBuffer((RenderType)RenderType.field_228614_Q_);
        float cx = 0.0f;
        float cy = 0.0f;
        float cz = 0.0f;
        float CROSSHAIR_RADIUS = 3.0f;
        EntityTimeAcceleratorRenderer.drawLine(matrixPos, vertexBuilderLines, cx - 3.0f, cy, cz, cx + 3.0f, cy, cz, Color.RED);
        EntityTimeAcceleratorRenderer.drawLine(matrixPos, vertexBuilderLines, cx, cy - 3.0f, cz, cx, cy + 3.0f, cz, Color.RED);
        EntityTimeAcceleratorRenderer.drawLine(matrixPos, vertexBuilderLines, cx, cy, cz - 3.0f, cx, cy, cz + 3.0f, Color.RED);
        matrixStack.func_227865_b_();
    }

    private void drawText(MatrixStack matrixStack, String text, Vector3f translateVector, Quaternion rotate, int color) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)translateVector.func_195899_a(), (double)translateVector.func_195900_b(), (double)translateVector.func_195902_c());
        matrixStack.func_227862_a_(0.02f, -0.02f, 0.02f);
        matrixStack.func_227863_a_(rotate);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_238421_b_(matrixStack, text, 0.0f, 0.0f, color);
        matrixStack.func_227865_b_();
    }

    public void render(EntityTimeAccelerator entity, float entitdisableLightmapyYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderBuffers, int packedLightIn) {
        String timeRate = "x" + 2 * entity.getTimeRate();
        float paddingLeftRight = 2 * entity.getTimeRate() < 10 ? 0.11f : 0.19f;
        this.drawText(matrixStack, timeRate, new Vector3f(-paddingLeftRight, 0.064f, 0.51f), Vector3f.field_229181_d_.func_229187_a_(0.0f), TextFormatting.WHITE.func_211163_e());
        this.drawText(matrixStack, timeRate, new Vector3f(paddingLeftRight, 0.064f, -0.51f), Vector3f.field_229181_d_.func_229187_a_(180.0f), TextFormatting.WHITE.func_211163_e());
        this.drawText(matrixStack, timeRate, new Vector3f(0.51f, 0.064f, paddingLeftRight), Vector3f.field_229181_d_.func_229187_a_(90.0f), TextFormatting.WHITE.func_211163_e());
        this.drawText(matrixStack, timeRate, new Vector3f(-0.51f, 0.064f, -paddingLeftRight), Vector3f.field_229181_d_.func_229187_a_(-90.0f), TextFormatting.WHITE.func_211163_e());
        this.drawText(matrixStack, timeRate, new Vector3f(-paddingLeftRight, 0.51f, -0.064f), Vector3f.field_229179_b_.func_229187_a_(90.0f), TextFormatting.WHITE.func_211163_e());
        this.drawText(matrixStack, timeRate, new Vector3f(-paddingLeftRight, -0.51f, 0.064f), Vector3f.field_229179_b_.func_229187_a_(-90.0f), TextFormatting.WHITE.func_211163_e());
    }

    public ResourceLocation getEntityTexture(EntityTimeAccelerator entity) {
        return null;
    }
}

