/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion.entity;

import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.entity.AbstractMinecartEntityCoFH;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import cofh.thermal.locomotion.init.TLocReferences;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EnergyMinecartEntity
extends AbstractMinecartEntityCoFH {
    public static final int BASE_CAPACITY = 8000000;
    public static final int BASE_XFER = 8000;
    protected EnergyStorageCoFH energyStorage = new EnergyStorageCoFH(8000000, 8000);
    protected LazyOptional<?> energyCap = LazyOptional.empty();

    public EnergyMinecartEntity(EntityType<? extends EnergyMinecartEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public EnergyMinecartEntity(World worldIn, double posX, double posY, double posZ) {
        super(TLocReferences.ENERGY_CART_ENTITY, worldIn, posX, posY, posZ);
    }

    public EnergyMinecartEntity onPlaced(ItemStack stack) {
        super.onPlaced(stack);
        Map enchantMap = EnchantmentHelper.func_226652_a_((ListNBT)this.enchantments);
        float holdingMod = this.getHoldingMod(enchantMap);
        this.energyStorage.applyModifiers(holdingMod, 1.0f);
        if (stack.func_77978_p() != null) {
            this.energyStorage.read(stack.func_77978_p());
        }
        return this;
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        this.energyStorage.writeWithParams(stack.func_77978_p());
        return super.createItemStackTag(stack);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        Map enchantMap = EnchantmentHelper.func_226652_a_((ListNBT)this.enchantments);
        float holdingMod = this.getHoldingMod(enchantMap);
        this.energyStorage.applyModifiers(holdingMod, 1.0f);
        this.energyStorage.read(compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.energyStorage.write(compound);
    }

    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)TLocReferences.ENERGY_CART_ITEM);
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.CHEST;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ThermalEnergyHelper.getBaseEnergySystem()) {
            if (!this.energyCap.isPresent() && this.energyStorage.getCapacity() > 0) {
                this.energyCap = LazyOptional.of(() -> this.energyStorage);
            }
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.energyCap.invalidate();
    }
}

