/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.util.ProxyUtils;
import cofh.core.util.filter.EmptyFilter;
import cofh.core.util.filter.FilterRegistry;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.item.IColorableItem;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.Utils;
import cofh.lib.util.filter.IFilter;
import cofh.lib.util.filter.IFilterableItem;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.FilterHelper;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.inventory.container.storage.SatchelContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.item.InventoryContainerItemAugmentable;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class SatchelItem
extends InventoryContainerItemAugmentable
implements IColorableItem,
IDyeableArmorItem,
IFilterableItem,
IMultiModeItem,
INamedContainerProvider {
    protected static final Set<Item> BANNED_ITEMS = new ObjectOpenHashSet();
    protected static final WeakHashMap<ItemStack, IFilter> FILTERS = new WeakHashMap(128);

    public static void setBannedItems(Collection<String> itemLocs) {
        BANNED_ITEMS.clear();
        for (String loc : itemLocs) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(loc));
            if (item == null) continue;
            BANNED_ITEMS.add(item);
        }
    }

    public SatchelItem(Item.Properties builder, int slots) {
        super(builder, slots);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity) -> this.func_200883_f_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalConfig.storageAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator("Upgrade", "Filter");
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.thermal.satchel.use").func_240699_a_(TextFormatting.GRAY));
        if (FilterHelper.hasFilter((ItemStack)stack)) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.thermal.satchel.use.sneak").func_240699_a_(TextFormatting.DARK_GRAY));
        }
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)("info.thermal.satchel.mode." + this.getMode(stack))).func_240699_a_(TextFormatting.ITALIC));
        this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return this.useDelegate(stack, playerIn, handIn) ? ActionResult.func_226248_a_((Object)stack) : ActionResult.func_226250_c_((Object)stack);
    }

    public static boolean onItemPickup(EntityItemPickupEvent event, ItemStack container) {
        SatchelItem satchelItem = (SatchelItem)container.func_77973_b();
        if (satchelItem.getMode(container) <= 0 || !satchelItem.canPlayerAccess(container, event.getPlayer())) {
            return false;
        }
        ItemEntity eventItem = event.getItem();
        int count = eventItem.func_92059_d().func_190916_E();
        if (satchelItem.getFilter(container).valid(eventItem.func_92059_d())) {
            SimpleItemInv containerInv = satchelItem.getContainerInventory(container);
            eventItem.func_92058_a(InventoryHelper.insertStackIntoInventory((IItemHandler)containerInv, (ItemStack)eventItem.func_92059_d(), (boolean)false));
            if (eventItem.func_92059_d().func_190916_E() != count) {
                container.func_190915_d(5);
                PlayerEntity player = event.getPlayer();
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                containerInv.write(satchelItem.getOrCreateInvTag(container));
                satchelItem.onContainerInventoryChanged(container);
            }
        }
        return eventItem.func_92059_d().func_190916_E() != count;
    }

    protected boolean useDelegate(ItemStack stack, PlayerEntity player, Hand hand) {
        if (Utils.isFakePlayer((Entity)player) || hand == Hand.OFF_HAND) {
            return false;
        }
        if (player instanceof ServerPlayerEntity) {
            if (!this.canPlayerAccess(stack, player)) {
                ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.cofh.secure_warning", new Object[]{SecurityHelper.getOwnerName((ItemStack)stack)}));
                return false;
            }
            if (SecurityHelper.attemptClaimItem((ItemStack)stack, (PlayerEntity)player)) {
                ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.cofh.secure_item"));
                return false;
            }
            if (player.func_226563_dT_()) {
                if (FilterHelper.hasFilter((ItemStack)stack)) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.getFilter(stack));
                    return true;
                }
                return false;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
        }
        return true;
    }

    protected SimpleItemInv readInventoryFromNBT(ItemStack container) {
        CompoundNBT containerTag = this.getOrCreateInvTag(container);
        int numSlots = this.getContainerSlots(container);
        ArrayList<ItemStorageCoFH> invSlots = new ArrayList<ItemStorageCoFH>(numSlots);
        for (int i = 0; i < numSlots; ++i) {
            invSlots.add(new ItemStorageCoFH());
        }
        SimpleItemInv inventory = new SimpleItemInv(invSlots){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot < 0 || slot >= this.getSlots()) {
                    return false;
                }
                return !BANNED_ITEMS.contains(stack.func_77973_b());
            }
        };
        inventory.read(containerTag);
        return inventory;
    }

    @Override
    protected void setAttributesFromAugment(ItemStack container, CompoundNBT augmentData) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentString((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"FilterType");
        super.setAttributesFromAugment(container, augmentData);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("item.thermal.satchel");
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new SatchelContainer(i, inventory, player);
    }

    public IFilter getFilter(ItemStack stack) {
        String filterType = FilterHelper.getFilterType((ItemStack)stack);
        if (filterType.isEmpty()) {
            return EmptyFilter.INSTANCE;
        }
        IFilter ret = FILTERS.get(stack);
        if (ret != null) {
            return ret;
        }
        if (FILTERS.size() > 128) {
            FILTERS.clear();
        }
        FILTERS.put(stack, FilterRegistry.getHeldFilter((String)filterType, (CompoundNBT)stack.func_77978_p()));
        return FILTERS.get(stack);
    }

    public void onFilterChanged(ItemStack stack) {
        FILTERS.remove(stack);
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.4f, 0.8f + 0.4f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.thermal.satchel.mode." + this.getMode(stack)));
    }
}

