/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.machine;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.CrucibleRecipe;
import cofh.thermal.lib.compat.crt.actions.ActionRemoveThermalRecipeByOutput;
import cofh.thermal.lib.compat.crt.base.CRTRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.util.RecipePrintingUtil;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.Crucible")
@IRecipeHandler.For(value=CrucibleRecipe.class)
public class CRTCrucibleManager
implements IRecipeManager,
IRecipeHandler<CrucibleRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, IFluidStack output, IIngredientWithAmount ingredient, int energy) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CRTRecipe crtRecipe = new CRTRecipe(resourceLocation).energy(energy).input(ingredient).output(output);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)crtRecipe.recipe(CrucibleRecipe::new)));
    }

    public IRecipeType<CrucibleRecipe> getRecipeType() {
        return TCoreRecipeTypes.RECIPE_CRUCIBLE;
    }

    public void removeRecipe(IIngredient output) {
        throw new IllegalArgumentException("The Crucible only outputs fluids! Please provide an IFluidStack");
    }

    @ZenCodeType.Method
    public void removeRecipe(IFluidStack output) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveThermalRecipeByOutput((IRecipeManager)this, new IFluidStack[]{output}));
    }

    public String dumpToCommandString(IRecipeManager manager, CrucibleRecipe recipe) {
        return String.format("<recipetype:%s>.addRecipe(\"%s\", %s, %s, %s);", recipe.func_222127_g(), recipe.func_199560_c(), RecipePrintingUtil.stringifyFluidStacks(recipe.getOutputFluids(), (String)" | "), RecipePrintingUtil.stringifyIngredients(recipe.getInputItems(), (String)" | "), recipe.getEnergy());
    }

    public Optional<Function<ResourceLocation, CrucibleRecipe>> replaceIngredients(IRecipeManager manager, CrucibleRecipe recipe, List<IReplacementRule> rules) throws IRecipeHandler.ReplacementNotSupportedException {
        return ReplacementHandlerHelper.replaceIngredientList(recipe.getInputItems(), Ingredient.class, (IRecipe)recipe, rules, newIngredients -> id -> new CRTRecipe((ResourceLocation)id).energy(recipe.getEnergy()).setInputItems((List<Ingredient>)newIngredients).setOutputFluids(recipe.getOutputFluids()).recipe(CrucibleRecipe::new));
    }
}

