/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.gui.storage;

import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.ElementButton;
import cofh.core.client.gui.element.ElementFluidStorage;
import cofh.core.client.gui.element.ElementTexture;
import cofh.core.network.packet.server.TileConfigPacket;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.helpers.GuiHelper;
import cofh.lib.client.gui.IGuiAccess;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.inventory.container.storage.FluidCellContainer;
import cofh.thermal.core.tileentity.storage.FluidCellTile;
import cofh.thermal.lib.client.gui.CellScreenReconfigurable;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class FluidCellScreen
extends CellScreenReconfigurable<FluidCellContainer> {
    public static final String TEX_PATH = "thermal:textures/gui/container/fluid_cell.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermal:textures/gui/container/fluid_cell.png");
    public static final String TEX_INCREMENT = "cofh_core:textures/gui/elements/button_increment.png";
    public static final String TEX_DECREMENT = "cofh_core:textures/gui/elements/button_decrement.png";
    protected FluidCellTile tile;

    public FluidCellScreen(FluidCellContainer container, PlayerInventory inv, ITextComponent titleIn) {
        super(container, inv, container.tile, (ITextComponent)StringHelper.getTextComponent((String)"block.thermal.fluid_cell"));
        this.tile = container.tile;
        this.texture = TEXTURE;
        this.info = GuiHelper.generatePanelInfo((String)"info.thermal.fluid_cell");
        this.name = "fluid_cell";
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.addElement(new ElementTexture((IGuiAccess)this, 24, 16).setSize(20, 20).setTexture("cofh_core:textures/gui/elements/info_input.png", 20, 20));
        this.addElement(new ElementTexture((IGuiAccess)this, 132, 16).setSize(20, 20).setTexture("cofh_core:textures/gui/elements/info_output.png", 20, 20));
        this.addElement((ElementBase)GuiHelper.setClearable((ElementFluidStorage)GuiHelper.createMediumFluidStorage((IGuiAccess)this, (int)80, (int)22, (FluidStorageCoFH)this.tile.getTank(0)), (TileCoFH)this.tile, (int)0));
        this.addButtons();
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        String input = StringHelper.format((long)this.tile.amountInput);
        String output = StringHelper.format((long)this.tile.amountOutput);
        this.getFontRenderer().func_238421_b_(matrixStack, input, (float)this.getCenteredOffset(input, 34), 42.0f, 0x404040);
        this.getFontRenderer().func_238421_b_(matrixStack, output, (float)this.getCenteredOffset(output, 142), 42.0f, 0x404040);
        super.func_230451_b_(matrixStack, mouseX, mouseY);
    }

    public boolean handleElementButtonClick(String buttonName, int mouseButton) {
        int change = 1000;
        float pitch = 0.7f;
        if (FluidCellScreen.func_231173_s_()) {
            change *= 10;
            pitch += 0.1f;
        }
        if (FluidCellScreen.func_231172_r_()) {
            change /= 100;
            pitch -= 0.2f;
        }
        if (mouseButton == 1) {
            change /= 10;
            pitch -= 0.1f;
        }
        int curInput = this.tile.amountInput;
        int curOutput = this.tile.amountOutput;
        switch (buttonName) {
            case "DecInput": {
                this.tile.amountInput -= change;
                pitch -= 0.1f;
                break;
            }
            case "IncInput": {
                this.tile.amountInput += change;
                pitch += 0.1f;
                break;
            }
            case "DecOutput": {
                this.tile.amountOutput -= change;
                pitch -= 0.1f;
                break;
            }
            case "IncOutput": {
                this.tile.amountOutput += change;
                pitch += 0.1f;
            }
        }
        SoundHelper.playClickSound((float)pitch);
        TileConfigPacket.sendToServer((TileCoFH)this.tile);
        this.tile.amountInput = curInput;
        this.tile.amountOutput = curOutput;
        return true;
    }

    protected void addButtons() {
        ElementBase decInput = new ElementButton((IGuiAccess)this, 19, 56).setTooltipFactory((element, mouseX, mouseY) -> {
            if (element.enabled()) {
                int change = 1000;
                if (FluidCellScreen.func_231173_s_()) {
                    change *= 10;
                }
                if (FluidCellScreen.func_231172_r_()) {
                    change /= 100;
                }
                return Collections.singletonList(new StringTextComponent(StringHelper.localize((String)"info.cofh.decrease_by") + " " + StringHelper.format((long)change) + "/" + StringHelper.format((long)(change / 10))));
            }
            return Collections.emptyList();
        }).setName("DecInput").setSize(14, 14).setTexture(TEX_DECREMENT, 42, 14).setEnabled(() -> this.tile.amountInput > 0);
        ElementBase incInput = new ElementButton((IGuiAccess)this, 35, 56).setTooltipFactory((element, mouseX, mouseY) -> {
            if (element.enabled()) {
                int change = 1000;
                if (FluidCellScreen.func_231173_s_()) {
                    change *= 10;
                }
                if (FluidCellScreen.func_231172_r_()) {
                    change /= 100;
                }
                return Collections.singletonList(new StringTextComponent(StringHelper.localize((String)"info.cofh.increase_by") + " " + StringHelper.format((long)change) + "/" + StringHelper.format((long)(change / 10))));
            }
            return Collections.emptyList();
        }).setName("IncInput").setSize(14, 14).setTexture(TEX_INCREMENT, 42, 14).setEnabled(() -> this.tile.amountInput < this.tile.getMaxInput());
        ElementBase decOutput = new ElementButton((IGuiAccess)this, 127, 56).setTooltipFactory((element, mouseX, mouseY) -> {
            if (element.enabled()) {
                int change = 1000;
                if (FluidCellScreen.func_231173_s_()) {
                    change *= 10;
                }
                if (FluidCellScreen.func_231172_r_()) {
                    change /= 100;
                }
                return Collections.singletonList(new StringTextComponent(StringHelper.localize((String)"info.cofh.decrease_by") + " " + StringHelper.format((long)change) + "/" + StringHelper.format((long)(change / 10))));
            }
            return Collections.emptyList();
        }).setName("DecOutput").setSize(14, 14).setTexture(TEX_DECREMENT, 42, 14).setEnabled(() -> this.tile.amountOutput > 0);
        ElementBase incOutput = new ElementButton((IGuiAccess)this, 143, 56).setTooltipFactory((element, mouseX, mouseY) -> {
            if (element.enabled()) {
                int change = 1000;
                if (FluidCellScreen.func_231173_s_()) {
                    change *= 10;
                }
                if (FluidCellScreen.func_231172_r_()) {
                    change /= 100;
                }
                return Collections.singletonList(new StringTextComponent(StringHelper.localize((String)"info.cofh.increase_by") + " " + StringHelper.format((long)change) + "/" + StringHelper.format((long)(change / 10))));
            }
            return Collections.emptyList();
        }).setName("IncOutput").setSize(14, 14).setTexture(TEX_INCREMENT, 42, 14).setEnabled(() -> this.tile.amountOutput < this.tile.getMaxOutput());
        this.addElement(decInput);
        this.addElement(incInput);
        this.addElement(decOutput);
        this.addElement(incOutput);
    }
}

