/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.recipes.internal;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BaseMachineRecipe
implements IMachineRecipe {
    protected final List<ItemStack> inputItems = new ArrayList<ItemStack>();
    protected final List<FluidStack> inputFluids = new ArrayList<FluidStack>();
    protected final List<ItemStack> outputItems = new ArrayList<ItemStack>();
    protected final List<FluidStack> outputFluids = new ArrayList<FluidStack>();
    protected final List<Float> outputItemChances = new ArrayList<Float>();
    protected final int energy;
    protected final float experience;

    public BaseMachineRecipe(int energy, float experience) {
        this.energy = energy;
        this.experience = Math.max(0.0f, experience);
    }

    public BaseMachineRecipe(int energy, float experience, @Nullable List<ItemStack> inputItems, @Nullable List<FluidStack> inputFluids, @Nullable List<ItemStack> outputItems, @Nullable List<Float> chance, @Nullable List<FluidStack> outputFluids) {
        this(energy, experience);
        if (inputItems != null) {
            this.inputItems.addAll(inputItems);
        }
        if (inputFluids != null) {
            this.inputFluids.addAll(inputFluids);
        }
        if (outputItems != null) {
            this.outputItems.addAll(outputItems);
            if (chance != null) {
                this.outputItemChances.addAll(chance);
            }
            if (this.outputItemChances.size() < this.outputItems.size()) {
                for (int i = this.outputItemChances.size(); i < this.outputItems.size(); ++i) {
                    this.outputItemChances.add(Float.valueOf(-1.0f));
                }
            }
        }
        if (outputFluids != null) {
            this.outputFluids.addAll(outputFluids);
        }
        this.trim();
    }

    protected void trim() {
        ((ArrayList)this.inputItems).trimToSize();
        ((ArrayList)this.inputFluids).trimToSize();
        ((ArrayList)this.outputItems).trimToSize();
        ((ArrayList)this.outputFluids).trimToSize();
        ((ArrayList)this.outputItemChances).trimToSize();
    }

    @Override
    public List<ItemStack> getInputItems() {
        return this.inputItems;
    }

    @Override
    public List<FluidStack> getInputFluids() {
        return this.inputFluids;
    }

    @Override
    public List<ItemStack> getOutputItems(IMachineInventory inventory) {
        return this.outputItems;
    }

    @Override
    public List<FluidStack> getOutputFluids(IMachineInventory inventory) {
        return this.outputFluids;
    }

    @Override
    public List<Float> getOutputItemChances(IMachineInventory inventory) {
        ArrayList<Float> modifiedChances = new ArrayList<Float>(this.outputItemChances);
        for (int i = 0; i < modifiedChances.size(); ++i) {
            if (modifiedChances.get(i).floatValue() < 0.0f) {
                modifiedChances.set(i, Float.valueOf(Math.abs(modifiedChances.get(i).floatValue())));
                continue;
            }
            modifiedChances.set(i, Float.valueOf(Math.max(modifiedChances.get(i).floatValue() * (i == 0 ? inventory.getMachineProperties().getPrimaryMod() : inventory.getMachineProperties().getSecondaryMod()), inventory.getMachineProperties().getMinOutputChance())));
        }
        return modifiedChances;
    }

    @Override
    public List<Integer> getInputItemCounts(IMachineInventory inventory) {
        if (this.inputItems.isEmpty()) {
            return Collections.emptyList();
        }
        int[] ret = new int[inventory.inputSlots().size()];
        block0: for (ItemStack input : this.inputItems) {
            for (int j = 0; j < ret.length; ++j) {
                if (!ItemHelper.itemsEqual((ItemStack)input, (ItemStack)inventory.inputSlots().get(j).getItemStack())) continue;
                ret[j] = input.func_190916_E();
                continue block0;
            }
        }
        return IntStream.of(ret).boxed().collect(Collectors.toList());
    }

    @Override
    public List<Integer> getInputFluidCounts(IMachineInventory inventory) {
        if (this.inputFluids.isEmpty()) {
            return Collections.emptyList();
        }
        int[] ret = new int[inventory.inputTanks().size()];
        block0: for (FluidStack input : this.inputFluids) {
            for (int j = 0; j < ret.length; ++j) {
                if (!FluidHelper.fluidsEqual((FluidStack)input, (FluidStack)inventory.inputTanks().get(j).getFluidStack())) continue;
                ret[j] = input.getAmount();
                continue block0;
            }
        }
        return IntStream.of(ret).boxed().collect(Collectors.toList());
    }

    @Override
    public int getEnergy(IMachineInventory inventory) {
        return Math.abs(Math.round((float)this.energy * inventory.getMachineProperties().getEnergyMod()));
    }

    @Override
    public float getXp(IMachineInventory inventory) {
        return this.experience * inventory.getMachineProperties().getXpMod();
    }

    public static enum RecipeType {
        STANDARD,
        CATALYZED,
        DISENCHANT;

    }
}

