/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.device;

import cofh.lib.util.ComparableItemStack;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.device.FisherBoost;
import cofh.thermal.lib.util.managers.AbstractManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;

public class FisherManager
extends AbstractManager {
    private static final FisherManager INSTANCE = new FisherManager();
    protected Map<ComparableItemStack, Triple<ResourceLocation, Float, Float>> boostMap = new Object2ObjectOpenHashMap();

    public static FisherManager instance() {
        return INSTANCE;
    }

    protected void clear() {
        this.boostMap.clear();
    }

    public boolean validBoost(ItemStack item) {
        return this.boostMap.containsKey(FisherManager.convert(item));
    }

    public void addBoost(FisherBoost boost) {
        for (ItemStack ingredient : boost.getIngredient().func_193365_a()) {
            this.boostMap.put(FisherManager.convert(ingredient), (Triple<ResourceLocation, Float, Float>)Triple.of((Object)boost.getLootTable(), (Object)Float.valueOf(boost.getOutputMod()), (Object)Float.valueOf(boost.getUseChance())));
        }
    }

    public ResourceLocation getBoostLootTable(ItemStack item) {
        return this.validBoost(item) ? (ResourceLocation)this.boostMap.get(FisherManager.convert(item)).getLeft() : LootTables.field_186390_ao;
    }

    public float getBoostOutputMod(ItemStack item) {
        return this.validBoost(item) ? ((Float)this.boostMap.get(FisherManager.convert(item)).getMiddle()).floatValue() : 1.0f;
    }

    public float getBoostUseChance(ItemStack item) {
        return this.validBoost(item) ? ((Float)this.boostMap.get(FisherManager.convert(item)).getRight()).floatValue() : 1.0f;
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map boosts = recipeManager.func_215366_a(TCoreRecipeTypes.BOOST_FISHER);
        for (Map.Entry entry : boosts.entrySet()) {
            this.addBoost((FisherBoost)((Object)entry.getValue()));
        }
    }
}

