/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.XpContainerItem;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class XpCrystalItem
extends XpContainerItem
implements IMultiModeItem {
    public XpCrystalItem(Item.Properties builder, int xpCapacity) {
        super(builder, xpCapacity);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("stored"), (stack, world, living) -> (float)this.getStoredXp(stack) / (float)this.getCapacityXP(stack));
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.thermal.xp_crystal.use").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.thermal.xp_crystal.use.sneak").func_240699_a_(TextFormatting.DARK_GRAY));
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)("info.thermal.xp_crystal.mode." + this.getMode(stack))).func_240699_a_(TextFormatting.ITALIC));
        this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (Utils.isClientWorld((World)worldIn) || Utils.isFakePlayer((Entity)entityIn) || this.getMode(stack) <= 0) {
            return;
        }
        entityIn.getPersistentData().func_74772_a("XpTimer", entityIn.field_70170_p.func_82737_E());
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.4f, 0.6f + 0.2f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.thermal.xp_crystal.mode." + this.getMode(stack)));
    }
}

