/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.inventory.container.storage;

import cofh.core.network.packet.server.SecurityPacket;
import cofh.lib.inventory.IInventoryContainerItem;
import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.inventory.container.ContainerCoFH;
import cofh.lib.inventory.container.slot.SlotCoFH;
import cofh.lib.inventory.container.slot.SlotLocked;
import cofh.lib.inventory.wrapper.InvWrapperCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.control.ISecurable;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.item.SatchelItem;
import com.mojang.authlib.GameProfile;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class SatchelContainer
extends ContainerCoFH
implements ISecurable {
    public static final int MAX_SLOTS = 54;
    public static final int MAX_ROWS = 6;
    protected final IInventoryContainerItem containerItem;
    protected SimpleItemInv itemInventory;
    protected InvWrapperCoFH invWrapper;
    protected ItemStack containerStack;
    public SlotLocked lockedSlot;
    protected int numSlots;
    protected int rows;

    private static boolean isSatchel(ItemStack stack) {
        return stack.func_77973_b() instanceof SatchelItem;
    }

    public SatchelContainer(int windowId, PlayerInventory inventory, PlayerEntity player) {
        super(TCoreReferences.SATCHEL_CONTAINER, windowId, inventory, player);
        int i;
        this.allowSwap = false;
        this.containerStack = SatchelContainer.isSatchel(player.func_184614_ca()) ? player.func_184614_ca() : player.func_184592_cb();
        this.containerItem = (IInventoryContainerItem)this.containerStack.func_77973_b();
        this.numSlots = MathHelper.clamp((int)this.containerItem.getContainerSlots(this.containerStack), (int)0, (int)54);
        this.itemInventory = this.containerItem.getContainerInventory(this.containerStack);
        this.invWrapper = new InvWrapperCoFH(this.itemInventory, this.numSlots);
        this.rows = MathHelper.clamp((int)(this.numSlots / 9), (int)0, (int)6);
        int extraSlots = this.numSlots % 9;
        int xOffset = 8;
        int yOffset = 44 - 9 * MathHelper.clamp((int)(this.rows + (extraSlots > 0 ? 1 : 0)), (int)0, (int)3);
        for (i = 0; i < this.rows * 9; ++i) {
            this.func_75146_a((Slot)new SlotCoFH(this.invWrapper, i, xOffset + i % 9 * 18, yOffset + i / 9 * 18));
        }
        if (extraSlots > 0) {
            xOffset = 89 - 9 * extraSlots;
            for (i = this.numSlots - extraSlots; i < this.numSlots; ++i) {
                this.func_75146_a((Slot)new SlotCoFH(this.invWrapper, i, xOffset + i % extraSlots * 18, yOffset + 18 * this.rows));
            }
        }
        this.bindPlayerInventory(inventory);
    }

    protected void bindPlayerInventory(PlayerInventory inventory) {
        int i;
        int xOffset = this.getPlayerInventoryHorizontalOffset();
        int yOffset = this.getPlayerInventoryVerticalOffset();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == inventory.field_70461_c) {
                this.lockedSlot = new SlotLocked((IInventory)inventory, i, xOffset + i * 18, yOffset + 58);
                this.func_75146_a((Slot)this.lockedSlot);
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventory, i, xOffset + i * 18, yOffset + 58));
        }
    }

    protected int getPlayerInventoryVerticalOffset() {
        return 84 + this.getExtraRows() * 18;
    }

    public int getExtraRows() {
        return MathHelper.clamp((int)(this.rows + (this.numSlots % 9 > 0 ? 1 : 0) - 3), (int)0, (int)3);
    }

    public int getContainerInventorySize() {
        return this.numSlots;
    }

    protected int getMergeableSlotCount() {
        return this.invWrapper.func_70302_i_();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        this.itemInventory.write(this.containerItem.getOrCreateInvTag(this.containerStack));
        this.containerItem.onContainerInventoryChanged(this.containerStack);
        super.func_75134_a(playerIn);
    }

    public ISecurable.AccessMode getAccess() {
        return SecurityHelper.getAccess((ItemStack)this.containerStack);
    }

    public GameProfile getOwner() {
        return SecurityHelper.getOwner((ItemStack)this.containerStack);
    }

    public void setAccess(ISecurable.AccessMode access) {
        SecurityHelper.setAccess((ItemStack)this.containerStack, (ISecurable.AccessMode)access);
        if (Utils.isClientWorld((World)this.player.field_70170_p)) {
            SecurityPacket.sendToServer((ISecurable.AccessMode)access);
        }
    }

    public boolean setOwner(GameProfile profile) {
        return false;
    }
}

