/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.monster;

import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.entity.projectile.BasalzProjectileEntity;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.common.ThermalFlags;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BasalzEntity
extends MonsterEntity {
    protected static final int DEFAULT_ORBIT = 8;
    public static final int DEPLOY_TIME = 6;
    private static final DataParameter<Byte> ANGRY = EntityDataManager.func_187226_a(BasalzEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final Vector3d vert = new Vector3d(0.0, 1.0, 0.0);
    protected int attackTime = 0;
    public int angerTime = 72000;
    protected boolean wasAngry = false;

    public static boolean canSpawn(EntityType<BasalzEntity> entityType, IServerWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BASALZ).getAsBoolean() && MonsterEntity.func_223325_c(entityType, (IServerWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)rand);
    }

    public BasalzEntity(EntityType<? extends BasalzEntity> type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 2.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70728_aV = 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new BasalzAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new SwimGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGRY, (Object)16);
    }

    protected SoundEvent func_184639_G() {
        return ThermalConfig.mobAmbientSounds ? TCoreSounds.SOUND_BASALZ_AMBIENT : null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TCoreSounds.SOUND_BASALZ_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TCoreSounds.SOUND_BASALZ_DEATH;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.isAngry() && this.field_70146_Z.nextInt(2) == 0) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218423_k, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
            ++this.angerTime;
        } else if (this.func_70089_S() && this.isAngry() && this.attackTime <= 0 && this.getOrbit() > 0) {
            Vector3d pos = this.func_213303_ch();
            for (Entity target : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(4.0, 1.0, 4.0))) {
                if (target instanceof BasalzEntity || !(this.func_70068_e(target) < 12.25) || !this.func_70685_l(target)) continue;
                this.attackTime = 15;
                Vector3d targetPos = target.func_213303_ch();
                Vector3d offset = targetPos.func_178788_d(pos).func_72432_b().func_72431_c(vert).func_186678_a(0.5);
                BasalzProjectileEntity projectile = new BasalzProjectileEntity(targetPos.field_72450_a + offset.field_72450_a, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f), targetPos.field_72449_c + offset.field_72449_c, 0.0, 0.0, 0.0, this.field_70170_p);
                projectile.func_213293_j(-offset.field_72450_a, 0.0, -offset.field_72449_c);
                projectile.func_212361_a((Entity)this);
                projectile.func_70227_a((RayTraceResult)new EntityRayTraceResult(target));
                if (this.getOrbit() > 0) {
                    this.reduceOrbit();
                    continue;
                }
                break;
            }
        } else {
            --this.attackTime;
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, source == DamageSource.field_180137_b ? amount + 3.0f : amount);
    }

    public boolean func_70687_e(EffectInstance effect) {
        return super.func_70687_e(effect) && !effect.equals((Object)CoreReferences.SUNDERED);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ThermalCore.ITEMS.get("basalz_spawn_egg"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.isAngry() ? super.func_184177_bl().func_186662_g(4.0) : super.func_184177_bl();
    }

    public boolean func_180431_b(DamageSource source) {
        return source.field_76373_n.equals("basalz") || super.func_180431_b(source);
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(ANGRY) & 1) != 0;
    }

    protected void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ANGRY);
        b0 = angry ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(ANGRY, (Object)b0);
    }

    public int getOrbit() {
        return ((Byte)this.field_70180_af.func_187225_a(ANGRY) & 0x3E) >> 1;
    }

    public void setOrbit(int orbit) {
        this.field_70180_af.func_187227_b(ANGRY, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(ANGRY) & 0xFFFFFFC1 | (orbit & 0x1F) << 1)));
    }

    public void reduceOrbit() {
        this.setOrbit(Math.max(this.getOrbit() - 1, 0));
    }

    public void resetOrbit() {
        this.setOrbit(8);
    }

    public void func_184206_a(DataParameter<?> data) {
        super.func_184206_a(data);
        if (this.field_70170_p.field_72995_K && data.equals(ANGRY) && this.isAngry() != this.wasAngry) {
            this.angerTime = Math.max(0, 6 - this.angerTime);
            this.wasAngry = this.isAngry();
        }
    }

    static class BasalzAttackGoal
    extends Goal {
        private final BasalzEntity basalz;
        private int attackTime;
        private int refreshTime = 100;
        private int chaseStep;
        private int navTime;

        public BasalzAttackGoal(BasalzEntity basalzIn) {
            this.basalz = basalzIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.basalz.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.basalz.func_213336_c(livingentity);
        }

        public void func_75249_e() {
            this.chaseStep = 0;
            this.navTime = 0;
            this.refreshTime = 100;
        }

        public void func_75251_c() {
            this.basalz.setAngry(false);
            this.chaseStep = 0;
            this.navTime = 0;
            this.refreshTime = 100;
        }

        public void func_75246_d() {
            --this.attackTime;
            --this.navTime;
            LivingEntity target = this.basalz.func_70638_az();
            if (target == null) {
                return;
            }
            Vector3d pos = this.basalz.func_213303_ch();
            Vector3d targetPos = target.func_213303_ch();
            double distSqr = this.basalz.func_70068_e((Entity)target);
            if (this.basalz.func_70635_at().func_75522_a((Entity)target) && distSqr < this.getFollowDistance() * this.getFollowDistance()) {
                this.chaseStep = 0;
                if (this.basalz.getOrbit() > 0) {
                    this.basalz.func_70671_ap().func_75651_a((Entity)target, 10.0f, 10.0f);
                    if (!this.basalz.isAngry()) {
                        this.basalz.setAngry(true);
                        this.basalz.field_70170_p.func_184148_a(null, pos.field_72450_a + 0.5, pos.field_72448_b + 0.5, pos.field_72449_c + 0.5, TCoreSounds.SOUND_BASALZ_SHOOT, SoundCategory.HOSTILE, 2.5f, (this.basalz.field_70146_Z.nextFloat() - 0.5f) * 0.2f + 1.0f);
                        this.navTime = 0;
                    }
                    if (distSqr < 2.25) {
                        if (this.attackTime <= 0) {
                            this.attackTime = 20;
                            this.basalz.func_70652_k((Entity)target);
                        }
                    } else if (distSqr < 12.25) {
                        this.basalz.field_70699_by.func_75499_g();
                        this.navTime = 0;
                    } else if (this.navTime <= 0) {
                        this.basalz.field_70699_by.func_75497_a((Entity)target, 1.0);
                        this.navTime = 15;
                    }
                } else {
                    if (this.basalz.isAngry()) {
                        this.basalz.setAngry(false);
                        this.navTime = 0;
                    }
                    if (this.refreshTime > 0) {
                        --this.refreshTime;
                        if (distSqr < 144.0 && this.navTime <= 0) {
                            Vector3d diff = new Vector3d(pos.field_72450_a - targetPos.field_72450_a, 0.0, pos.field_72449_c - targetPos.field_72449_c).func_72432_b().func_186678_a(16.0);
                            this.basalz.func_70671_ap().func_75650_a(targetPos.field_72450_a + diff.field_72450_a, this.basalz.func_226280_cw_(), targetPos.field_72449_c + diff.field_72449_c, 10.0f, 10.0f);
                            this.basalz.field_70699_by.func_75492_a(targetPos.field_72450_a + diff.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c + diff.field_72449_c, 1.0);
                            this.navTime = 15;
                        }
                    } else {
                        this.refreshTime = 100;
                        this.basalz.resetOrbit();
                    }
                }
            } else if (this.chaseStep < 5) {
                ++this.chaseStep;
                this.basalz.func_70605_aq().func_75642_a(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c, 1.0);
            } else {
                this.basalz.setAngry(false);
            }
            super.func_75246_d();
        }

        private double getFollowDistance() {
            return this.basalz.func_233637_b_(Attributes.field_233819_b_);
        }
    }
}

