/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class NetworkTools {
    public static ItemStack readItemStack(PacketBuffer buf) {
        ItemStack stack = buf.func_150791_c();
        stack.func_190920_e(buf.readInt());
        return stack;
    }

    public static void writeItemStack(PacketBuffer buf, ItemStack itemStack) {
        buf.writeItemStack(itemStack, false);
        buf.writeInt(itemStack.func_190916_E());
    }

    public static String readString(PacketBuffer dataIn) {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readBytes(dst);
        return new String(dst);
    }

    public static void writeString(PacketBuffer dataOut, String str) {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes();
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.writeBytes(bytes);
        }
    }

    public static String readStringUTF8(PacketBuffer dataIn) {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readBytes(dst);
        return new String(dst, StandardCharsets.UTF_8);
    }

    public static void writeStringUTF8(PacketBuffer dataOut, String str) {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.writeBytes(bytes);
        }
    }

    public static <T extends Enum<T>> void writeEnumCollection(PacketBuffer buf, Collection<T> collection) {
        buf.func_150787_b(collection.size());
        for (Enum type : collection) {
            buf.func_179249_a(type);
        }
    }

    public static <T extends Enum<T>> void readEnumCollection(PacketBuffer buf, Collection<T> collection, Class<T> enumClass) {
        collection.clear();
        int size = buf.func_150792_a();
        for (int i = 0; i < size; ++i) {
            collection.add(buf.func_179257_a(enumClass));
        }
    }

    public static void writeFloat(PacketBuffer buf, Float f) {
        if (f != null) {
            buf.writeBoolean(true);
            buf.writeFloat(f.floatValue());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static Float readFloat(PacketBuffer buf) {
        if (buf.readBoolean()) {
            return Float.valueOf(buf.readFloat());
        }
        return null;
    }
}

