/*
 * Decompiled with CFR 0.152.
 */
package com.github.thegoldcrayon.tgcropesmod.tileentity;

import com.github.thegoldcrayon.tgcropesmod.container.DryingRackContainer;
import com.github.thegoldcrayon.tgcropesmod.init.ModRegistry;
import com.github.thegoldcrayon.tgcropesmod.init.ModTileEntityTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DryingRackTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final int INPUT_SLOT_1 = 0;
    public static final int INPUT_SLOT_2 = 1;
    public static final int INPUT_SLOT_3 = 2;
    public static final int INPUT_SLOT_4 = 3;
    public static final int OUTPUT_SLOT_1 = 4;
    public static final int OUTPUT_SLOT_2 = 5;
    public static final int OUTPUT_SLOT_3 = 6;
    public static final int OUTPUT_SLOT_4 = 7;
    public static final int TIME_TO_DRY = 100;
    private static final String INVENTORY_TAG = "inventory";
    public int[] dryingTimeLeft = new int[]{-1, -1, -1, -1};
    public final ItemStackHandler inventory = new ItemStackHandler(8){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            switch (slot) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return DryingRackTileEntity.this.isInput(stack);
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return DryingRackTileEntity.this.isOutput(stack);
                }
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DryingRackTileEntity.this.func_70296_d();
        }
    };
    private final LazyOptional<ItemStackHandler> inventoryCapabilityExternal = LazyOptional.of(() -> this.inventory);
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalUp = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 4));
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalDown = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 4, 8));
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalSides = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 4));

    public DryingRackTileEntity() {
        super(ModTileEntityTypes.DRYING_RACK_TILE_ENTITY_TYPE);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)ModRegistry.DRYING_RACK.get()).func_149739_a());
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new DryingRackContainer(windowId, inventory, this);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        for (int slot = 0; slot <= 3; ++slot) {
            ItemStack input = this.inventory.getStackInSlot(slot);
            ItemStack result = this.getResult(input);
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                this.dryingTimeLeft[slot] = -1;
                continue;
            }
            if (!this.isInput(input)) continue;
            if (this.dryingTimeLeft[slot] == -1) {
                this.dryingTimeLeft[slot] = 100;
                continue;
            }
            if (this.dryingTimeLeft[slot] <= 0) continue;
            int n = slot;
            this.dryingTimeLeft[n] = this.dryingTimeLeft[n] - 1;
            if (this.dryingTimeLeft[slot] != 0) continue;
            input.func_190918_g(1);
            this.inventory.insertItem(slot + 4, result, false);
            this.dryingTimeLeft[slot] = -1;
        }
        this.func_70296_d();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.inventoryCapabilityExternal.cast();
            }
            switch (side) {
                case DOWN: {
                    return this.inventoryCapabilityExternalDown.cast();
                }
                case UP: {
                    return this.inventoryCapabilityExternalUp.cast();
                }
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    return this.inventoryCapabilityExternalSides.cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.inventory.deserializeNBT(compound.func_74775_l(INVENTORY_TAG));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a(INVENTORY_TAG, (INBT)this.inventory.serializeNBT());
        return compound;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inventoryCapabilityExternal.invalidate();
    }

    private boolean isInput(ItemStack stack) {
        return stack.func_77973_b() == ModRegistry.FRESH_FLAX.get();
    }

    private boolean isOutput(ItemStack stack) {
        return stack.func_77973_b() == ModRegistry.DRY_FLAX.get();
    }

    private ItemStack getResult(ItemStack input) {
        if (input.func_77973_b() == ModRegistry.FRESH_FLAX.get()) {
            return new ItemStack((IItemProvider)ModRegistry.DRY_FLAX.get());
        }
        return new ItemStack(null);
    }
}

