/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;

public class ReflectUtils {
    public static MethodHandle field(Class<?> owner, Class<?> type, String ... names) {
        try {
            Field field = ReflectUtils.getField(owner, type, f -> ReflectUtils.contains(names, f.getName()));
            return MethodHandles.lookup().in(owner).unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static MethodHandle method(Class<?> owner, Class<?> type, String ... names) {
        try {
            Method method = ReflectUtils.getMethod(owner, type, f -> ReflectUtils.contains(names, f.getName()));
            return MethodHandles.lookup().in(owner).unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static MethodHandle method(Class<?> owner, Class<?> type, Class<?> ... argTypes) {
        try {
            Method method = ReflectUtils.getMethod(owner, type, m -> Arrays.equals(argTypes, m.getParameterTypes()));
            return MethodHandles.lookup().in(owner).unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static MethodHandle method(Class<?> owner, Class<?> type, String[] names, Class<?>[] argTypes) {
        try {
            Method method = ReflectUtils.getMethod(owner, type, m -> ReflectUtils.contains(names, m.getName()) && ReflectUtils.equals(argTypes, m.getParameterTypes()));
            return MethodHandles.lookup().in(owner).unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getField(Class<?> owner, Class<?> fieldType, Predicate<Field> predicate) {
        return (Field)ReflectUtils.accessMember(owner, fieldType, (AccessibleObject[])owner.getDeclaredFields(), Field::getType, predicate);
    }

    public static Method getMethod(Class<?> owner, Class<?> fieldType, Predicate<Method> predicate) {
        return (Method)ReflectUtils.accessMember(owner, fieldType, (AccessibleObject[])owner.getDeclaredMethods(), Method::getReturnType, predicate);
    }

    public static <T extends AccessibleObject> T accessMember(Class<?> owner, Class<?> type, T[] members, Function<T, Class<?>> typeGetter, Predicate<T> predicate) {
        for (T member : members) {
            if (typeGetter.apply(member) != type || !predicate.test(member)) continue;
            ((AccessibleObject)member).setAccessible(true);
            return member;
        }
        throw new IllegalStateException("Unable to find matching member in class " + owner);
    }

    public static <T extends Member> Predicate<T> modifiers(IntPredicate ... flags) {
        return t -> {
            int modifiers = t.getModifiers();
            for (IntPredicate flag : flags) {
                if (flag.test(modifiers)) continue;
                return false;
            }
            return true;
        };
    }

    private static <T> boolean contains(T[] array, T value) {
        if (array.length > 0) {
            for (T t : array) {
                if (!t.equals(value)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @SafeVarargs
    private static <T> boolean equals(T[] array, T ... value) {
        return Arrays.equals(array, value);
    }
}

