/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.profiler.timings;

import com.terraforged.mod.profiler.timings.TimingStack;

public class Top3TimingStack
implements TimingStack {
    private final Entry entry0 = new Entry();
    private final Entry entry1 = new Entry();
    private final Entry entry2 = new Entry();

    @Override
    public TimingStack copy() {
        Top3TimingStack stack = new Top3TimingStack();
        stack.entry0.copy(this.entry0);
        stack.entry1.copy(this.entry1);
        stack.entry2.copy(this.entry2);
        return stack;
    }

    @Override
    public TimingStack reset() {
        this.entry0.reset();
        this.entry1.reset();
        this.entry2.reset();
        return null;
    }

    @Override
    public int size() {
        if (this.entry0.identifier == null) {
            return 0;
        }
        if (this.entry1.identifier == null) {
            return 1;
        }
        if (this.entry2.identifier == null) {
            return 2;
        }
        return 3;
    }

    @Override
    public void push(String type, Object identifier, long time) {
        if (this.entry0.set(type, identifier, time)) {
            return;
        }
        if (this.entry1.set(type, identifier, time)) {
            return;
        }
        this.entry2.set(type, identifier, time);
    }

    @Override
    public <T> void iterate(T ctx, TimingStack.Visitor<T> visitor) {
        Top3TimingStack.visit(this.entry0, ctx, visitor);
        Top3TimingStack.visit(this.entry1, ctx, visitor);
        Top3TimingStack.visit(this.entry2, ctx, visitor);
    }

    private static <T> void visit(Entry entry, T ctx, TimingStack.Visitor<T> visitor) {
        if (entry.identifier != null) {
            visitor.visit(entry.type, entry.identifier, entry.time, ctx);
        }
    }

    private static class Entry {
        private long time = 0L;
        private String type = null;
        private Object identifier = null;

        private Entry() {
        }

        private void reset() {
            this.type = null;
            this.identifier = null;
            this.time = 0L;
        }

        private void copy(Entry other) {
            this.type = other.type;
            this.identifier = other.identifier;
            this.time = other.time;
        }

        private boolean set(String type, Object identifier, long time) {
            if (identifier == null || time > this.time) {
                this.identifier = identifier;
                this.type = type;
                this.time = time;
                return true;
            }
            return false;
        }
    }
}

