/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.util.identity;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.terraforged.mod.featuremanager.FeatureSerializer;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import com.terraforged.mod.featuremanager.util.identity.Identifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;

public class FeatureIdentifier
implements Identifier {
    public static final FeatureIdentifier NONE = new FeatureIdentifier(Collections.emptyList());
    private final List<String> identity;
    private final Supplier<String> ownerString;
    private final Supplier<String> components;

    public FeatureIdentifier(List<String> identity) {
        this.identity = identity;
        this.ownerString = Suppliers.memoize(() -> {
            StringBuilder sb = new StringBuilder(32);
            sb.append('[');
            for (int i = 0; i < identity.size(); ++i) {
                String id = (String)identity.get(i);
                int namespaceEnd = id.indexOf(58);
                sb.append(i > 0 ? "," : "").append(id, 0, namespaceEnd);
            }
            sb.append(']');
            return sb.toString();
        });
        this.components = Suppliers.memoize(() -> {
            StringBuilder sb = new StringBuilder(32);
            sb.append('[');
            for (int i = 0; i < identity.size(); ++i) {
                sb.append(i > 0 ? "," : "").append((String)identity.get(i));
            }
            sb.append(']');
            return sb.toString();
        });
    }

    @Override
    public String getNameSpaces() {
        return this.ownerString.get();
    }

    @Override
    public String getComponents() {
        return this.components.get();
    }

    public String toString() {
        return this.getComponents();
    }

    public static FeatureIdentifier getIdentity(ConfiguredFeature<?, ?> feature) {
        ResourceLocation name = WorldGenRegistries.field_243653_e.func_177774_c(feature);
        if (name != null) {
            return new FeatureIdentifier(Collections.singletonList(name.toString()));
        }
        try {
            JsonElement jsonElement = FeatureSerializer.serialize(feature);
            return FeatureIdentifier.getIdentity(jsonElement);
        }
        catch (Throwable t) {
            return NONE;
        }
    }

    public static FeatureIdentifier getIdentity(ConfiguredCarver<?> carver) {
        ResourceLocation name = WorldGenRegistries.field_243652_d.func_177774_c(carver);
        if (name != null) {
            return new FeatureIdentifier(Collections.singletonList(name.toString()));
        }
        try {
            JsonElement jsonElement = Codecs.encode(ConfiguredCarver.field_236235_a_, carver);
            return FeatureIdentifier.getIdentity(jsonElement);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return NONE;
        }
    }

    public static FeatureIdentifier getIdentity(ConfiguredFeature<?, ?> feature, JsonElement jsonElement) {
        ResourceLocation name = WorldGenRegistries.field_243653_e.func_177774_c(feature);
        if (name != null) {
            return new FeatureIdentifier(Collections.singletonList(name.toString()));
        }
        return FeatureIdentifier.getIdentity(jsonElement);
    }

    private static FeatureIdentifier getIdentity(JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            return NONE;
        }
        try {
            ArrayList<String> list = new ArrayList<String>(4);
            FeatureIdentifier.collectIdentifiers(jsonElement, list);
            if (list.size() == 0) {
                return NONE;
            }
            Collections.sort(list);
            return new FeatureIdentifier(list);
        }
        catch (Throwable t) {
            return NONE;
        }
    }

    public static void collectIdentifiers(JsonElement element, List<String> collector) {
        if (element.isJsonObject()) {
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                FeatureIdentifier.collectIdentifier((String)entry.getKey(), collector);
                FeatureIdentifier.collectIdentifiers((JsonElement)entry.getValue(), collector);
            }
        } else if (element.isJsonArray()) {
            for (JsonElement entry : element.getAsJsonArray()) {
                FeatureIdentifier.collectIdentifiers(entry, collector);
            }
        } else if (element.isJsonPrimitive()) {
            FeatureIdentifier.collectIdentifier(element.getAsString(), collector);
        }
    }

    private static void collectIdentifier(String string, List<String> collector) {
        if (string.indexOf(58) != -1 && !collector.contains(string)) {
            collector.add(string);
        }
    }
}

