/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraftforge.registries.ForgeRegistries;

public class FeatureDebugger {
    public static List<String> getErrors(ConfiguredFeature<?, ?> feature) {
        ArrayList<String> errors = new ArrayList<String>();
        FeatureDebugger.checkConfiguredFeature(feature, errors);
        return errors;
    }

    private static void checkConfiguredFeature(ConfiguredFeature<?, ?> feature, List<String> errors) {
        if (!FeatureDebugger.validateConfiguredFeature(feature, errors)) {
            return;
        }
        if (feature.field_222738_b instanceof DecoratedFeatureConfig) {
            FeatureDebugger.decorated((DecoratedFeatureConfig)feature.field_222738_b, errors);
            return;
        }
        if (feature.field_222738_b instanceof SingleRandomFeature) {
            FeatureDebugger.single((SingleRandomFeature)feature.field_222738_b, errors);
            return;
        }
        if (feature.field_222738_b instanceof TwoFeatureChoiceConfig) {
            FeatureDebugger.twoChoice((TwoFeatureChoiceConfig)feature.field_222738_b, errors);
            return;
        }
        if (feature.field_222738_b instanceof MultipleRandomFeatureConfig) {
            FeatureDebugger.multi((MultipleRandomFeatureConfig)feature.field_222738_b, errors);
            return;
        }
    }

    private static void decorated(DecoratedFeatureConfig config, List<String> errors) {
        FeatureDebugger.checkConfiguredFeature((ConfiguredFeature)config.field_214689_a.get(), errors);
        FeatureDebugger.checkDecorator(config.field_214690_b, errors);
    }

    private static void single(SingleRandomFeature config, List<String> errors) {
        for (Supplier feature : config.field_204628_a) {
            FeatureDebugger.checkConfiguredFeature((ConfiguredFeature)feature.get(), errors);
        }
    }

    private static void twoChoice(TwoFeatureChoiceConfig config, List<String> errors) {
        FeatureDebugger.checkConfiguredFeature((ConfiguredFeature)config.field_227285_a_.get(), errors);
        FeatureDebugger.checkConfiguredFeature((ConfiguredFeature)config.field_227286_b_.get(), errors);
    }

    private static void multi(MultipleRandomFeatureConfig config, List<String> errors) {
        for (ConfiguredRandomFeatureList feature : config.field_202449_a) {
            FeatureDebugger.checkConfiguredFeature((ConfiguredFeature)feature.field_214842_a.get(), errors);
        }
    }

    private static boolean validateConfiguredFeature(ConfiguredFeature<?, ?> feature, List<String> list) {
        if (feature == null) {
            list.add("null  configured feature - this is bad D:");
            return false;
        }
        return FeatureDebugger.checkFeature(feature.field_222737_a, list) && FeatureDebugger.checkConfig(feature.field_222738_b, list);
    }

    private static boolean checkFeature(Feature<?> feature, List<String> list) {
        if (feature == null) {
            list.add("null feature");
            return false;
        }
        if (!ForgeRegistries.FEATURES.containsValue(feature)) {
            list.add("unregistered feature: " + feature.getClass().getName());
            return false;
        }
        return true;
    }

    private static boolean checkConfig(IFeatureConfig config, List<String> list) {
        if (config == null) {
            list.add("null config");
            return false;
        }
        try {
            return true;
        }
        catch (Throwable t) {
            list.add("config: " + config.getClass().getName() + ", error: " + t.getMessage());
            return false;
        }
    }

    private static boolean checkDecorator(ConfiguredPlacement<?> decorator, List<String> list) {
        if (decorator == null) {
            list.add("null configured placement");
            return false;
        }
        boolean valid = true;
        if (decorator.func_242877_b() == null) {
            valid = false;
            list.add("null decorator config");
        }
        return valid;
    }
}

