/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.util;

import com.terraforged.mod.Log;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class ChunkRegionBoundingBox
extends MutableBoundingBox {
    private static final int INCLUSIVE_SIZE = 15;
    private static final String ERROR_MESSAGE = "Structure {} attempted to change the world-gen region bounds to an unsafe location/size. Original: {}, Altered: {}";
    private final int boundX0 = this.field_78897_a;
    private final int boundZ1 = this.field_78896_c;
    private final int boundX1 = this.field_78893_d;
    private final int boundZ2 = this.field_78892_f;
    private final int radiusX0;
    private final int radiusZ0;
    private final int radiusX1;
    private final int radiusZ1;
    private String structure = "unknown";

    public ChunkRegionBoundingBox(int chunkX, int chunkZ, int chunkRadius) {
        super(chunkX << 4, chunkZ << 4, (chunkX << 4) + 15, (chunkZ << 4) + 15);
        this.radiusX0 = chunkX - chunkRadius << 4;
        this.radiusZ0 = chunkZ - chunkRadius << 4;
        this.radiusX1 = (chunkX + chunkRadius << 4) + 15;
        this.radiusZ1 = (chunkZ + chunkRadius << 4) + 15;
    }

    public ChunkRegionBoundingBox init(StructureStart<?> start) {
        return this.init(start.func_214627_k().func_143025_a());
    }

    public ChunkRegionBoundingBox init(String name) {
        this.field_78897_a = this.boundX0;
        this.field_78896_c = this.boundZ1;
        this.field_78893_d = this.boundX1;
        this.field_78892_f = this.boundZ2;
        this.field_78895_b = 1;
        this.field_78894_e = 512;
        this.structure = name;
        return this;
    }

    public void func_78888_b(MutableBoundingBox other) {
        super.func_78888_b(other);
        this.validate();
    }

    public void func_78886_a(int x, int y, int z) {
        super.func_78886_a(x, y, z);
        this.validate();
    }

    public void func_236989_a_(Vector3i vec) {
        super.func_236989_a_(vec);
        this.validate();
    }

    public String toString() {
        return "BoundingBox{minX=" + this.field_78897_a + ", minZ=" + this.field_78896_c + ", maxX=" + this.field_78893_d + ", maxZ=" + this.field_78892_f + ", sizeChunks=" + this.getSizeChunks() + "}";
    }

    private String getSizeChunks() {
        int chunkSizeX = (this.field_78893_d >> 4) - (this.field_78897_a >> 4);
        int chunkSizeZ = (this.field_78892_f >> 4) - (this.field_78896_c >> 4);
        return chunkSizeX + "x" + chunkSizeZ;
    }

    private void validate() {
        if (!ChunkRegionBoundingBox.contains(this.field_78897_a, this.field_78896_c, this.radiusX0, this.radiusZ0, this.radiusX1, this.radiusZ1) || !ChunkRegionBoundingBox.contains(this.field_78893_d, this.field_78892_f, this.radiusX0, this.radiusZ0, this.radiusX1, this.radiusZ1)) {
            String from = ChunkRegionBoundingBox.toString(this.radiusX0, this.radiusZ0, this.radiusX1, this.radiusZ1);
            String to = ChunkRegionBoundingBox.toString(this.field_78897_a, this.field_78896_c, this.field_78893_d, this.field_78892_f);
            Log.warn(ERROR_MESSAGE, this.structure, from, to);
        }
    }

    public static boolean contains(int x, int z, MutableBoundingBox bounds) {
        return ChunkRegionBoundingBox.contains(x, z, bounds.field_78897_a, bounds.field_78896_c, bounds.field_78893_d, bounds.field_78892_f);
    }

    public static boolean contains(int x, int z, int minX, int minZ, int maxX, int maxZ) {
        return x >= minX && x <= maxX && z >= minZ && z <= maxZ;
    }

    public static String toString(int minX, int minZ, int maxX, int maxZ) {
        return "Bounds{minX=" + minX + ",minZ=" + minZ + ",maxX=" + maxX + ",maxZ=" + maxZ + "}";
    }
}

