/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.api.material;

import com.terraforged.mod.Log;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class WGTags {
    public static final ITag.INamedTag<Block> STONE = WGTags.tag("forge:wg_stone");
    public static final ITag.INamedTag<Block> DIRT = WGTags.tag("forge:wg_dirt");
    public static final ITag.INamedTag<Block> CLAY = WGTags.tag("forge:wg_clay");
    public static final ITag.INamedTag<Block> SEDIMENT = WGTags.tag("forge:wg_sediment");
    public static final ITag.INamedTag<Block> ERODIBLE = WGTags.tag("forge:wg_erodible");
    public static final List<ITag.INamedTag<Block>> WG_TAGS = Collections.unmodifiableList(Arrays.asList(STONE, DIRT, CLAY, SEDIMENT, ERODIBLE));
    public static final Set<ResourceLocation> NAMED_WG_TAGS = WG_TAGS.stream().map(ITag.INamedTag::func_230234_a_).collect(Collectors.toSet());

    public static void init() {
        Log.info("Initializing tags", new Object[0]);
    }

    private static Tags.IOptionalNamedTag<Block> tag(String name) {
        return BlockTags.createOptional((ResourceLocation)new ResourceLocation(name));
    }

    public static Predicate<BlockState> stone() {
        return WGTags.toStatePredicate(STONE);
    }

    private static Predicate<BlockState> toStatePredicate(ITag<Block> tag) {
        return state -> tag.func_230235_a_((Object)state.func_177230_c());
    }

    public static void printTags() {
        for (ITag.INamedTag<Block> tag : WG_TAGS) {
            Log.debug("World-Gen Tag: {}", tag.func_230234_a_());
            for (Block block : tag.func_230236_b_()) {
                Log.debug(" - {}", block.getRegistryName());
            }
        }
    }
}

