/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod;

import com.terraforged.engine.Engine;
import com.terraforged.engine.concurrent.task.LazySupplier;
import com.terraforged.mod.Log;
import com.terraforged.mod.RegistrationEvents;
import com.terraforged.mod.api.material.WGTags;
import com.terraforged.mod.config.ConfigManager;
import com.terraforged.mod.server.command.TerraCommand;
import com.terraforged.mod.util.DataUtils;
import com.terraforged.mod.util.Environment;
import com.terraforged.mod.util.TagFixer;
import java.io.File;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod(value="terraforged")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TerraForgedMod {
    public static final String MODID = "terraforged";
    public static final File CONFIG_DIR = new File("config", "terraforged").getAbsoluteFile();
    public static final File PRESETS_DIR = new File(CONFIG_DIR, "presets");
    public static final File DATAPACK_DIR = new File(CONFIG_DIR, "datapacks");
    private static final Supplier<String> VERSION = LazySupplier.of(() -> ModList.get().getModContainerById(MODID).map(ModContainer::getModInfo).map(IModInfo::getVersion).map(Objects::toString).orElse("unknown"));

    public TerraForgedMod() {
        Environment.log();
        ModFileInfo modInfo = ModList.get().getModFileById(MODID);
        Log.info("Signature:  {}", modInfo.getCodeSigningFingerprint().orElse("UNSIGNED"));
        Log.info("Trust Data: {}", modInfo.getTrustData().orElse("UNTRUSTED"));
        Engine.init();
        WGTags.init();
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        Log.info("Common setup", new Object[0]);
        DataUtils.initDirs(PRESETS_DIR, DATAPACK_DIR);
        TerraCommand.init();
        ConfigManager.init();
        event.enqueueWork(() -> {
            RegistrationEvents.registerCodecs();
            RegistrationEvents.registerMissingBiomeTypes();
        });
    }

    @SubscribeEvent
    public static void complete(FMLLoadCompleteEvent event) {
        Log.info("Loaded TerraForged version {}", TerraForgedMod.getVersion());
        TagFixer.markPostInit();
    }

    public static String getVersion() {
        return VERSION.get();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void update(TagsUpdatedEvent event) {
            Log.info("Tags Reloaded", new Object[0]);
            WGTags.printTags();
        }
    }
}

