/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.engine.world.terrain;

import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.engine.world.terrain.TerrainCategory;

public class ConfiguredTerrain
extends Terrain {
    private final float erosionModifier;
    private final boolean isMountain;
    private final boolean overridesRiver;

    ConfiguredTerrain(int id, String name, TerrainCategory category, float erosionModifier) {
        this(id, name, category, erosionModifier, category.isMountain(), category.overridesRiver());
    }

    ConfiguredTerrain(int id, String name, TerrainCategory category, boolean overridesRiver) {
        this(id, name, category, category.erosionModifier(), category.isMountain(), overridesRiver);
    }

    ConfiguredTerrain(int id, String name, TerrainCategory category, boolean isMountain, boolean overridesRiver) {
        this(id, name, category, category.erosionModifier(), isMountain, overridesRiver);
    }

    ConfiguredTerrain(int id, String name, TerrainCategory category, float erosionModifier, boolean isMountain, boolean overridesRiver) {
        super(id, name, category);
        this.erosionModifier = erosionModifier;
        this.isMountain = isMountain;
        this.overridesRiver = overridesRiver;
    }

    @Override
    public boolean overridesRiver() {
        return this.overridesRiver;
    }

    @Override
    public boolean isMountain() {
        return this.isMountain;
    }

    @Override
    public float erosionModifier() {
        return this.erosionModifier;
    }
}

