/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.nbt;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.RecordBuilder;
import com.terraforged.engine.serialization.serializer.AbstractWriter;
import com.terraforged.engine.serialization.serializer.Serializer;
import com.terraforged.mod.featuremanager.util.codec.CodecException;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;

public class DynamicWriter<T>
extends AbstractWriter<T, RecordBuilder<T>, ListBuilder<T>, DynamicWriter<T>> {
    private final DynamicOps<T> ops;

    public DynamicWriter(DynamicOps<T> ops) {
        this.ops = ops;
    }

    @Override
    protected DynamicWriter<T> self() {
        return this;
    }

    @Override
    protected boolean isObject(T value) {
        return this.ops.getMap(value).result().isPresent();
    }

    @Override
    protected boolean isArray(T value) {
        return this.ops.getList(value).result().isPresent();
    }

    @Override
    protected void add(RecordBuilder<T> parent, String key, T value) {
        parent.add(this.ops.createString(key), value);
    }

    @Override
    protected void add(ListBuilder<T> parent, T value) {
        parent.add(value);
    }

    @Override
    protected RecordBuilder<T> createObject() {
        return this.ops.mapBuilder();
    }

    @Override
    protected ListBuilder<T> createArray() {
        return this.ops.listBuilder();
    }

    @Override
    protected T closeObject(RecordBuilder<T> o) {
        return (T)o.build(this.ops.empty()).result().orElseGet(() -> this.ops.empty());
    }

    @Override
    protected T closeArray(ListBuilder<T> a) {
        return (T)a.build(this.ops.empty()).result().orElseGet(() -> this.ops.empty());
    }

    @Override
    protected T create(String value) {
        return (T)this.ops.createString(value);
    }

    @Override
    protected T create(int value) {
        return (T)this.ops.createInt(value);
    }

    @Override
    protected T create(float value) {
        return (T)this.ops.createFloat(value);
    }

    @Override
    protected T create(boolean value) {
        return (T)this.ops.createBoolean(value);
    }

    public static DynamicWriter<JsonElement> json() {
        return new DynamicWriter<JsonElement>((DynamicOps<JsonElement>)JsonOps.INSTANCE);
    }

    public static DynamicWriter<INBT> nbt() {
        return new DynamicWriter<INBT>((DynamicOps<INBT>)NBTDynamicOps.field_210820_a);
    }

    public static <T> DynamicWriter<T> of(DynamicOps<T> ops) {
        return new DynamicWriter<T>(ops);
    }

    public static <T> T serialize(Object value, DynamicOps<T> ops, boolean metaData) {
        DynamicWriter<T> writer = new DynamicWriter<T>(ops);
        try {
            Serializer.serialize(value, writer, metaData);
        }
        catch (IllegalAccessException e) {
            throw CodecException.of(e, "Failed to serialize value %s", value);
        }
        return writer.get();
    }
}

