/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.profiler.crash.test;

import com.terraforged.mod.Log;
import com.terraforged.mod.api.event.SetupEvent;
import com.terraforged.mod.featuremanager.matcher.BiomeFeatureMatcher;
import com.terraforged.mod.featuremanager.modifier.FeatureModifiers;
import com.terraforged.mod.featuremanager.transformer.FeatureAppender;
import com.terraforged.mod.profiler.crash.test.CrashTestConfig;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CrashTestFeature
extends Feature<CrashTestConfig> {
    public static final CrashTestFeature INSTANCE = new CrashTestFeature();
    private static final int CRASH_CHANCE_PERCENTAGE = 2;

    private CrashTestFeature() {
        super(CrashTestConfig.CODEC);
        this.setRegistryName("terraforged", "crashy_mccrashface");
    }

    public boolean place(ISeedReader region, ChunkGenerator generator, Random rand, BlockPos pos, CrashTestConfig config) {
        if (ThreadLocalRandom.current().nextInt(100) < 2) {
            switch (config.crashType) {
                case DEADLOCK: {
                    this.serverDeadlock(region, pos);
                    break;
                }
                case EXCEPTION: {
                    this.uncheckedException();
                    break;
                }
                case SLOW: {
                    this.generateSlowly(rand);
                }
            }
        }
        return true;
    }

    private void uncheckedException() {
        throw new NullPointerException("Crash time baby!");
    }

    private void generateSlowly(Random rand) {
        try {
            Thread.sleep(500 + rand.nextInt(500));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void serverDeadlock(ISeedReader region, BlockPos pos) {
        int x = 50 + pos.func_177958_n() >> 4;
        int z = 124 + pos.func_177952_p() >> 4;
        region.func_201672_e().func_212866_a_(x, z);
    }

    public static class Setup {
        @SubscribeEvent
        public static void setup(SetupEvent.Features event) {
            Log.info("Adding crash-test", new Object[0]);
            ((FeatureModifiers)((Object)event.getManager())).getAppenders().add(BiomeFeatureMatcher.ANY, FeatureAppender.head(GenerationStage.Decoration.VEGETAL_DECORATION, INSTANCE.func_225566_b_(new CrashTestConfig(CrashTestConfig.CrashType.SLOW))));
            ((FeatureModifiers)((Object)event.getManager())).getAppenders().add(BiomeFeatureMatcher.ANY, FeatureAppender.tail(GenerationStage.Decoration.VEGETAL_DECORATION, INSTANCE.func_225566_b_(new CrashTestConfig(CrashTestConfig.CrashType.DEADLOCK))));
        }
    }

    public static class Init {
        @SubscribeEvent
        public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
            Log.info("Registering crash-test feature", new Object[0]);
            event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
        }
    }
}

