/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.template.template;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.terraforged.mod.featuremanager.FeatureManager;
import com.terraforged.mod.featuremanager.data.DataManager;
import com.terraforged.mod.featuremanager.template.template.Template;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;

public class TemplateLoader {
    private final DataManager manager;
    private final Map<ResourceLocation, Template> cache = new HashMap<ResourceLocation, Template>();

    public TemplateLoader(DataManager manager) {
        this.manager = manager;
    }

    public List<Template> load(String namespace, JsonArray paths) {
        ArrayList<Template> list = new ArrayList<Template>();
        for (JsonElement element : paths) {
            ResourceLocation location = TemplateLoader.parsePath(namespace, element.getAsString());
            this.manager.forEach(location.func_110623_a(), DataManager.NBT, (name, data) -> {
                Template template = this.cache.get(name);
                if (template == null) {
                    Optional<Template> instance = Template.load(data);
                    if (instance.isPresent()) {
                        FeatureManager.LOG.debug("Loading template {}", (Object)name);
                        this.cache.put(name, instance.get());
                        list.add(instance.get());
                    } else {
                        FeatureManager.LOG.debug("Failed to load template {}", (Object)name);
                    }
                } else {
                    list.add(template);
                }
            });
        }
        return list;
    }

    private static ResourceLocation parsePath(String namespace, String path) {
        String location = path;
        int split = location.indexOf(58);
        if (split > 0) {
            namespace = location.substring(0, split);
            if (!(location = location.substring(split + 1)).startsWith("structures/")) {
                location = "structures/" + location;
            }
        }
        return new ResourceLocation(namespace, location);
    }
}

