/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.template.buffer;

import com.terraforged.mod.featuremanager.template.buffer.BufferBitSet;
import com.terraforged.mod.featuremanager.template.buffer.PasteBuffer;
import com.terraforged.mod.featuremanager.template.feature.Placement;
import com.terraforged.mod.featuremanager.template.paste.PasteConfig;
import com.terraforged.mod.featuremanager.template.template.BlockInfo;
import com.terraforged.noise.util.NoiseUtil;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;

public class TemplateBuffer
extends PasteBuffer {
    private IWorld world;
    private BlockPos origin;
    private final BufferBitSet placementMask = new BufferBitSet();

    public TemplateBuffer() {
        this.setRecording(true);
    }

    public TemplateBuffer init(IWorld world, BlockPos origin, Vector3i p1, Vector3i p2) {
        super.clear();
        this.placementMask.clear();
        this.world = world;
        this.origin = origin;
        this.placementMask.set(p1.func_177958_n(), p1.func_177956_o(), p1.func_177952_p(), p2.func_177958_n(), p2.func_177956_o(), p2.func_177952_p());
        return this;
    }

    public void record(int i, BlockInfo block, BlockPos pastePos, Placement placement, PasteConfig config) {
        if (!config.replaceSolid && !placement.canReplaceAt(this.world, pastePos)) {
            this.placementMask.set(block.pos.func_177958_n(), block.pos.func_177956_o(), block.pos.func_177952_p());
            return;
        }
        if (!config.pasteAir && block.state.func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        this.record(i);
    }

    public boolean test(BlockPos pos) {
        int dz;
        int dx = pos.func_177958_n() - this.origin.func_177958_n();
        if (dx == (dz = pos.func_177952_p() - this.origin.func_177952_p())) {
            return this.test(pos, 1.0f, 1.0f);
        }
        if (Math.abs(dx) > Math.abs(dz)) {
            return this.test(pos, 1.0f, (float)dz / (float)dx);
        }
        return this.test(pos, (float)dx / (float)dz, 1.0f);
    }

    private boolean test(BlockPos start, float dx, float dz) {
        int x = start.func_177958_n();
        int z = start.func_177952_p();
        float px = x;
        float pz = z;
        for (int count = 0; x != this.origin.func_177958_n() && z != this.origin.func_177952_p() && count < 10; ++count) {
            if (this.placementMask.test(x, start.func_177956_o(), z)) {
                return false;
            }
            x = NoiseUtil.floor(px -= dx);
            z = NoiseUtil.floor(pz -= dz);
        }
        return true;
    }
}

