/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.predicate;

import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.featuremanager.predicate.FeaturePredicate;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.IChunk;

public class BiomePredicate
implements FeaturePredicate {
    private final Set<Biome> biomes;

    private BiomePredicate(Set<Biome> biomes) {
        this.biomes = biomes;
    }

    @Override
    public boolean test(IChunk chunk, Biome biome) {
        BiomeContainer biomes = chunk.func_225549_i_();
        if (biomes == null) {
            return false;
        }
        for (int dz = 4; dz < 16; dz += 8) {
            for (int dx = 4; dx < 16; dx += 8) {
                Biome b = biomes.func_225526_b_(dx, 0, dz);
                if (this.biomes.contains(b)) continue;
                return false;
            }
        }
        return true;
    }

    public static BiomePredicate oceans(TFBiomeContext context) {
        return BiomePredicate.of(context, Biome.Category.OCEAN);
    }

    public static BiomePredicate of(TFBiomeContext context, Biome.Category ... categories) {
        HashSet<Biome> set = new HashSet<Biome>();
        block0: for (Biome biome : context.biomes) {
            for (Biome.Category category : categories) {
                if (biome.func_201856_r() != category) continue;
                set.add(biome);
                continue block0;
            }
        }
        return new BiomePredicate(set);
    }
}

