/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.modifier;

import com.google.gson.JsonElement;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.featuremanager.FeatureManager;
import com.terraforged.mod.featuremanager.FeatureSerializer;
import com.terraforged.mod.featuremanager.biome.BiomeFeature;
import com.terraforged.mod.featuremanager.modifier.Modifier;
import com.terraforged.mod.featuremanager.modifier.ModifierList;
import com.terraforged.mod.featuremanager.modifier.ModifierSet;
import com.terraforged.mod.featuremanager.predicate.BiomePredicate;
import com.terraforged.mod.featuremanager.predicate.FeaturePredicate;
import com.terraforged.mod.featuremanager.transformer.FeatureAppender;
import com.terraforged.mod.featuremanager.transformer.FeatureInjector;
import com.terraforged.mod.featuremanager.transformer.FeatureReplacer;
import com.terraforged.mod.featuremanager.transformer.FeatureTransformer;
import com.terraforged.mod.featuremanager.transformer.InjectionPosition;
import com.terraforged.mod.featuremanager.util.FeatureDebugger;
import com.terraforged.mod.featuremanager.util.identity.FeatureIdentifier;
import com.terraforged.mod.featuremanager.util.identity.Identifier;
import com.terraforged.mod.util.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.eventbus.api.Event;

public class FeatureModifiers
extends Event {
    private final ModifierList<FeatureReplacer> replacers = new ModifierList();
    private final ModifierList<FeatureInjector> injectors = new ModifierList();
    private final ModifierList<FeatureAppender> appenders = new ModifierList();
    private final ModifierList<FeatureTransformer> transformers = new ModifierList();
    private final ModifierList<FeaturePredicate> predicates = new ModifierList();
    private final TFBiomeContext context;

    public TFBiomeContext getContext() {
        return this.context;
    }

    public FeatureModifiers(TFBiomeContext context) {
        this.context = context;
    }

    public ModifierList<FeatureReplacer> getReplacers() {
        return this.replacers;
    }

    public ModifierList<FeatureInjector> getInjectors() {
        return this.injectors;
    }

    public ModifierList<FeatureAppender> getAppenders() {
        return this.appenders;
    }

    public ModifierList<FeaturePredicate> getPredicates() {
        return this.predicates;
    }

    public ModifierList<FeatureTransformer> getTransformers() {
        return this.transformers;
    }

    public void sort() {
        this.replacers.sort();
        this.predicates.sort();
        this.transformers.sort();
    }

    public List<BiomeFeature> getAppenders(GenerationStage.Decoration stage, Biome biome, InjectionPosition position) {
        return this.getAppenders(stage, position, biome);
    }

    public ModifierSet getFeature(GenerationStage.Decoration stage, Biome biome, ConfiguredFeature<?, ?> feature) {
        try {
            JsonElement element = FeatureSerializer.serialize(feature);
            ConfiguredFeature<?, ?> result = this.getFeature(biome, feature, element);
            if (result != feature) {
                element = FeatureSerializer.serialize(result);
            }
            FeatureIdentifier identity = FeatureIdentifier.getIdentity(feature, element);
            FeaturePredicate predicate = this.getPredicate(biome, element, identity);
            List<BiomeFeature> before = this.getInjectors(biome, predicate, element, InjectionPosition.BEFORE);
            List<BiomeFeature> after = this.getInjectors(biome, predicate, element, InjectionPosition.AFTER);
            return new ModifierSet(new BiomeFeature(predicate, result, identity), before, after);
        }
        catch (Throwable t) {
            String name = this.context.biomes.getName(biome);
            List<String> errors = FeatureDebugger.getErrors(feature);
            FeatureIdentifier identity = FeatureIdentifier.getIdentity(feature);
            FeatureManager.LOG.debug(FeatureSerializer.MARKER, "Unable to serialize feature in biome: {}, stage: {}, identity: {}", (Object)name, (Object)stage, (Object)identity);
            if (errors.isEmpty()) {
                FeatureManager.LOG.debug("Unable to determine issue(s). See stacktrace:", t);
            } else {
                for (String error : errors) {
                    FeatureManager.LOG.debug(FeatureSerializer.MARKER, " - {}", (Object)error);
                }
            }
            return new ModifierSet(new BiomeFeature(FeaturePredicate.ALLOW, feature, FeatureIdentifier.getIdentity(feature)));
        }
    }

    private ConfiguredFeature<?, ?> getFeature(Biome biome, ConfiguredFeature<?, ?> feature, JsonElement element) {
        if (element.isJsonNull()) {
            return feature;
        }
        for (Modifier<FeatureReplacer> modifier : this.replacers) {
            if (!modifier.getMatcher().test(biome, element)) continue;
            return modifier.getModifier().get();
        }
        boolean modified = false;
        for (Modifier<FeatureTransformer> modifier : this.transformers) {
            if (!modifier.getMatcher().test(biome, element)) continue;
            modified = true;
            element = modifier.getModifier().apply(element);
        }
        if (!modified) {
            return feature;
        }
        try {
            return FeatureSerializer.deserializeUnchecked(element);
        }
        catch (Throwable throwable) {
            FeatureManager.LOG.warn(FeatureSerializer.MARKER, "Unable to deserialize in feature json: {}", (Object)element);
            throwable.printStackTrace();
            return feature;
        }
    }

    private List<BiomeFeature> getInjectors(Biome biome, FeaturePredicate predicate, JsonElement element, InjectionPosition type) {
        List<BiomeFeature> result = Collections.emptyList();
        for (Modifier<FeatureInjector> modifier : this.getInjectors()) {
            if (modifier.getModifier().getPosition() != type || !modifier.getMatcher().test(biome, element)) continue;
            if (result.isEmpty()) {
                result = new ArrayList<BiomeFeature>();
            }
            ConfiguredFeature<?, ?> feature = modifier.getModifier().getFeature();
            FeatureIdentifier identity = FeatureIdentifier.getIdentity(feature);
            result.add(new BiomeFeature(predicate, feature, identity));
        }
        return result;
    }

    private List<BiomeFeature> getAppenders(GenerationStage.Decoration stage, InjectionPosition position, Biome biome) {
        List<BiomeFeature> result = Collections.emptyList();
        for (Modifier<FeatureAppender> modifier : this.getAppenders()) {
            if (modifier.getModifier().getPosition() != position || modifier.getModifier().getStage() != stage || !modifier.getMatcher().getBiomeMatcher().test(biome)) continue;
            if (result.isEmpty()) {
                result = new ArrayList<BiomeFeature>();
            }
            ConfiguredFeature<?, ?> feature = modifier.getModifier().getFeature();
            FeatureIdentifier identity = FeatureIdentifier.getIdentity(feature);
            result.add(new BiomeFeature(BiomePredicate.ALLOW, feature, identity));
        }
        return result;
    }

    private FeaturePredicate getPredicate(Biome biome, JsonElement element, Identifier identifier) {
        for (Modifier<FeaturePredicate> modifier : this.predicates) {
            if (!modifier.getMatcher().test(biome, element)) continue;
            if (Environment.isVerbose()) {
                String name = modifier.getMatcher().getName();
                String identity = identifier.getComponents();
                FeatureManager.LOG.debug("Adding feature predicate: Name: {}, Type: {}, Biome: {}, Feature: {}", (Object)name, (Object)modifier.getModifier(), (Object)biome.getRegistryName(), (Object)identity);
            }
            return modifier.getModifier();
        }
        return FeaturePredicate.ALLOW;
    }
}

