/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.matcher.dynamic;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;

public class DynamicMatcher
implements Predicate<ConfiguredFeature<?, ?>> {
    public static final DynamicMatcher NONE = DynamicMatcher.of((ConfiguredFeature<?, ?> f) -> false);
    private final Predicate<ConfiguredFeature<?, ?>> predicate;

    private DynamicMatcher(Predicate<ConfiguredFeature<?, ?>> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(ConfiguredFeature<?, ?> feature) {
        if (feature.field_222738_b instanceof DecoratedFeatureConfig) {
            return this.decorated((DecoratedFeatureConfig)feature.field_222738_b);
        }
        if (feature.field_222738_b instanceof SingleRandomFeature) {
            return this.single((SingleRandomFeature)feature.field_222738_b);
        }
        if (feature.field_222738_b instanceof TwoFeatureChoiceConfig) {
            return this.twoChoice((TwoFeatureChoiceConfig)feature.field_222738_b);
        }
        if (feature.field_222738_b instanceof MultipleRandomFeatureConfig) {
            return this.multi((MultipleRandomFeatureConfig)feature.field_222738_b);
        }
        return this.predicate.test(feature);
    }

    private boolean decorated(DecoratedFeatureConfig config) {
        return this.test((ConfiguredFeature)config.field_214689_a.get());
    }

    private boolean single(SingleRandomFeature config) {
        for (Supplier feature : config.field_204628_a) {
            if (!this.test((ConfiguredFeature)feature.get())) continue;
            return true;
        }
        return false;
    }

    private boolean twoChoice(TwoFeatureChoiceConfig config) {
        if (this.test((ConfiguredFeature)config.field_227285_a_.get())) {
            return true;
        }
        return this.test((ConfiguredFeature)config.field_227286_b_.get());
    }

    private boolean multi(MultipleRandomFeatureConfig config) {
        for (ConfiguredRandomFeatureList feature : config.field_202449_a) {
            if (!this.test((ConfiguredFeature)feature.field_214842_a.get())) continue;
            return true;
        }
        return false;
    }

    public static DynamicMatcher of(Predicate<ConfiguredFeature<?, ?>> predicate) {
        return new DynamicMatcher(predicate);
    }

    public static DynamicMatcher of(ConfiguredFeature<?, ?> feature) {
        return DynamicMatcher.of((ConfiguredFeature<?, ?> f) -> f == feature);
    }

    public static DynamicMatcher feature(Predicate<Feature<?>> predicate) {
        return DynamicMatcher.of((ConfiguredFeature<?, ?> f) -> predicate.test(f.field_222737_a));
    }

    public static DynamicMatcher feature(Feature<?> feature) {
        return DynamicMatcher.feature((Feature<?> f) -> f == feature);
    }

    public static DynamicMatcher feature(Class<? extends Feature> type) {
        return DynamicMatcher.feature(type::isInstance);
    }

    public static DynamicMatcher config(Predicate<IFeatureConfig> predicate) {
        return DynamicMatcher.of((ConfiguredFeature<?, ?> f) -> predicate.test(f.field_222738_b));
    }

    public static DynamicMatcher config(IFeatureConfig config) {
        return DynamicMatcher.of((ConfiguredFeature<?, ?> f) -> f.field_222738_b == config);
    }

    public static DynamicMatcher config(Class<? extends IFeatureConfig> type) {
        return DynamicMatcher.config(type::isInstance);
    }
}

